/*
 * Decompiled with CFR 0.152.
 */
package org.xnio.ssl;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.xnio.BufferAllocator;
import org.xnio.ByteBufferSlicePool;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.FutureResult;
import org.xnio.IoFuture;
import org.xnio.IoUtils;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pool;
import org.xnio.StreamConnection;
import org.xnio.Xnio;
import org.xnio.XnioExecutor;
import org.xnio.XnioIoThread;
import org.xnio.XnioWorker;
import org.xnio._private.Messages;
import org.xnio.channels.AcceptingChannel;
import org.xnio.channels.AssembledConnectedSslStreamChannel;
import org.xnio.channels.BoundChannel;
import org.xnio.channels.ConnectedSslStreamChannel;
import org.xnio.channels.ConnectedStreamChannel;
import org.xnio.channels.StreamSinkChannel;
import org.xnio.channels.StreamSourceChannel;
import org.xnio.ssl.JsseAcceptingSslStreamConnection;
import org.xnio.ssl.JsseSslConnection;
import org.xnio.ssl.JsseSslStreamConnection;
import org.xnio.ssl.JsseSslUtils;
import org.xnio.ssl.SslConnection;
import org.xnio.ssl.XnioSsl;

public final class JsseXnioSsl
extends XnioSsl {
    public static final boolean NEW_IMPL = AccessController.doPrivileged(() -> Boolean.parseBoolean(System.getProperty("org.xnio.ssl.new", "false")));
    static final Pool<ByteBuffer> bufferPool = new ByteBufferSlicePool(BufferAllocator.DIRECT_BYTE_BUFFER_ALLOCATOR, 21504, 0x2A0000);
    private final SSLContext sslContext;

    public JsseXnioSsl(Xnio xnio, OptionMap optionMap) throws NoSuchProviderException, NoSuchAlgorithmException, KeyManagementException {
        this(xnio, optionMap, JsseSslUtils.createSSLContext(optionMap));
    }

    public JsseXnioSsl(Xnio xnio, OptionMap optionMap, SSLContext sslContext) {
        super(xnio, sslContext, optionMap);
        this.sslContext = sslContext;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public static SSLEngine getSslEngine(SslConnection connection) {
        if (connection instanceof JsseSslStreamConnection) {
            return ((JsseSslStreamConnection)connection).getEngine();
        }
        if (connection instanceof JsseSslConnection) {
            return ((JsseSslConnection)connection).getEngine();
        }
        throw Messages.msg.notFromThisProvider();
    }

    @Override
    public IoFuture<ConnectedSslStreamChannel> connectSsl(XnioWorker worker, InetSocketAddress bindAddress, InetSocketAddress destination, final ChannelListener<? super ConnectedSslStreamChannel> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        final FutureResult futureResult = new FutureResult(IoUtils.directExecutor());
        IoFuture<SslConnection> futureSslConnection = this.openSslConnection(worker, bindAddress, destination, (ChannelListener<? super SslConnection>)new ChannelListener<SslConnection>(){

            @Override
            public void handleEvent(SslConnection sslConnection) {
                AssembledConnectedSslStreamChannel assembledChannel = new AssembledConnectedSslStreamChannel(sslConnection, (StreamSourceChannel)sslConnection.getSourceChannel(), (StreamSinkChannel)sslConnection.getSinkChannel());
                if (!futureResult.setResult(assembledChannel)) {
                    IoUtils.safeClose((Closeable)assembledChannel);
                } else {
                    ChannelListeners.invokeChannelListener(assembledChannel, openListener);
                }
            }
        }, bindListener, optionMap).addNotifier(new IoFuture.HandlingNotifier<SslConnection, FutureResult<ConnectedSslStreamChannel>>(){

            @Override
            public void handleCancelled(FutureResult<ConnectedSslStreamChannel> result) {
                result.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<ConnectedSslStreamChannel> result) {
                result.setException(exception);
            }
        }, futureResult);
        futureResult.getIoFuture().addNotifier(new IoFuture.HandlingNotifier<ConnectedStreamChannel, IoFuture<SslConnection>>(){

            @Override
            public void handleCancelled(IoFuture<SslConnection> result) {
                result.cancel();
            }
        }, futureSslConnection);
        futureResult.addCancelHandler(futureSslConnection);
        return futureResult.getIoFuture();
    }

    @Override
    public IoFuture<SslConnection> openSslConnection(XnioWorker worker, InetSocketAddress bindAddress, InetSocketAddress destination, ChannelListener<? super SslConnection> openListener, ChannelListener<? super BoundChannel> bindListener, OptionMap optionMap) {
        return this.openSslConnection(worker.getIoThread(), bindAddress, destination, openListener, bindListener, optionMap);
    }

    @Override
    public IoFuture<SslConnection> openSslConnection(XnioIoThread ioThread, InetSocketAddress bindAddress, final InetSocketAddress destination, final ChannelListener<? super SslConnection> openListener, ChannelListener<? super BoundChannel> bindListener, final OptionMap optionMap) {
        final FutureResult futureResult = new FutureResult(ioThread);
        IoFuture<StreamConnection> connection = ioThread.openStreamConnection(bindAddress, destination, (ChannelListener<? super StreamConnection>)new ChannelListener<StreamConnection>(){

            @Override
            public void handleEvent(StreamConnection connection) {
                SslConnection wrappedConnection;
                block7: {
                    SSLEngine sslEngine = JsseSslUtils.createSSLEngine(JsseXnioSsl.this.sslContext, optionMap, destination);
                    boolean startTls = optionMap.get(Options.SSL_STARTTLS, false);
                    try {
                        wrappedConnection = NEW_IMPL ? new JsseSslConnection(connection, sslEngine, bufferPool, bufferPool) : new JsseSslStreamConnection(connection, sslEngine, bufferPool, bufferPool, startTls);
                    }
                    catch (RuntimeException e2) {
                        futureResult.setCancelled();
                        throw e2;
                    }
                    if (NEW_IMPL && !startTls) {
                        try {
                            wrappedConnection.startHandshake();
                        }
                        catch (IOException e3) {
                            if (!futureResult.setException(e3)) break block7;
                            IoUtils.safeClose((Closeable)connection);
                        }
                    }
                }
                if (!futureResult.setResult(wrappedConnection)) {
                    IoUtils.safeClose((Closeable)connection);
                } else {
                    ChannelListeners.invokeChannelListener(wrappedConnection, openListener);
                }
            }
        }, bindListener, optionMap);
        connection.addNotifier(new IoFuture.HandlingNotifier<StreamConnection, FutureResult<SslConnection>>(){

            @Override
            public void handleCancelled(FutureResult<SslConnection> attachment) {
                attachment.setCancelled();
            }

            @Override
            public void handleFailed(IOException exception, FutureResult<SslConnection> attachment) {
                attachment.setException(exception);
            }
        }, futureResult);
        futureResult.addCancelHandler(connection);
        return futureResult.getIoFuture();
    }

    @Override
    public AcceptingChannel<ConnectedSslStreamChannel> createSslTcpServer(XnioWorker worker, InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<ConnectedSslStreamChannel>> acceptListener, OptionMap optionMap) throws IOException {
        final AcceptingChannel<SslConnection> server2 = this.createSslConnectionServer(worker, bindAddress, null, optionMap);
        AcceptingChannel<ConnectedSslStreamChannel> acceptingChannel = new AcceptingChannel<ConnectedSslStreamChannel>(){

            @Override
            public ConnectedSslStreamChannel accept() throws IOException {
                SslConnection connection = (SslConnection)server2.accept();
                return connection == null ? null : new AssembledConnectedSslStreamChannel(connection, (StreamSourceChannel)connection.getSourceChannel(), (StreamSinkChannel)connection.getSinkChannel());
            }

            @Override
            public ChannelListener.Setter<? extends AcceptingChannel<ConnectedSslStreamChannel>> getAcceptSetter() {
                return ChannelListeners.getDelegatingSetter(server2.getAcceptSetter(), this);
            }

            @Override
            public ChannelListener.Setter<? extends AcceptingChannel<ConnectedSslStreamChannel>> getCloseSetter() {
                return ChannelListeners.getDelegatingSetter(server2.getCloseSetter(), this);
            }

            @Override
            public SocketAddress getLocalAddress() {
                return server2.getLocalAddress();
            }

            @Override
            public <A extends SocketAddress> A getLocalAddress(Class<A> type2) {
                return server2.getLocalAddress(type2);
            }

            @Override
            public void suspendAccepts() {
                server2.suspendAccepts();
            }

            @Override
            public void resumeAccepts() {
                server2.resumeAccepts();
            }

            @Override
            public boolean isAcceptResumed() {
                return server2.isAcceptResumed();
            }

            @Override
            public void wakeupAccepts() {
                server2.wakeupAccepts();
            }

            @Override
            public void awaitAcceptable() throws IOException {
                server2.awaitAcceptable();
            }

            @Override
            public void awaitAcceptable(long time2, TimeUnit timeUnit) throws IOException {
                server2.awaitAcceptable(time2, timeUnit);
            }

            @Override
            public XnioWorker getWorker() {
                return server2.getWorker();
            }

            @Override
            @Deprecated
            public XnioExecutor getAcceptThread() {
                return server2.getAcceptThread();
            }

            @Override
            public XnioIoThread getIoThread() {
                return server2.getIoThread();
            }

            @Override
            public void close() throws IOException {
                server2.close();
            }

            @Override
            public boolean isOpen() {
                return server2.isOpen();
            }

            @Override
            public boolean supportsOption(Option<?> option) {
                return server2.supportsOption(option);
            }

            @Override
            public <T> T getOption(Option<T> option) throws IOException {
                return server2.getOption(option);
            }

            @Override
            public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
                return server2.setOption(option, value);
            }
        };
        acceptingChannel.getAcceptSetter().set(acceptListener);
        return acceptingChannel;
    }

    @Override
    public AcceptingChannel<SslConnection> createSslConnectionServer(XnioWorker worker, InetSocketAddress bindAddress, ChannelListener<? super AcceptingChannel<SslConnection>> acceptListener, OptionMap optionMap) throws IOException {
        JsseAcceptingSslStreamConnection server2 = new JsseAcceptingSslStreamConnection(this.sslContext, (AcceptingChannel<? extends StreamConnection>)worker.createStreamConnectionServer(bindAddress, null, optionMap), optionMap, bufferPool, bufferPool, optionMap.get(Options.SSL_STARTTLS, false));
        if (acceptListener != null) {
            server2.getAcceptSetter().set(acceptListener);
        }
        return server2;
    }
}

