import 'package:antlr4/antlr4.dart';


class BBCodeLexer extends Lexer {
  static final checkVersion = () => RuntimeMetaData.checkVersion('4.13.2', RuntimeMetaData.VERSION);

  static final List<DFA> _decisionToDFA = List.generate(
        _ATN.numberOfDecisions, (i) => DFA(_ATN.getDecisionState(i), i));
  static final PredictionContextCache _sharedContextCache = PredictionContextCache();
  static const int
    TOKEN_T__0 = 1, TOKEN_T__1 = 2, TOKEN_T__2 = 3, TOKEN_T__3 = 4, TOKEN_T__4 = 5, 
    TOKEN_T__5 = 6, TOKEN_T__6 = 7, TOKEN_T__7 = 8, TOKEN_T__8 = 9, TOKEN_T__9 = 10, 
    TOKEN_T__10 = 11, TOKEN_T__11 = 12, TOKEN_T__12 = 13, TOKEN_T__13 = 14, 
    TOKEN_T__14 = 15, TOKEN_T__15 = 16, TOKEN_T__16 = 17, TOKEN_T__17 = 18, 
    TOKEN_T__18 = 19, TOKEN_T__19 = 20, TOKEN_T__20 = 21, TOKEN_T__21 = 22, 
    TOKEN_T__22 = 23, TOKEN_T__23 = 24, TOKEN_T__24 = 25, TOKEN_T__25 = 26, 
    TOKEN_T__26 = 27, TOKEN_STRING = 28;
  @override
  final List<String> channelNames = [
    'DEFAULT_TOKEN_CHANNEL', 'HIDDEN'
  ];

  @override
  final List<String> modeNames = [
    'DEFAULT_MODE'
  ];

  @override
  final List<String> ruleNames = [
    'T__0', 'T__1', 'T__2', 'T__3', 'T__4', 'T__5', 'T__6', 'T__7', 'T__8', 
    'T__9', 'T__10', 'T__11', 'T__12', 'T__13', 'T__14', 'T__15', 'T__16', 
    'T__17', 'T__18', 'T__19', 'T__20', 'T__21', 'T__22', 'T__23', 'T__24', 
    'T__25', 'T__26', 'STRING'
  ];

  static final List<String?> _LITERAL_NAMES = [
      null, "'['", "'='", "']'", "'[/'", "'/'", "'('", "')'", "'[\\u6765\\u81EABangumi for android]'", 
      "'[\\u6765\\u81EABangumi for iOS]'", "'(bgm'", "'(BGM'", "'(=A=)'", 
      "'(=w=)'", "'(-w=)'", "'(S_S)'", "'(=v=)'", "'(@_@)'", "'(=W=)'", 
      "'(TAT)'", "'(T_T)'", "'(='=)'", "'(=3=)'", "'(= =')'", "'(=///=)'", 
      "'(=.,=)'", "'(:P)'", "'(LOL)'"
  ];
  static final List<String?> _SYMBOLIC_NAMES = [
      null, null, null, null, null, null, null, null, null, null, null, 
      null, null, null, null, null, null, null, null, null, null, null, 
      null, null, null, null, null, null, "STRING"
  ];
  static final Vocabulary VOCABULARY = VocabularyImpl(_LITERAL_NAMES, _SYMBOLIC_NAMES);

  @override
  Vocabulary get vocabulary {
    return VOCABULARY;
  }


  BBCodeLexer(CharStream input) : super(input) {
    interpreter = LexerATNSimulator(_ATN, _decisionToDFA, _sharedContextCache, recog: this);
  }

  @override
  List<int> get serializedATN => _serializedATN;

  @override
  String get grammarFileName => 'BBCode.g4';

  @override
  ATN getATN() { return _ATN; }

  static const List<int> _serializedATN = [
      4,0,28,230,6,-1,2,0,7,0,2,1,7,1,2,2,7,2,2,3,7,3,2,4,7,4,2,5,7,5,2,
      6,7,6,2,7,7,7,2,8,7,8,2,9,7,9,2,10,7,10,2,11,7,11,2,12,7,12,2,13,7,
      13,2,14,7,14,2,15,7,15,2,16,7,16,2,17,7,17,2,18,7,18,2,19,7,19,2,20,
      7,20,2,21,7,21,2,22,7,22,2,23,7,23,2,24,7,24,2,25,7,25,2,26,7,26,2,
      27,7,27,1,0,1,0,1,1,1,1,1,2,1,2,1,3,1,3,1,3,1,4,1,4,1,5,1,5,1,6,1,
      6,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,
      1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,7,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,
      8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,8,1,9,1,9,1,9,1,9,1,9,
      1,10,1,10,1,10,1,10,1,10,1,11,1,11,1,11,1,11,1,11,1,11,1,12,1,12,1,
      12,1,12,1,12,1,12,1,13,1,13,1,13,1,13,1,13,1,13,1,14,1,14,1,14,1,14,
      1,14,1,14,1,15,1,15,1,15,1,15,1,15,1,15,1,16,1,16,1,16,1,16,1,16,1,
      16,1,17,1,17,1,17,1,17,1,17,1,17,1,18,1,18,1,18,1,18,1,18,1,18,1,19,
      1,19,1,19,1,19,1,19,1,19,1,20,1,20,1,20,1,20,1,20,1,20,1,21,1,21,1,
      21,1,21,1,21,1,21,1,22,1,22,1,22,1,22,1,22,1,22,1,22,1,23,1,23,1,23,
      1,23,1,23,1,23,1,23,1,23,1,24,1,24,1,24,1,24,1,24,1,24,1,24,1,25,1,
      25,1,25,1,25,1,25,1,26,1,26,1,26,1,26,1,26,1,26,1,27,4,27,227,8,27,
      11,27,12,27,228,0,0,28,1,1,3,2,5,3,7,4,9,5,11,6,13,7,15,8,17,9,19,
      10,21,11,23,12,25,13,27,14,29,15,31,16,33,17,35,18,37,19,39,20,41,
      21,43,22,45,23,47,24,49,25,51,26,53,27,55,28,1,0,1,4,0,40,41,61,61,
      91,91,93,93,230,0,1,1,0,0,0,0,3,1,0,0,0,0,5,1,0,0,0,0,7,1,0,0,0,0,
      9,1,0,0,0,0,11,1,0,0,0,0,13,1,0,0,0,0,15,1,0,0,0,0,17,1,0,0,0,0,19,
      1,0,0,0,0,21,1,0,0,0,0,23,1,0,0,0,0,25,1,0,0,0,0,27,1,0,0,0,0,29,1,
      0,0,0,0,31,1,0,0,0,0,33,1,0,0,0,0,35,1,0,0,0,0,37,1,0,0,0,0,39,1,0,
      0,0,0,41,1,0,0,0,0,43,1,0,0,0,0,45,1,0,0,0,0,47,1,0,0,0,0,49,1,0,0,
      0,0,51,1,0,0,0,0,53,1,0,0,0,0,55,1,0,0,0,1,57,1,0,0,0,3,59,1,0,0,0,
      5,61,1,0,0,0,7,63,1,0,0,0,9,66,1,0,0,0,11,68,1,0,0,0,13,70,1,0,0,0,
      15,72,1,0,0,0,17,96,1,0,0,0,19,116,1,0,0,0,21,121,1,0,0,0,23,126,1,
      0,0,0,25,132,1,0,0,0,27,138,1,0,0,0,29,144,1,0,0,0,31,150,1,0,0,0,
      33,156,1,0,0,0,35,162,1,0,0,0,37,168,1,0,0,0,39,174,1,0,0,0,41,180,
      1,0,0,0,43,186,1,0,0,0,45,192,1,0,0,0,47,199,1,0,0,0,49,207,1,0,0,
      0,51,214,1,0,0,0,53,219,1,0,0,0,55,226,1,0,0,0,57,58,5,91,0,0,58,2,
      1,0,0,0,59,60,5,61,0,0,60,4,1,0,0,0,61,62,5,93,0,0,62,6,1,0,0,0,63,
      64,5,91,0,0,64,65,5,47,0,0,65,8,1,0,0,0,66,67,5,47,0,0,67,10,1,0,0,
      0,68,69,5,40,0,0,69,12,1,0,0,0,70,71,5,41,0,0,71,14,1,0,0,0,72,73,
      5,91,0,0,73,74,5,26469,0,0,74,75,5,33258,0,0,75,76,5,66,0,0,76,77,
      5,97,0,0,77,78,5,110,0,0,78,79,5,103,0,0,79,80,5,117,0,0,80,81,5,109,
      0,0,81,82,5,105,0,0,82,83,5,32,0,0,83,84,5,102,0,0,84,85,5,111,0,0,
      85,86,5,114,0,0,86,87,5,32,0,0,87,88,5,97,0,0,88,89,5,110,0,0,89,90,
      5,100,0,0,90,91,5,114,0,0,91,92,5,111,0,0,92,93,5,105,0,0,93,94,5,
      100,0,0,94,95,5,93,0,0,95,16,1,0,0,0,96,97,5,91,0,0,97,98,5,26469,
      0,0,98,99,5,33258,0,0,99,100,5,66,0,0,100,101,5,97,0,0,101,102,5,110,
      0,0,102,103,5,103,0,0,103,104,5,117,0,0,104,105,5,109,0,0,105,106,
      5,105,0,0,106,107,5,32,0,0,107,108,5,102,0,0,108,109,5,111,0,0,109,
      110,5,114,0,0,110,111,5,32,0,0,111,112,5,105,0,0,112,113,5,79,0,0,
      113,114,5,83,0,0,114,115,5,93,0,0,115,18,1,0,0,0,116,117,5,40,0,0,
      117,118,5,98,0,0,118,119,5,103,0,0,119,120,5,109,0,0,120,20,1,0,0,
      0,121,122,5,40,0,0,122,123,5,66,0,0,123,124,5,71,0,0,124,125,5,77,
      0,0,125,22,1,0,0,0,126,127,5,40,0,0,127,128,5,61,0,0,128,129,5,65,
      0,0,129,130,5,61,0,0,130,131,5,41,0,0,131,24,1,0,0,0,132,133,5,40,
      0,0,133,134,5,61,0,0,134,135,5,119,0,0,135,136,5,61,0,0,136,137,5,
      41,0,0,137,26,1,0,0,0,138,139,5,40,0,0,139,140,5,45,0,0,140,141,5,
      119,0,0,141,142,5,61,0,0,142,143,5,41,0,0,143,28,1,0,0,0,144,145,5,
      40,0,0,145,146,5,83,0,0,146,147,5,95,0,0,147,148,5,83,0,0,148,149,
      5,41,0,0,149,30,1,0,0,0,150,151,5,40,0,0,151,152,5,61,0,0,152,153,
      5,118,0,0,153,154,5,61,0,0,154,155,5,41,0,0,155,32,1,0,0,0,156,157,
      5,40,0,0,157,158,5,64,0,0,158,159,5,95,0,0,159,160,5,64,0,0,160,161,
      5,41,0,0,161,34,1,0,0,0,162,163,5,40,0,0,163,164,5,61,0,0,164,165,
      5,87,0,0,165,166,5,61,0,0,166,167,5,41,0,0,167,36,1,0,0,0,168,169,
      5,40,0,0,169,170,5,84,0,0,170,171,5,65,0,0,171,172,5,84,0,0,172,173,
      5,41,0,0,173,38,1,0,0,0,174,175,5,40,0,0,175,176,5,84,0,0,176,177,
      5,95,0,0,177,178,5,84,0,0,178,179,5,41,0,0,179,40,1,0,0,0,180,181,
      5,40,0,0,181,182,5,61,0,0,182,183,5,39,0,0,183,184,5,61,0,0,184,185,
      5,41,0,0,185,42,1,0,0,0,186,187,5,40,0,0,187,188,5,61,0,0,188,189,
      5,51,0,0,189,190,5,61,0,0,190,191,5,41,0,0,191,44,1,0,0,0,192,193,
      5,40,0,0,193,194,5,61,0,0,194,195,5,32,0,0,195,196,5,61,0,0,196,197,
      5,39,0,0,197,198,5,41,0,0,198,46,1,0,0,0,199,200,5,40,0,0,200,201,
      5,61,0,0,201,202,5,47,0,0,202,203,5,47,0,0,203,204,5,47,0,0,204,205,
      5,61,0,0,205,206,5,41,0,0,206,48,1,0,0,0,207,208,5,40,0,0,208,209,
      5,61,0,0,209,210,5,46,0,0,210,211,5,44,0,0,211,212,5,61,0,0,212,213,
      5,41,0,0,213,50,1,0,0,0,214,215,5,40,0,0,215,216,5,58,0,0,216,217,
      5,80,0,0,217,218,5,41,0,0,218,52,1,0,0,0,219,220,5,40,0,0,220,221,
      5,76,0,0,221,222,5,79,0,0,222,223,5,76,0,0,223,224,5,41,0,0,224,54,
      1,0,0,0,225,227,8,0,0,0,226,225,1,0,0,0,227,228,1,0,0,0,228,226,1,
      0,0,0,228,229,1,0,0,0,229,56,1,0,0,0,2,0,228,0
  ];

  static final ATN _ATN =
      ATNDeserializer().deserialize(_serializedATN);
}