#include "stdint.h"
#include "common_api.h"
#include "luat_i2c.h"
#include "luat_debug.h"

#define GC0310_I2C_ADDR		(0x21)

typedef struct
{
	uint8_t reg;
	uint8_t data;
}camera_reg_t;

static const camera_reg_t gc0310_reg_table[] =
{
        {0xfe, 0xf0},
        {0xfe, 0xf0},
        {0xfe, 0x00},
        {0xfc, 0x16},
        {0xfc, 0x16},
        {0xf2, 0x07},
        {0xf3, 0x83},
        {0xf5, 0x07},
        {0xf7, 0x88},
        {0xf8, 0x00},
        {0xf9, 0x4f},
        {0xfa, 0x11},
        {0xfc, 0xce},
        {0xfd, 0x00},

        /////////////////////////////////////////////////
        /////////////////	 CISCTL reg  /////////////////
        /////////////////////////////////////////////////
        {0x00, 0x2f},
        {0x01, 0x0f},
        {0x02, 0x04},
        {0x03, 0x02},
        {0x04, 0x12},
        {0x09, 0x00},
        {0x0a, 0x00},
        {0x0b, 0x00},
        {0x0c, 0x04},
        {0x0d, 0x01},
        {0x0e, 0xe8},
        {0x0f, 0x02},
        {0x10, 0x88},
        {0x16, 0x00},
        {0x17, 0x14},
        {0x18, 0x1a},
        {0x19, 0x14},
        {0x1b, 0x48},
        {0x1c, 0x6c},
        {0x1e, 0x6b},
        {0x1f, 0x28},
        {0x20, 0x8b},
        {0x21, 0x49},
        {0x22, 0xd0},
        {0x23, 0x04},
        {0x24, 0xff},
        {0x34, 0x20},
        /////////////////////////////////////////////////
        ////////////////////	BLK   ////////////////////
        /////////////////////////////////////////////////
        {0x26, 0x23}, //[1]dark_current_en [0]offset_en
        {0x28, 0xff}, //BLK_limie_value
        {0x29, 0x00}, //global offset
        {0x32, 0x04},
        {0x33, 0x10}, //offset_ratio
        {0x37, 0x20}, //dark_current_ratio
        {0x38, 0x10},
        {0x47, 0x80}, //a7
        {0x4e, 0x66}, //select_row
        {0xa8, 0x02}, //win_width_dark, same with crop_win_width
        {0xa9, 0x80},
        /////////////////////////////////////////////////
        //////////////////   ISP reg  ///////////////////
        /////////////////////////////////////////////////
        {0x40, 0xff},
        {0x41, 0x21}, //00//[0]curve_en
        {0x42, 0xcf}, //0a//[1]awn_en
//        {0x44, 0x00},
        {0x45, 0xa0},
        {0x46, 0x02}, //03//sync
        {0x4a, 0x11},
        {0x4b, 0x01},
        {0x4c, 0x20}, //00[5]pretect exp
        {0x4d, 0x05}, //update gain mode
        {0x4f, 0x01},
        {0x50, 0x01}, //crop enable
        {0x55, 0x01}, //crop window height
        {0x56, 0xe0},
        {0x57, 0x02}, //crop window width
        {0x58, 0x80},
        /////////////////////////////////////////////////
        ///////////////////   GAIN   ////////////////////
        /////////////////////////////////////////////////
        {0x70, 0x70},
        {0x5a, 0x84},
        {0x5b, 0xc9},
        {0x5c, 0xed},
        {0x77, 0x74},
        {0x78, 0x40},
        {0x79, 0x5f},
        /////////////////////////////////////////////////
        ///////////////////   DNDD  /////////////////////
        /////////////////////////////////////////////////
        {0x82, 0x14},
        {0x83, 0x0b},
        {0x89, 0xf0},
        /////////////////////////////////////////////////
        //////////////////   EEINTP  ////////////////////
        /////////////////////////////////////////////////
        {0x8f, 0xaa},
        {0x90, 0x8c},
        {0x91, 0x90},
        {0x92, 0x03},
        {0x93, 0x03},
        {0x94, 0x05},
        {0x95, 0x65},
        {0x96, 0xf0},
        /////////////////////////////////////////////////
        /////////////////////	ASDE  ////////////////////
        /////////////////////////////////////////////////
        {0xfe, 0x00},
        {0x9a, 0x20},
        {0x9b, 0x80},
        {0x9c, 0x40},
        {0x9d, 0x80},
        {0xa1, 0x30},
        {0xa2, 0x32},
        {0xa4, 0x30}, //30 travis 20140929
        {0xa5, 0x30}, //30 travis 20140929
        {0xaa, 0x10}, //10 travis 20140929
        {0xac, 0x22},
        /////////////////////////////////////////////////
        ///////////////////   GAMMA   ///////////////////
        /////////////////////////////////////////////////
        {0xfe, 0x00},
        {0xbf, 0x08},
        {0xc0, 0x16},
        {0xc1, 0x28},
        {0xc2, 0x41},
        {0xc3, 0x5a},
        {0xc4, 0x6c},
        {0xc5, 0x7a},
        {0xc6, 0x96},
        {0xc7, 0xac},
        {0xc8, 0xbc},
        {0xc9, 0xc9},
        {0xca, 0xd3},
        {0xcb, 0xdd},
        {0xcc, 0xe5},
        {0xcd, 0xf1},
        {0xce, 0xfa},
        {0xcf, 0xff},
        /////////////////////////////////////////////////
        ///////////////////   YCP	//////////////////////
        /////////////////////////////////////////////////
        {0xd0, 0x40},
        {0xd1, 0x34},
        {0xd2, 0x34},
        {0xd3, 0x40},
        {0xd6, 0xf2},
        {0xd7, 0x1b},
        {0xd8, 0x18},
        {0xdd, 0x03},
        /////////////////////////////////////////////////
        ////////////////////	AEC   ////////////////////
        /////////////////////////////////////////////////
        {0xfe, 0x01},
        {0x05, 0x30},
        {0x06, 0x75},
        {0x07, 0x40},
        {0x08, 0xb0},
        {0x0a, 0xc5},
        {0x0b, 0x11},
        {0x0c, 0x00},
        {0x12, 0x52},
        {0x13, 0x38},
        {0x18, 0x95},
        {0x19, 0x96},
        {0x1f, 0x20},
        {0x20, 0xc0},
        {0x3e, 0x40},
        {0x3f, 0x57},
        {0x40, 0x7d},
        {0x03, 0x60},
        {0x44, 0x00},
        /////////////////////////////////////////////////
        ////////////////////	AWB   ////////////////////
        /////////////////////////////////////////////////
        {0xfe, 0x01},
        {0x1c, 0x91},
        {0x21, 0x15},
        {0x50, 0x80},
        {0x56, 0x04},
        {0x59, 0x08},
        {0x5b, 0x02},
        {0x61, 0x8d},
        {0x62, 0xa7},
        {0x63, 0xd0},
        {0x65, 0x06},
        {0x66, 0x06},
        {0x67, 0x84},
        {0x69, 0x08},
        {0x6a, 0x25},
        {0x6b, 0x01},
        {0x6c, 0x00},
        {0x6d, 0x02},
        {0x6e, 0xf0},
        {0x6f, 0x80},
        {0x76, 0x80},
        {0x78, 0xaf},
        {0x79, 0x75},
        {0x7a, 0x40},
        {0x7b, 0x50},
        {0x7c, 0x0c},
        {0x90, 0xc9}, //stable AWB
        {0x91, 0xbe},
        {0x92, 0xe2},
        {0x93, 0xc9},
        {0x95, 0x1b},
        {0x96, 0xe2},
        {0x97, 0x49},
        {0x98, 0x1b},
        {0x9a, 0x49},
        {0x9b, 0x1b},
        {0x9c, 0xc3},
        {0x9d, 0x49},
        {0x9f, 0xc7},
        {0xa0, 0xc8},
        {0xa1, 0x00},
        {0xa2, 0x00},
        {0x86, 0x00},
        {0x87, 0x00},
        {0x88, 0x00},
        {0x89, 0x00},
        {0xa4, 0xb9},
        {0xa5, 0xa0},
        {0xa6, 0xba},
        {0xa7, 0x92},
        {0xa9, 0xba},
        {0xaa, 0x80},
        {0xab, 0x9d},
        {0xac, 0x7f},
        {0xae, 0xbb},
        {0xaf, 0x9d},
        {0xb0, 0xc8},
        {0xb1, 0x97},
        {0xb3, 0xb7},
        {0xb4, 0x7f},
        {0xb5, 0x00},
        {0xb6, 0x00},
        {0x8b, 0x00},
        {0x8c, 0x00},
        {0x8d, 0x00},
        {0x8e, 0x00},
        {0x94, 0x55},
        {0x99, 0xa6},
        {0x9e, 0xaa},
        {0xa3, 0x0a},
        {0x8a, 0x00},
        {0xa8, 0x55},
        {0xad, 0x55},
        {0xb2, 0x55},
        {0xb7, 0x05},
        {0x8f, 0x00},
        {0xb8, 0xcb},
        {0xb9, 0x9b},
        /////////////////////////////////////////////////
        ////////////////////	CC	  ////////////////////
        /////////////////////////////////////////////////
        {0xfe, 0x01},
        //red skin
        {0xd0, 0x38}, //red
        {0xd1, 0x00},
        {0xd2, 0x02},
        {0xd3, 0x04},
        {0xd4, 0x38},
        {0xd5, 0x12},
        {0xd6, 0x30},
        {0xd7, 0x00},
        {0xd8, 0x0a},
        {0xd9, 0x16},
        {0xda, 0x39},
        {0xdb, 0xf8},
        /////////////////////////////////////////////////
        ////////////////////	LSC   ////////////////////
        /////////////////////////////////////////////////
        {0xfe, 0x01},
        {0xc1, 0x3c},
        {0xc2, 0x50},
        {0xc3, 0x00},
        {0xc4, 0x40},
        {0xc5, 0x30},
        {0xc6, 0x30},
        {0xc7, 0x10},
        {0xc8, 0x00},
        {0xc9, 0x00},
        {0xdc, 0x20},
        {0xdd, 0x10},
        {0xdf, 0x00},
        {0xde, 0x00},
        /////////////////////////////////////////////////
        ///////////////////  Histogram  /////////////////
        /////////////////////////////////////////////////
        {0x01, 0x10},
        {0x0b, 0x31}, //11
        {0x0e, 0x50},
        {0x0f, 0x0f},
        {0x10, 0x6e},
        {0x12, 0xa0},
        {0x15, 0x60},
        {0x16, 0x60},
        {0x17, 0xe0},
        /////////////////////////////////////////////////
        //////////////   Measure Window   ///////////////
        /////////////////////////////////////////////////
        {0xcc, 0x0c}, //aec window size
        {0xcd, 0x10},
        {0xce, 0xa0},
        {0xcf, 0xe6},
        /////////////////////////////////////////////////
        /////////////////	 dark sun	//////////////////
        /////////////////////////////////////////////////
        {0x45, 0xf7},
        {0x46, 0xff}, //f0//sun vaule th
        {0x47, 0x15},
        {0x48, 0x03}, //sun mode
        {0x4f, 0x60}, //sun_clamp
        //based on 24MHz MCLK;24MHz 2PCLK 12M
        {0xfe, 0x00},
        {0x05, 0x01},
        {0x06, 0x32}, //HB
        {0x07, 0x00},
        {0x08, 0x0c}, //VB
        {0xfe, 0x01},
        {0x25, 0x00}, //step
        {0x26, 0x3c},
        {0x27, 0x01}, //20fps
        {0x28, 0xdc},
        {0x29, 0x01}, //12.5fps
        {0x2a, 0xe0},
        {0x2b, 0x01}, //8.33fps
        {0x2c, 0xe0},
        {0x2d, 0x01}, //5.55fps
        {0x2e, 0xe0},
        {0x3c, 0x20},
        /////////////////////	SPI   ////////////////////
        /////////////////////////////////////////////////
        {0xfe, 0x03},
//        {0x01, 0x00},
//        {0x02, 0x00},
//        {0x10, 0x00},
//        {0x15, 0x00},
//        {0x17, 0x00}, //01//03
//        {0x04, 0x10},
//        {0x05, 0x00},
//        {0x40, 0x00},
        {0x52, 0xa2}, //a2 //a0//80//00
        {0x53, 0x24}, //24
        {0x54, 0x20},
	    {0x55, 0x00},
	    {0x59, 0x1f}, // {0x59,0x10}, 20190627 scaler output error
	    {0x5a, 0x00}, //00 //yuv hai: from 0x40 to 0x00
        {0x5b, 0x80},
        {0x5c, 0x02},
        {0x5d, 0xe0},
        {0x5e, 0x01},
        {0x51, 0x03},
        {0x64, 0x04},
        {0xfe, 0x00},

	{0x44, 0x02},	//透传到LCD能正常显示颜色需要
};

int gc0310_reg_init(int i2c_id)
{
	for(int i = 0; i < sizeof(gc0310_reg_table)/sizeof(camera_reg_t); i++)
	{
		if (luat_i2c_send(i2c_id, GC0310_I2C_ADDR, (void *)&gc0310_reg_table[i].reg, 2, 1))
		{
			LUAT_DEBUG_PRINT("write %d %x,%x failed", i, gc0310_reg_table[i].reg, gc0310_reg_table[i].data);
			return -1;
		}
	}
	return 0;
}
