/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.appear;

import com.cburch.contracts.BaseMouseListenerContract;
import com.cburch.contracts.BaseMouseMotionListenerContract;
import com.cburch.draw.canvas.SelectionEvent;
import com.cburch.draw.canvas.SelectionListener;
import com.cburch.draw.model.CanvasObject;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.circuit.appear.AppearancePort;
import com.cburch.logisim.circuit.appear.DynamicElement;
import com.cburch.logisim.data.Location;
import com.cburch.logisim.gui.appear.AppearanceCanvas;
import com.cburch.logisim.gui.appear.LayoutThumbnail;
import com.cburch.logisim.gui.generic.CanvasPane;
import com.cburch.logisim.instance.Instance;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JViewport;
import javax.swing.Popup;
import javax.swing.PopupFactory;

class LayoutPopupManager
implements SelectionListener,
BaseMouseListenerContract,
BaseMouseMotionListenerContract {
    private final CanvasPane canvasPane;
    private final AppearanceCanvas canvas;
    private Popup curPopup;
    private long curPopupTime;
    private Location dragStart;

    public LayoutPopupManager(CanvasPane canvasPane, AppearanceCanvas canvas) {
        this.canvasPane = canvasPane;
        this.canvas = canvas;
        this.curPopup = null;
        this.dragStart = null;
        canvas.getSelection().addSelectionListener(this);
        canvas.addMouseListener(this);
        canvas.addMouseMotionListener(this);
    }

    private Set<AppearancePort> getSelectedPorts() {
        HashSet<AppearancePort> ports = new HashSet<AppearancePort>();
        for (CanvasObject o : this.canvas.getSelection().getSelected()) {
            if (!(o instanceof AppearancePort)) continue;
            AppearancePort appPort = (AppearancePort)o;
            ports.add(appPort);
        }
        return ports;
    }

    private void addSelectedDynamicElements(HashSet<CanvasObject> hilight) {
        for (CanvasObject obj : this.canvas.getSelection().getSelected()) {
            if (!(obj instanceof DynamicElement)) continue;
            hilight.add(obj);
        }
    }

    public void hideCurrentPopup() {
        Popup cur = this.curPopup;
        if (cur != null) {
            this.curPopup = null;
            this.dragStart = null;
            cur.hide();
        }
    }

    private boolean isPortUnselected(Set<AppearancePort> selected) {
        for (CanvasObject obj : this.canvas.getModel().getObjectsFromBottom()) {
            if (!(obj instanceof AppearancePort) || selected.contains(obj)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        Location start = this.dragStart;
        if (start != null && start.manhattanDistanceTo(e.getX(), e.getY()) > 4) {
            this.hideCurrentPopup();
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        this.hideCurrentPopup();
    }

    @Override
    public void mouseExited(MouseEvent e) {
        long sincePopup = System.currentTimeMillis() - this.curPopupTime;
        if (sincePopup > 50L) {
            this.hideCurrentPopup();
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
        long sincePopup = System.currentTimeMillis() - this.curPopupTime;
        if (sincePopup > 50L) {
            this.hideCurrentPopup();
        }
        this.dragStart = Location.create(e.getX(), e.getY(), false);
    }

    @Override
    public void selectionChanged(SelectionEvent e) {
        int act = e.getAction();
        if (act == 0) {
            Set<CanvasObject> shapes = this.shouldShowPopup(e.getAffected());
            if (shapes == null) {
                this.hideCurrentPopup();
            } else {
                this.showPopup(shapes);
            }
        }
    }

    private Set<CanvasObject> shouldShowPopup(Collection<CanvasObject> add) {
        boolean found = false;
        for (CanvasObject obj : add) {
            if (!(obj instanceof AppearancePort) && !(obj instanceof DynamicElement)) continue;
            found = true;
            break;
        }
        if (found) {
            HashSet<CanvasObject> hilight = new HashSet<CanvasObject>();
            Set<AppearancePort> ports = this.getSelectedPorts();
            if (!ports.isEmpty() && this.isPortUnselected(ports)) {
                hilight.addAll(ports);
            }
            this.addSelectedDynamicElements(hilight);
            if (hilight.size() > 0) {
                return hilight;
            }
        }
        return null;
    }

    private void showPopup(Set<CanvasObject> shapes) {
        this.dragStart = null;
        CircuitState circuitState = this.canvas.getCircuitState();
        if (circuitState == null) {
            return;
        }
        ArrayList<Instance> pins = new ArrayList<Instance>();
        ArrayList<Instance> elts = new ArrayList<Instance>();
        for (CanvasObject shape : shapes) {
            if (shape instanceof AppearancePort) {
                AppearancePort appPort = (AppearancePort)shape;
                pins.add(appPort.getPin());
                continue;
            }
            elts.add(((DynamicElement)shape).getFirstInstance().getInstance());
        }
        this.hideCurrentPopup();
        JViewport owner = this.canvasPane.getViewport();
        Point ownerLoc = owner.getLocationOnScreen();
        Dimension ownerDim = owner.getSize();
        Dimension layoutDim = new Dimension((int)(ownerDim.getWidth() - 10.0), (int)(ownerDim.getHeight() / 2.0));
        LayoutThumbnail layout = new LayoutThumbnail(layoutDim);
        layout.setCircuit(circuitState, pins, elts);
        int x = ownerLoc.x + Math.max(0, ownerDim.width - layoutDim.width - 5);
        int y = ownerLoc.y + Math.max(0, ownerDim.height - layoutDim.height - 5);
        PopupFactory factory = PopupFactory.getSharedInstance();
        Popup popup = factory.getPopup(this.canvasPane.getViewport(), layout, x, y);
        popup.show();
        this.curPopup = popup;
        this.curPopupTime = System.currentTimeMillis();
    }
}

