/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.gui.main;

import com.cburch.draw.toolbar.Toolbar;
import com.cburch.logisim.circuit.Circuit;
import com.cburch.logisim.circuit.CircuitEvent;
import com.cburch.logisim.circuit.CircuitListener;
import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.comp.Component;
import com.cburch.logisim.data.AttributeEvent;
import com.cburch.logisim.data.AttributeSet;
import com.cburch.logisim.data.Direction;
import com.cburch.logisim.file.LibraryEvent;
import com.cburch.logisim.file.LibraryListener;
import com.cburch.logisim.generated.BuildInfo;
import com.cburch.logisim.gui.Strings;
import com.cburch.logisim.gui.appear.AppearanceView;
import com.cburch.logisim.gui.generic.AttrTable;
import com.cburch.logisim.gui.generic.AttrTableModel;
import com.cburch.logisim.gui.generic.AttributeSetTableModel;
import com.cburch.logisim.gui.generic.BasicZoomModel;
import com.cburch.logisim.gui.generic.CanvasPane;
import com.cburch.logisim.gui.generic.CardPanel;
import com.cburch.logisim.gui.generic.LFrame;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.generic.RegTabContent;
import com.cburch.logisim.gui.generic.ZoomControl;
import com.cburch.logisim.gui.generic.ZoomModel;
import com.cburch.logisim.gui.main.AttrTableCircuitModel;
import com.cburch.logisim.gui.main.AttrTableComponentModel;
import com.cburch.logisim.gui.main.AttrTableSelectionModel;
import com.cburch.logisim.gui.main.AttrTableToolModel;
import com.cburch.logisim.gui.main.Canvas;
import com.cburch.logisim.gui.main.KeyboardToolSelection;
import com.cburch.logisim.gui.main.LayoutEditHandler;
import com.cburch.logisim.gui.main.LayoutToolbarModel;
import com.cburch.logisim.gui.main.SelectionAttributes;
import com.cburch.logisim.gui.main.SimulationExplorer;
import com.cburch.logisim.gui.main.Toolbox;
import com.cburch.logisim.gui.menu.MainMenuListener;
import com.cburch.logisim.prefs.AppPreferences;
import com.cburch.logisim.proj.Project;
import com.cburch.logisim.proj.ProjectActions;
import com.cburch.logisim.proj.ProjectEvent;
import com.cburch.logisim.proj.ProjectListener;
import com.cburch.logisim.proj.Projects;
import com.cburch.logisim.tools.Tool;
import com.cburch.logisim.util.HorizontalSplitPane;
import com.cburch.logisim.util.JFileChoosers;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.VerticalSplitPane;
import com.cburch.logisim.vhdl.base.HdlModel;
import com.cburch.logisim.vhdl.gui.HdlContentView;
import com.cburch.logisim.vhdl.gui.VhdlSimState;
import com.cburch.logisim.vhdl.gui.VhdlSimulatorConsole;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Timer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class Frame
extends LFrame.MainWindow
implements LocaleListener {
    private static final long serialVersionUID = 1L;
    public static final String EDITOR_VIEW = "editorView";
    public static final String EXPLORER_VIEW = "explorerView";
    public static final String EDIT_LAYOUT = "layout";
    public static final String EDIT_APPEARANCE = "appearance";
    public static final String EDIT_HDL = "hdl";
    private final Timer timer = new Timer();
    private final Project project;
    private final MyProjectListener myProjectListener = new MyProjectListener();
    private final MainMenuListener menuListener;
    private final Toolbar toolbar;
    private final HorizontalSplitPane leftRegion;
    private final HorizontalSplitPane rightRegion;
    private final HorizontalSplitPane editRegion;
    private final MainRegionVerticalSplitPane mainRegion;
    private final JPanel rightPanel;
    private final JPanel mainPanelSuper;
    private final CardPanel mainPanel;
    private final JTabbedPane topTab;
    private final JTabbedPane bottomTab;
    private final Toolbox toolbox;
    private final SimulationExplorer simExplorer;
    private final AttrTable attrTable;
    private final ZoomControl zoom;
    private final LayoutToolbarModel layoutToolbarModel;
    private final Canvas layoutCanvas;
    private final VhdlSimulatorConsole vhdlSimulatorConsole;
    private final HdlContentView hdlEditor;
    private final ZoomModel layoutZoomModel;
    private final LayoutEditHandler layoutEditHandler;
    private final AttrTableSelectionModel attrTableSelectionModel;
    private AppearanceView appearance;
    private Double lastFraction = AppPreferences.WINDOW_RIGHT_SPLIT.get();
    private final RegTabContent regTabContent;

    public Frame(Project project) {
        super(project);
        this.project = project;
        this.setBackground(Color.white);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new MyWindowListener());
        project.addProjectListener(this.myProjectListener);
        project.addLibraryListener(this.myProjectListener);
        project.addCircuitListener(this.myProjectListener);
        this.layoutToolbarModel = new LayoutToolbarModel(this, project);
        this.layoutCanvas = new Canvas(project);
        CanvasPane canvasPane = new CanvasPane(this.layoutCanvas);
        this.layoutZoomModel = new BasicZoomModel(AppPreferences.LAYOUT_SHOW_GRID, AppPreferences.LAYOUT_ZOOM, this.buildZoomSteps(), canvasPane);
        this.layoutCanvas.getGridPainter().setZoomModel(this.layoutZoomModel);
        this.layoutEditHandler = new LayoutEditHandler(this);
        this.attrTableSelectionModel = new AttrTableSelectionModel(project, this);
        this.menuListener = new MainMenuListener(this, this.menubar);
        this.menuListener.setEditHandler(this.layoutEditHandler);
        this.toolbar = new Toolbar(this.layoutToolbarModel);
        this.toolbox = new Toolbox(project, this, this.menuListener);
        this.simExplorer = new SimulationExplorer(project, this.menuListener);
        this.bottomTab = new JTabbedPane();
        this.bottomTab.setFont(AppPreferences.getScaledFont(new Font("Dialog", 1, 9)));
        this.attrTable = new AttrTable(this);
        this.bottomTab.add(this.attrTable);
        this.regTabContent = new RegTabContent(this);
        this.bottomTab.add(this.regTabContent);
        this.zoom = new ZoomControl(this.layoutZoomModel, this.layoutCanvas);
        this.mainPanelSuper = new JPanel(new BorderLayout());
        canvasPane.setZoomModel(this.layoutZoomModel);
        this.mainPanel = new CardPanel();
        this.mainPanel.addView(EDIT_LAYOUT, canvasPane);
        this.mainPanel.setView(EDIT_LAYOUT);
        this.mainPanelSuper.add((java.awt.Component)this.mainPanel, "Center");
        JPanel explPanel = new JPanel(new BorderLayout());
        explPanel.add((java.awt.Component)this.toolbox, "Center");
        JPanel simPanel = new JPanel(new BorderLayout());
        simPanel.add((java.awt.Component)this.simExplorer, "Center");
        this.topTab = new JTabbedPane();
        this.topTab.setFont(new Font("Dialog", 1, 9));
        this.topTab.add(explPanel);
        this.topTab.add(simPanel);
        JPanel attrFooter = new JPanel(new BorderLayout());
        attrFooter.add(this.zoom);
        JPanel bottomTabAndZoom = new JPanel(new BorderLayout());
        bottomTabAndZoom.add((java.awt.Component)this.bottomTab, "Center");
        bottomTabAndZoom.add((java.awt.Component)attrFooter, "South");
        this.leftRegion = new HorizontalSplitPane(this.topTab, bottomTabAndZoom, AppPreferences.WINDOW_LEFT_SPLIT.get());
        this.hdlEditor = new HdlContentView(project);
        this.vhdlSimulatorConsole = new VhdlSimulatorConsole(project);
        this.editRegion = new HorizontalSplitPane(this.mainPanelSuper, this.hdlEditor, 1.0);
        this.rightRegion = new HorizontalSplitPane(this.editRegion, this.vhdlSimulatorConsole, 1.0);
        this.rightPanel = new JPanel(new BorderLayout());
        this.rightPanel.add((java.awt.Component)this.rightRegion, "Center");
        VhdlSimState state = new VhdlSimState(project);
        state.stateChanged();
        project.getVhdlSimulator().addVhdlSimStateListener(state);
        this.mainRegion = new MainRegionVerticalSplitPane(this.leftRegion, this.rightPanel);
        this.getContentPane().add((java.awt.Component)this.mainRegion, "Center");
        this.localeChanged();
        this.setSize(AppPreferences.WINDOW_WIDTH.get(), AppPreferences.WINDOW_HEIGHT.get());
        Point prefPoint = Frame.getInitialLocation();
        if (prefPoint != null) {
            this.setLocation(prefPoint);
        }
        this.setExtendedState(AppPreferences.WINDOW_STATE.get());
        this.menuListener.register(this.mainPanel);
        KeyboardToolSelection.register(this.toolbar);
        project.setFrame(this);
        if (project.getTool() == null) {
            project.setTool(project.getOptions().getToolbarData().getFirstTool());
        }
        this.mainPanel.addChangeListener(this.myProjectListener);
        AppPreferences.TOOLBAR_PLACEMENT.addPropertyChangeListener(this.myProjectListener);
        this.placeToolbar();
        LocaleManager.addLocaleListener(this);
        this.toolbox.updateStructure();
    }

    public RegTabContent getRegTabContent() {
        return this.regTabContent;
    }

    private ArrayList<Double> buildZoomSteps() {
        ZoomStepPair[] config = new ZoomStepPair[]{new ZoomStepPair(50, 5), new ZoomStepPair(200, 10), new ZoomStepPair(1000, 20)};
        ArrayList<Double> steps = new ArrayList<Double>();
        double zoom = 0.0;
        for (ZoomStepPair pair : config) {
            while (zoom < (double)pair.maxZoom()) {
                steps.add(zoom += (double)pair.step());
            }
        }
        return steps;
    }

    private static Point getInitialLocation() {
        String s = AppPreferences.WINDOW_LOCATION.get();
        if (s == null) {
            return null;
        }
        int comma = s.indexOf(44);
        if (comma < 0) {
            return null;
        }
        try {
            int x = Integer.parseInt(s.substring(0, comma));
            int y = Integer.parseInt(s.substring(comma + 1));
            while (Frame.isProjectFrameAt(x, y)) {
                x += 20;
                y += 20;
            }
            Rectangle desired = new Rectangle(x, y, 50, 50);
            int gcBestSize = 0;
            Point gcBestPoint = null;
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            for (GraphicsDevice gd : ge.getScreenDevices()) {
                for (GraphicsConfiguration gc : gd.getConfigurations()) {
                    Rectangle gcBounds = gc.getBounds();
                    if (!gcBounds.intersects(desired)) continue;
                    Rectangle inter = gcBounds.intersection(desired);
                    int size = inter.width * inter.height;
                    if (size <= gcBestSize) continue;
                    gcBestSize = size;
                    int x2 = Math.max(gcBounds.x, Math.min(inter.x, inter.x + inter.width - 50));
                    int y2 = Math.max(gcBounds.y, Math.min(inter.y, inter.y + inter.height - 50));
                    gcBestPoint = new Point(x2, y2);
                }
            }
            if (gcBestPoint != null && Frame.isProjectFrameAt(gcBestPoint.x, gcBestPoint.y)) {
                gcBestPoint = null;
            }
            return gcBestPoint;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static boolean isProjectFrameAt(int x, int y) {
        for (Project current : Projects.getOpenProjects()) {
            Frame frame = current.getFrame();
            if (frame == null) continue;
            Point loc = frame.getLocationOnScreen();
            int d = Math.abs(loc.x - x) + Math.abs(loc.y - y);
            if (d > 3) continue;
            return true;
        }
        return false;
    }

    public void resetLayout() {
        this.mainRegion.setFraction(0.25);
        this.mainRegion.setOrientation(Direction.EAST);
        this.leftRegion.setFraction(0.5);
        this.rightRegion.setFraction(1.0);
    }

    public Toolbar getToolbar() {
        return this.toolbar;
    }

    private void buildTitleString() {
        Circuit circuit = this.project.getCurrentCircuit();
        String name = this.project.getLogisimFile().getName();
        StringBuilder title = new StringBuilder();
        title.append(this.project.isFileDirty() ? "\ud83d\udcbe " : "").append(circuit != null ? Strings.S.get("titleCircFileKnown", circuit.getName(), name) : Strings.S.get("titleFileKnown", name)).append(" \u00b7 ").append("Logisim-evolution v4.0.0");
        if (this.project.isFileDirty()) {
            title.append(String.format(" [%s]", Strings.S.get("titleUnsavedProjectState").toUpperCase()));
        }
        if (!BuildInfo.version.isStable()) {
            title.append(String.format(" (ID:%s, BUILT:%s)", "main/00b4b30e", "2025-09-07T08:43:55+0200"));
        }
        this.setTitle(title.toString().trim());
        this.myProjectListener.enableSave();
    }

    public boolean confirmClose() {
        return this.confirmClose(Strings.S.get("confirmCloseTitle"));
    }

    public boolean confirmClose(String title) {
        if (!this.project.isFileDirty()) {
            return true;
        }
        String message = Strings.S.get("confirmDiscardMessage", this.project.getLogisimFile().getName());
        this.toFront();
        Object[] options = new String[]{Strings.S.get("saveOption"), Strings.S.get("discardOption"), Strings.S.get("cancelOption")};
        int result = OptionPane.showOptionDialog(this, message, title, 0, 3, null, options, options[0]);
        boolean ret = false;
        if (result == 0) {
            ret = ProjectActions.doSave(this.project);
            this.project.getLogisimFile().stopAutosaveThread(false);
        } else if (result == 1) {
            this.dispose();
            ret = true;
            this.project.getLogisimFile().stopAutosaveThread(true);
        }
        return ret;
    }

    public Canvas getCanvas() {
        return this.layoutCanvas;
    }

    public String getEditorView() {
        return this.getHdlEditorView() != null ? EDIT_HDL : this.mainPanel.getView();
    }

    public void setEditorView(String view) {
        String curView = this.mainPanel.getView();
        if (this.hdlEditor.getHdlModel() == null && curView.equals(view)) {
            return;
        }
        this.editRegion.setFraction(1.0);
        this.hdlEditor.setHdlModel(null);
        if (view.equals(EDIT_APPEARANCE)) {
            AppearanceView app = this.appearance;
            if (app == null) {
                app = new AppearanceView();
                app.setCircuit(this.project, this.project.getCircuitState());
                this.mainPanel.addView(EDIT_APPEARANCE, app.getCanvasPane());
                this.appearance = app;
            }
            this.toolbar.setToolbarModel(app.getToolbarModel());
            app.getAttrTableDrawManager(this.attrTable).attributesSelected();
            this.zoom.setZoomModel(app.getZoomModel());
            this.zoom.setAutoZoomButtonEnabled(false);
            this.menuListener.setEditHandler(app.getEditHandler());
            this.mainPanel.setView(view);
            app.getCanvas().requestFocus();
        } else {
            this.toolbar.setToolbarModel(this.layoutToolbarModel);
            this.zoom.setZoomModel(this.layoutZoomModel);
            this.zoom.setAutoZoomButtonEnabled(true);
            this.menuListener.setEditHandler(this.layoutEditHandler);
            this.viewAttributes(this.project.getTool(), true);
            this.mainPanel.setView(view);
            this.layoutCanvas.requestFocus();
        }
    }

    public ZoomControl getZoomControl() {
        return this.zoom;
    }

    public VhdlSimulatorConsole getVhdlSimulatorConsole() {
        return this.vhdlSimulatorConsole;
    }

    public ZoomModel getZoomModel() {
        return this.layoutZoomModel;
    }

    @Override
    public void localeChanged() {
        this.buildTitleString();
        this.topTab.setTitleAt(0, Strings.S.get("designTab"));
        this.topTab.setTitleAt(1, Strings.S.get("simulateTab"));
        this.bottomTab.setTitleAt(0, Strings.S.get("propertiesTab"));
        this.bottomTab.setTitleAt(1, Strings.S.get("stateTab"));
    }

    private void placeToolbar() {
        String loc = AppPreferences.TOOLBAR_PLACEMENT.get();
        this.rightPanel.remove(this.toolbar);
        if (!"hidden".equals(loc)) {
            String value = "North";
            for (Direction dir : Direction.cardinals) {
                if (!dir.toString().equals(loc)) continue;
                value = dir == Direction.EAST ? "East" : (dir == Direction.SOUTH ? "South" : (dir == Direction.WEST ? "West" : "North"));
            }
            this.rightPanel.add((java.awt.Component)this.toolbar, value);
            boolean vertical = "West".equals(value) || "East".equals(value);
            this.toolbar.setOrientation(vertical ? Toolbar.VERTICAL : Toolbar.HORIZONTAL);
        }
        this.getContentPane().validate();
    }

    public void savePreferences() {
        Point loc;
        AppPreferences.TICK_FREQUENCY.set(this.project.getSimulator().getTickFrequency());
        AppPreferences.LAYOUT_SHOW_GRID.setBoolean(this.layoutZoomModel.getShowGrid());
        AppPreferences.LAYOUT_ZOOM.set(this.layoutZoomModel.getZoomFactor());
        if (this.appearance != null) {
            ZoomModel appearanceZoom = this.appearance.getZoomModel();
            AppPreferences.APPEARANCE_SHOW_GRID.setBoolean(appearanceZoom.getShowGrid());
            AppPreferences.APPEARANCE_ZOOM.set(appearanceZoom.getZoomFactor());
        }
        int state = this.getExtendedState() & 0xFFFFFFFE;
        AppPreferences.WINDOW_STATE.set(state);
        Dimension dim = this.getSize();
        AppPreferences.WINDOW_WIDTH.set(dim.width);
        AppPreferences.WINDOW_HEIGHT.set(dim.height);
        try {
            loc = this.getLocationOnScreen();
        }
        catch (IllegalComponentStateException e) {
            loc = Projects.getLocation(this);
        }
        if (loc != null) {
            AppPreferences.WINDOW_LOCATION.set(loc.x + "," + loc.y);
        }
        if (this.leftRegion.getFraction() > 0.0) {
            AppPreferences.WINDOW_LEFT_SPLIT.set(this.leftRegion.getFraction());
        }
        if (this.rightRegion.getFraction() < 1.0) {
            AppPreferences.WINDOW_RIGHT_SPLIT.set(this.rightRegion.getFraction());
        }
        if (this.mainRegion.getFraction() > 0.0) {
            AppPreferences.WINDOW_MAIN_SPLIT.set(this.mainRegion.getFraction());
        }
        AppPreferences.DIALOG_DIRECTORY.set(JFileChoosers.getCurrentDirectory());
    }

    void setAttrTableModel(AttrTableModel value) {
        AttributeSetTableModel model;
        this.attrTable.setAttrTableModel(value);
        if (value instanceof AttrTableToolModel) {
            model = (AttrTableToolModel)value;
            Tool tool = ((AttrTableToolModel)model).getTool();
            this.toolbox.setHaloedTool(tool);
            this.layoutToolbarModel.setHaloedTool(tool);
        } else {
            this.toolbox.setHaloedTool(null);
            this.layoutToolbarModel.setHaloedTool(null);
        }
        if (value instanceof AttrTableComponentModel) {
            model = (AttrTableComponentModel)value;
            Circuit circ = ((AttrTableComponentModel)model).getCircuit();
            Component comp = ((AttrTableComponentModel)model).getComponent();
            this.layoutCanvas.setHaloedComponent(circ, comp);
        } else {
            this.layoutCanvas.setHaloedComponent(null, null);
        }
    }

    public void setVhdlSimulatorConsoleStatusVisible() {
        this.rightRegion.setFraction(this.lastFraction);
    }

    public void setVhdlSimulatorConsoleStatusInvisible() {
        this.lastFraction = this.rightRegion.getFraction();
        this.rightRegion.setFraction(1.0);
    }

    public HdlModel getHdlEditorView() {
        return this.hdlEditor.getHdlModel();
    }

    private void setHdlEditorView(HdlModel hdl) {
        this.hdlEditor.setHdlModel(hdl);
        this.zoom.setZoomModel(null);
        this.editRegion.setFraction(0.0);
        this.toolbar.setToolbarModel(this.hdlEditor.getToolbarModel());
    }

    void viewAttributes(Tool newTool) {
        this.viewAttributes(null, newTool, false);
    }

    private void viewAttributes(Tool newTool, boolean force) {
        this.viewAttributes(null, newTool, force);
    }

    private void viewAttributes(Tool oldTool, Tool newTool, boolean force) {
        AttributeSet newAttrs;
        if (newTool == null) {
            newAttrs = null;
            if (!force) {
                return;
            }
        } else {
            newAttrs = newTool.getAttributeSet(this.layoutCanvas);
        }
        if (newAttrs == null) {
            AttrTableToolModel model;
            boolean same;
            AttrTableModel oldModel = this.attrTable.getAttrTableModel();
            boolean bl = same = oldModel instanceof AttrTableToolModel && (model = (AttrTableToolModel)oldModel).getTool() == oldTool;
            if (!(force || same || oldModel instanceof AttrTableCircuitModel)) {
                return;
            }
        }
        if (newAttrs == null) {
            Circuit circ = this.project.getCurrentCircuit();
            if (circ != null) {
                this.setAttrTableModel(new AttrTableCircuitModel(this.project, circ));
            } else if (force) {
                this.setAttrTableModel(null);
            }
        } else if (newAttrs instanceof SelectionAttributes) {
            this.setAttrTableModel(this.attrTableSelectionModel);
        } else {
            this.setAttrTableModel(new AttrTableToolModel(this.project, newTool));
        }
    }

    public void viewComponentAttributes(Circuit circ, Component comp) {
        if (comp == null) {
            this.setAttrTableModel(null);
        } else {
            this.setAttrTableModel(new AttrTableComponentModel(this.project, circ, comp));
        }
    }

    class MyProjectListener
    implements ProjectListener,
    LibraryListener,
    CircuitListener,
    PropertyChangeListener,
    ChangeListener {
        MyProjectListener() {
        }

        public void attributeListChanged(AttributeEvent e) {
        }

        @Override
        public void circuitChanged(CircuitEvent event) {
            if (event.getAction() == 0) {
                Frame.this.buildTitleString();
            }
        }

        private void enableSave() {
            boolean ok = Frame.this.getProject().isFileDirty();
            Frame.this.getRootPane().putClientProperty("windowModified", ok);
        }

        @Override
        public void libraryChanged(LibraryEvent e) {
            if (e.getAction() == 6) {
                Frame.this.buildTitleString();
            } else if (e.getAction() == 7) {
                Frame.this.buildTitleString();
                this.enableSave();
            }
        }

        @Override
        public void projectChanged(ProjectEvent event) {
            int action = event.getAction();
            if (action == 0) {
                Frame.this.buildTitleString();
                Frame.this.project.setTool(Frame.this.project.getOptions().getToolbarData().getFirstTool());
                Frame.this.placeToolbar();
            } else if (action == 4) {
                CircuitState state;
                Object object = event.getData();
                if (object instanceof CircuitState && (state = (CircuitState)object).getParentState() != null) {
                    Frame.this.topTab.setSelectedIndex(1);
                }
            } else if (action == 1) {
                if (event.getData() instanceof Circuit) {
                    Frame.this.setEditorView(Frame.EDIT_LAYOUT);
                    if (Frame.this.appearance != null) {
                        Frame.this.appearance.setCircuit(Frame.this.project, Frame.this.project.getCircuitState());
                    }
                } else {
                    Object object = event.getData();
                    if (object instanceof HdlModel) {
                        HdlModel model = (HdlModel)object;
                        Frame.this.setHdlEditorView(model);
                    }
                }
                Frame.this.viewAttributes(Frame.this.project.getTool());
                Frame.this.buildTitleString();
            } else if (action == 2) {
                if (Frame.this.attrTable == null) {
                    return;
                }
                Tool oldTool = (Tool)event.getOldData();
                Tool newTool = (Tool)event.getData();
                if (!Frame.this.getEditorView().equals(Frame.EDIT_APPEARANCE)) {
                    Frame.this.viewAttributes(oldTool, newTool, false);
                }
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (AppPreferences.TOOLBAR_PLACEMENT.isSource(event)) {
                Frame.this.placeToolbar();
            }
        }

        @Override
        public void stateChanged(ChangeEvent event) {
            Object source = event.getSource();
            if (source == Frame.this.mainPanel) {
                Frame.this.firePropertyChange(Frame.EDITOR_VIEW, "???", Frame.this.getEditorView());
            }
        }
    }

    class MyWindowListener
    extends WindowAdapter {
        MyWindowListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (Frame.this.confirmClose(Strings.S.get("confirmCloseTitle"))) {
                Frame.this.layoutCanvas.closeCanvas();
                Frame.this.timer.cancel();
                Frame.this.dispose();
            }
        }

        @Override
        public void windowOpened(WindowEvent e) {
            Frame.this.layoutCanvas.computeSize(true);
        }
    }

    private static class MainRegionVerticalSplitPane
    extends VerticalSplitPane
    implements PropertyChangeListener {
        private final JComponent componentTree;
        private final JComponent mainCanvas;
        private Direction orientation;
        private double realFraction;

        public MainRegionVerticalSplitPane(JComponent componentTree, JComponent mainCanvas) {
            this(componentTree, mainCanvas, AppPreferences.WINDOW_MAIN_SPLIT.get(), Direction.parse(AppPreferences.CANVAS_PLACEMENT.get()));
        }

        public MainRegionVerticalSplitPane(JComponent componentTree, JComponent mainCanvas, double fraction, Direction orientation) {
            this.componentTree = componentTree;
            this.mainCanvas = mainCanvas;
            this.orientation = orientation;
            this.realFraction = fraction;
            if (orientation == Direction.EAST) {
                this.init(componentTree, mainCanvas, fraction);
            } else {
                this.init(mainCanvas, componentTree, fraction);
            }
            AppPreferences.CANVAS_PLACEMENT.addPropertyChangeListener(this);
        }

        public void setOrientation(Direction newOrientation) {
            if (newOrientation != this.orientation) {
                this.orientation = newOrientation;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (AppPreferences.CANVAS_PLACEMENT.isSource(event)) {
                this.swapComponents();
            }
        }

        @Override
        public double getFraction() {
            return this.realFraction;
        }

        @Override
        public void setFraction(double value) {
            this.realFraction = value;
            super.setFraction(this.orientation == Direction.EAST ? value : 1.0 - value);
        }

        protected void swapComponents() {
            Direction tmpOrient = Direction.parse(AppPreferences.CANVAS_PLACEMENT.get());
            if (this.orientation != tmpOrient) {
                this.orientation = tmpOrient;
                boolean isSwapped = this.orientation == Direction.WEST;
                this.compLeft = isSwapped ? this.mainCanvas : this.componentTree;
                this.compRight = isSwapped ? this.componentTree : this.mainCanvas;
                this.setFraction(this.realFraction);
                if (super.getFraction() == this.realFraction) {
                    this.revalidate();
                }
            }
        }
    }

    private record ZoomStepPair(int maxZoom, int step) {
    }
}

