/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.soc.util;

import com.cburch.logisim.circuit.CircuitState;
import com.cburch.logisim.gui.generic.OptionPane;
import com.cburch.logisim.gui.icons.ErrorIcon;
import com.cburch.logisim.soc.Strings;
import com.cburch.logisim.soc.data.SocProcessorInterface;
import com.cburch.logisim.soc.file.ElfSectionHeader;
import com.cburch.logisim.soc.util.AssemblerInfo;
import com.cburch.logisim.soc.util.AssemblerInterface;
import com.cburch.logisim.soc.util.AssemblerMacro;
import com.cburch.logisim.soc.util.AssemblerToken;
import com.cburch.logisim.util.LocaleListener;
import com.cburch.logisim.util.LocaleManager;
import com.cburch.logisim.util.StringGetter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.swing.text.BadLocationException;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.parser.AbstractParser;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParseResult;
import org.fife.ui.rsyntaxtextarea.parser.DefaultParserNotice;
import org.fife.ui.rsyntaxtextarea.parser.ParseResult;
import org.fife.ui.rtextarea.GutterIconInfo;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class Assembler
extends AbstractParser
implements LocaleListener {
    private final AssemblerInterface assembler;
    private final HashMap<GutterIconInfo, StringGetter> errorMarkers;
    private final RTextScrollPane pane;
    private AssemblerInfo assemblerInfo;
    private long entryPoint;

    public Assembler(AssemblerInterface assembler, RTextScrollPane pane) {
        this.assembler = assembler;
        this.errorMarkers = new HashMap();
        this.pane = pane;
        LocaleManager.addLocaleListener(this);
        this.reset();
    }

    public void reset() {
        this.errorMarkers.clear();
        this.pane.getGutter().removeAllTrackingIcons();
        this.entryPoint = -1L;
    }

    public List<Integer> getErrorPositions() {
        ArrayList<Integer> positions = new ArrayList<Integer>();
        for (GutterIconInfo info : this.errorMarkers.keySet()) {
            int pos = info.getMarkedOffset();
            if (positions.isEmpty()) {
                positions.add(pos);
                continue;
            }
            boolean found = false;
            for (int i = 0; i < positions.size() && !found; ++i) {
                if (pos >= positions.get(i)) continue;
                found = true;
                positions.add(i, pos);
            }
            if (found) continue;
            positions.add(pos);
        }
        return positions;
    }

    public boolean assemble() {
        this.reset();
        LinkedList<AssemblerToken> assemblerTokens = new LinkedList<AssemblerToken>();
        this.assemblerInfo = new AssemblerInfo(this.assembler);
        RTextArea text = this.pane.getTextArea();
        for (int i = 0; i < text.getLineCount(); ++i) {
            assemblerTokens.addAll(this.checkAndBuildTokens(i));
        }
        HashMap<String, Long> labels = new HashMap<String, Long>();
        HashMap<String, AssemblerToken> labelToken = new HashMap<String, AssemblerToken>();
        for (AssemblerToken asm : assemblerTokens) {
            if (asm.getType() != 1) continue;
            if (labels.containsKey(asm.getValue())) {
                this.addError(asm.getoffset(), Strings.S.getter("AssemblerDuplicatedLabelNotSupported"), this.errorMarkers.keySet());
                this.addError(((AssemblerToken)labelToken.get(asm.getValue())).getoffset(), Strings.S.getter("AssemblerDuplicatedLabelNotSupported"), this.errorMarkers.keySet());
                continue;
            }
            labels.put(asm.getValue(), -1L);
            labelToken.put(asm.getValue(), asm);
        }
        labelToken.clear();
        for (AssemblerToken asm : assemblerTokens) {
            if (asm.getType() != 8 || !labels.containsKey(asm.getValue())) continue;
            asm.setType(16);
        }
        ArrayList<Object> toBeRemoved = new ArrayList<Object>();
        for (int i = 0; i < assemblerTokens.size(); ++i) {
            AssemblerToken asm = (AssemblerToken)assemblerTokens.get(i);
            if (AssemblerToken.MATH_OPERATORS.contains(asm.getType())) {
                int beforeValue;
                if (i + 1 >= assemblerTokens.size()) {
                    this.addError(asm.getoffset(), Strings.S.getter("AssemblerReguiresNumberAfterMath"), this.errorMarkers.keySet());
                    continue;
                }
                AssemblerToken before = i == 0 ? null : assemblerTokens.get(i - 1);
                AssemblerToken after = assemblerTokens.get(i + 1);
                if (before == null || !before.isNumber() && before.getType() != 22) {
                    before = null;
                }
                if (!after.isNumber() && after.getType() != 22) {
                    this.addError(asm.getoffset(), Strings.S.getter("AssemblerReguiresNumberAfterMath"), this.errorMarkers.keySet());
                    continue;
                }
                int n = beforeValue = before == null ? 0 : before.getNumberValue();
                if (after.getType() == 22 || before != null && before.getType() == 22) {
                    ++i;
                    continue;
                }
                switch (asm.getType()) {
                    case 15: {
                        after.setValue(beforeValue + after.getNumberValue());
                        if (before != null) {
                            toBeRemoved.add(before);
                        }
                        toBeRemoved.add(asm);
                        ++i;
                        break;
                    }
                    case 20: {
                        after.setValue(beforeValue << after.getNumberValue());
                        if (before != null) {
                            toBeRemoved.add(before);
                        }
                        toBeRemoved.add(asm);
                        ++i;
                        break;
                    }
                    case 21: {
                        after.setValue(beforeValue >> after.getNumberValue());
                        if (before != null) {
                            toBeRemoved.add(before);
                        }
                        toBeRemoved.add(asm);
                        ++i;
                        break;
                    }
                    case 14: {
                        after.setValue(beforeValue - after.getNumberValue());
                        if (before != null) {
                            toBeRemoved.add(before);
                        }
                        toBeRemoved.add(asm);
                        ++i;
                        break;
                    }
                    case 17: {
                        after.setValue(beforeValue * after.getNumberValue());
                        if (before != null) {
                            toBeRemoved.add(before);
                        }
                        toBeRemoved.add(asm);
                        ++i;
                        break;
                    }
                    case 18: {
                        if (after.getNumberValue() == 0) {
                            this.addError(after.getoffset(), Strings.S.getter("AssemblerDivZero"), this.errorMarkers.keySet());
                            ++i;
                            break;
                        }
                        after.setValue(beforeValue / after.getNumberValue());
                        if (before != null) {
                            toBeRemoved.add(before);
                        }
                        toBeRemoved.add(asm);
                        ++i;
                        break;
                    }
                    case 19: {
                        if (after.getNumberValue() == 0) {
                            this.addError(after.getoffset(), Strings.S.getter("AssemblerDivZero"), this.errorMarkers.keySet());
                            ++i;
                            break;
                        }
                        after.setValue(beforeValue % after.getNumberValue());
                        if (before != null) {
                            toBeRemoved.add(before);
                        }
                        toBeRemoved.add(asm);
                        ++i;
                    }
                }
                continue;
            }
            if (asm.getType() == 9 && i + 1 < assemblerTokens.size()) {
                AssemblerToken next;
                do {
                    if ((next = assemblerTokens.get(i + 1)).getType() != 9) continue;
                    ++i;
                    toBeRemoved.add(next);
                    asm.setValue(asm.getValue().concat(next.getValue()));
                } while (next.getType() == 9 && i + 1 < assemblerTokens.size());
                continue;
            }
            if (asm.getType() != 11 || i + 2 >= assemblerTokens.size()) continue;
            AssemblerToken second = assemblerTokens.get(i + 1);
            AssemblerToken third = assemblerTokens.get(i + 2);
            if (second.getType() != 5 || third.getType() != 12) continue;
            second.setType(4);
            toBeRemoved.add(asm);
            toBeRemoved.add(third);
            i += 2;
        }
        assemblerTokens.removeAll(toBeRemoved);
        for (AssemblerToken error : this.assemblerInfo.getErrors().keySet()) {
            this.addError(error.getoffset(), this.assemblerInfo.getErrors().get(error), this.errorMarkers.keySet());
        }
        this.assembler.performUpSpecificOperationsOnTokens(assemblerTokens);
        toBeRemoved.clear();
        boolean errors = false;
        Iterator iter = assemblerTokens.iterator();
        HashMap<String, AssemblerMacro> macros = new HashMap<String, AssemblerMacro>();
        while (iter.hasNext()) {
            AssemblerToken asm = (AssemblerToken)iter.next();
            if (asm.getType() != 3 || !asm.getValue().equals(".macro")) continue;
            toBeRemoved.add(asm);
            if (!iter.hasNext()) {
                this.addError(asm.getoffset(), Strings.S.getter("AssemblerExpectedMacroName"), this.errorMarkers.keySet());
                break;
            }
            AssemblerToken name = (AssemblerToken)iter.next();
            toBeRemoved.add(name);
            if (name.getType() != 8) {
                this.addError(asm.getoffset(), Strings.S.getter("AssemblerExpectedMacroName"), this.errorMarkers.keySet());
                break;
            }
            if (!iter.hasNext()) {
                this.addError(asm.getoffset(), Strings.S.getter("AssemblerExpectedMacroNrOfParameters"), this.errorMarkers.keySet());
                break;
            }
            AssemblerToken nrParameters = (AssemblerToken)iter.next();
            toBeRemoved.add(nrParameters);
            if (!nrParameters.isNumber()) {
                this.addError(asm.getoffset(), Strings.S.getter("AssemblerExpectedMacroNrOfParameters"), this.errorMarkers.keySet());
                break;
            }
            AssemblerMacro macro = new AssemblerMacro(name.getValue(), nrParameters.getNumberValue());
            boolean endOfMacro = false;
            while (!endOfMacro && iter.hasNext()) {
                AssemblerToken macroAsm = (AssemblerToken)iter.next();
                if (macroAsm.getType() == 3) {
                    if (macroAsm.getValue().equals(".endm")) {
                        endOfMacro = true;
                    } else {
                        this.addError(macroAsm.getoffset(), Strings.S.getter("AssemblerCannotUseInsideMacro"), this.errorMarkers.keySet());
                        errors = true;
                    }
                } else {
                    macro.addToken(macroAsm);
                    if (macroAsm.getType() == 1) {
                        labels.remove(macroAsm.getValue());
                        macro.addLabel(macroAsm.getValue());
                    }
                }
                toBeRemoved.add(macroAsm);
            }
            if (!endOfMacro) {
                this.addError(asm.getoffset(), Strings.S.getter("AssemblerEndOfMacroNotFound"), this.errorMarkers.keySet());
                errors = true;
                continue;
            }
            HashMap<AssemblerToken, StringGetter> markers = new HashMap<AssemblerToken, StringGetter>();
            if (macro.checkParameters(markers)) {
                macros.put(macro.getName(), macro);
                continue;
            }
            for (AssemblerToken marker : markers.keySet()) {
                this.addError(marker.getoffset(), markers.get(marker), this.errorMarkers.keySet());
            }
            errors = true;
        }
        if (errors) {
            return this.errorMarkers.isEmpty();
        }
        assemblerTokens.removeAll(toBeRemoved);
        for (AssemblerToken asm : assemblerTokens) {
            if (asm.getType() != 8 || !macros.containsKey(asm.getValue())) continue;
            asm.setType(23);
        }
        HashMap<AssemblerToken, StringGetter> markers = new HashMap<AssemblerToken, StringGetter>();
        for (String name : macros.keySet()) {
            ((AssemblerMacro)macros.get(name)).checkForMacros(markers, macros.keySet());
        }
        for (String name : macros.keySet()) {
            ((AssemblerMacro)macros.get(name)).replaceLabels(labels, markers, this.assembler, macros);
        }
        if (!markers.isEmpty()) {
            for (AssemblerToken marker : markers.keySet()) {
                this.addError(marker.getoffset(), markers.get(marker), this.errorMarkers.keySet());
            }
            return this.errorMarkers.isEmpty();
        }
        this.assemblerInfo.assemble(assemblerTokens, labels, macros);
        for (AssemblerToken error : this.assemblerInfo.getErrors().keySet()) {
            this.addError(error.getoffset(), this.assemblerInfo.getErrors().get(error), this.errorMarkers.keySet());
        }
        if (labels.containsKey("_start")) {
            this.entryPoint = labels.get("_start");
        }
        return this.errorMarkers.isEmpty();
    }

    public void addError(int location, StringGetter sg, Set<GutterIconInfo> known) {
        GutterIconInfo newError;
        for (GutterIconInfo knownError : known) {
            if (knownError.getMarkedOffset() != location) continue;
            return;
        }
        try {
            newError = this.pane.getGutter().addOffsetTrackingIcon(location, new ErrorIcon(12), sg.toString());
        }
        catch (BadLocationException e) {
            newError = null;
        }
        if (newError != null) {
            this.errorMarkers.put(newError, sg);
        }
        ((RSyntaxTextArea)this.pane.getTextArea()).forceReparsing(this);
    }

    public LinkedList<AssemblerToken> checkAndBuildTokens(int lineNumber) {
        int endOffset;
        int startOffset;
        LinkedList<AssemblerToken> lineTokens = new LinkedList<AssemblerToken>();
        RSyntaxTextArea text = (RSyntaxTextArea)this.pane.getTextArea();
        try {
            startOffset = text.getLineStartOffset(lineNumber);
        }
        catch (BadLocationException e1) {
            return null;
        }
        try {
            endOffset = text.getLineEndOffset(lineNumber);
        }
        catch (BadLocationException e1) {
            return null;
        }
        Token first = text.getTokenListForLine(lineNumber);
        HashSet<GutterIconInfo> lineErrorMarkers = new HashSet<GutterIconInfo>();
        for (GutterIconInfo error : this.errorMarkers.keySet()) {
            if (error.getMarkedOffset() < startOffset || error.getMarkedOffset() > endOffset) continue;
            lineErrorMarkers.add(error);
        }
        while (first != null) {
            if (first.getType() != 0 && first.getType() != 1 && first.getType() != 21) {
                String name = first.getLexeme();
                int type = first.getType();
                int offset = first.getOffset();
                if (type == 14) {
                    switch (name) {
                        case ",": {
                            lineTokens.add(new AssemblerToken(10, null, offset));
                            break;
                        }
                        case "(": {
                            if (!this.assembler.usesRoundedBrackets()) {
                                this.addError(offset, Strings.S.getter("AssemblerWrongOpeningBracket"), lineErrorMarkers);
                                break;
                            }
                            lineTokens.add(new AssemblerToken(11, null, offset));
                            break;
                        }
                        case ")": {
                            if (!this.assembler.usesRoundedBrackets()) {
                                this.addError(offset, Strings.S.getter("AssemblerWrongClosingBracket"), lineErrorMarkers);
                                break;
                            }
                            lineTokens.add(new AssemblerToken(12, null, offset));
                            break;
                        }
                        case "[": {
                            if (this.assembler.usesRoundedBrackets()) {
                                this.addError(offset, Strings.S.getter("AssemblerWrongOpeningBracket"), lineErrorMarkers);
                                break;
                            }
                            lineTokens.add(new AssemblerToken(11, null, offset));
                            break;
                        }
                        case "]": {
                            if (this.assembler.usesRoundedBrackets()) {
                                this.addError(offset, Strings.S.getter("AssemblerWrongClosingBracket"), lineErrorMarkers);
                                break;
                            }
                            lineTokens.add(new AssemblerToken(12, null, offset));
                            break;
                        }
                        case "{": {
                            this.addError(offset, Strings.S.getter("AssemblerWrongOpeningBracket"), lineErrorMarkers);
                            break;
                        }
                        case "}": {
                            this.addError(offset, Strings.S.getter("AssemblerWrongClosingBracket"), lineErrorMarkers);
                            break;
                        }
                        case ":": {
                            lineTokens.add(new AssemblerToken(13, null, offset));
                            break;
                        }
                        case "-": {
                            lineTokens.add(new AssemblerToken(14, null, offset));
                            break;
                        }
                        case "+": {
                            lineTokens.add(new AssemblerToken(15, null, offset));
                            break;
                        }
                        case "*": {
                            lineTokens.add(new AssemblerToken(17, null, offset));
                            break;
                        }
                        case "%": {
                            lineTokens.add(new AssemblerToken(19, null, offset));
                            break;
                        }
                        case "/": {
                            lineTokens.add(new AssemblerToken(18, null, offset));
                            break;
                        }
                        case "<<": {
                            lineTokens.add(new AssemblerToken(20, null, offset));
                            break;
                        }
                        case ">>": {
                            lineTokens.add(new AssemblerToken(21, null, offset));
                            break;
                        }
                        default: {
                            this.addError(offset, Strings.S.getter("AssemblerUnknowCharacter"), lineErrorMarkers);
                            break;
                        }
                    }
                } else {
                    switch (type) {
                        case 10: {
                            lineTokens.add(new AssemblerToken(6, name, offset));
                            break;
                        }
                        case 12: {
                            lineTokens.add(new AssemblerToken(7, name, offset));
                            break;
                        }
                        case 8: {
                            lineTokens.add(new AssemblerToken(3, name, offset));
                            break;
                        }
                        case 23: {
                            lineTokens.add(new AssemblerToken(name.equals("pc") ? 22 : 5, name, offset));
                            break;
                        }
                        case 6: {
                            lineTokens.add(new AssemblerToken(2, name, offset));
                            break;
                        }
                        case 13: {
                            lineTokens.add(new AssemblerToken(9, name, offset));
                            break;
                        }
                        case 20: {
                            lineTokens.add(new AssemblerToken(8, name, offset));
                            break;
                        }
                        case 24: {
                            lineTokens.add(new AssemblerToken(24, name, offset));
                        }
                    }
                }
            }
            first = first.getNextToken();
        }
        ArrayList<AssemblerToken> toBeRemoved = new ArrayList<AssemblerToken>();
        for (int i = 0; i < lineTokens.size(); ++i) {
            AssemblerToken asm = (AssemblerToken)lineTokens.get(i);
            if (asm.getType() != 13) continue;
            if (i == 0) {
                this.addError(asm.getoffset(), Strings.S.getter("AssemblerMissingLabelBefore"), lineErrorMarkers);
            } else {
                AssemblerToken before = lineTokens.get(i - 1);
                if (before.getType() == 8) {
                    before.setType(1);
                } else {
                    this.addError(before.getoffset(), Strings.S.getter("AssemblerExpectingLabelIdentifier"), lineErrorMarkers);
                }
            }
            toBeRemoved.add(asm);
        }
        for (AssemblerToken del : toBeRemoved) {
            lineTokens.remove(del);
        }
        for (GutterIconInfo olderr : lineErrorMarkers) {
            this.pane.getGutter().removeTrackingIcon(olderr);
            this.errorMarkers.remove(olderr);
        }
        return lineTokens;
    }

    public long getEntryPoint() {
        long result = -1L;
        if (this.entryPoint >= 0L) {
            return this.entryPoint;
        }
        result = this.assemblerInfo.getEntryPoint();
        if (result < 0L) {
            OptionPane.showMessageDialog(this.pane, Strings.S.get("AssemblerNoExecutableSection"), Strings.S.get("AsmPanRun"), 0);
        } else {
            OptionPane.showMessageDialog(this.pane, Strings.S.get("AssemblerAssumingEntryPoint"), Strings.S.get("AsmPanRun"), 2);
        }
        return result;
    }

    public boolean download(SocProcessorInterface cpu, CircuitState state) {
        return this.assemblerInfo.download(cpu, state);
    }

    public ElfSectionHeader getSectionHeader() {
        return this.assemblerInfo.getSectionHeader();
    }

    @Override
    public void localeChanged() {
        HashMap<GutterIconInfo, StringGetter> oldSet = new HashMap<GutterIconInfo, StringGetter>(this.errorMarkers);
        this.errorMarkers.clear();
        for (GutterIconInfo error : oldSet.keySet()) {
            GutterIconInfo newError;
            this.pane.getGutter().removeTrackingIcon(error);
            try {
                newError = this.pane.getGutter().addOffsetTrackingIcon(error.getMarkedOffset(), error.getIcon(), oldSet.get(error).toString());
            }
            catch (BadLocationException e) {
                newError = null;
            }
            if (newError == null) continue;
            this.errorMarkers.put(newError, oldSet.get(error));
        }
        oldSet.clear();
        ((RSyntaxTextArea)this.pane.getTextArea()).forceReparsing(this);
    }

    @Override
    public ParseResult parse(RSyntaxDocument doc, String style) {
        DefaultParseResult result = new DefaultParseResult(this);
        HashMap<Integer, String> offsets = new HashMap<Integer, String>();
        for (GutterIconInfo gutterIconInfo : this.errorMarkers.keySet()) {
            offsets.put(gutterIconInfo.getMarkedOffset(), this.errorMarkers.get(gutterIconInfo).toString());
        }
        for (Token token : doc) {
            int offs = token.getOffset();
            if (!offsets.containsKey(offs)) continue;
            int len = token.length();
            int line = doc.getDefaultRootElement().getElementIndex(offs);
            result.addNotice(new DefaultParserNotice(this, (String)offsets.get(offs), line, offs, len));
        }
        return result;
    }
}

