/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.gates;

import com.cburch.logisim.data.Value;

class GateFunctions {
    static Value computeAnd(Value[] inputs, int numInputs) {
        Value ret = inputs[0];
        for (int i = 1; i < numInputs; ++i) {
            ret = ret.and(inputs[i]);
        }
        return ret;
    }

    static Value computeExactlyOne(Value[] inputs, int numInputs) {
        int width = inputs[0].getWidth();
        Value[] ret = new Value[width];
        for (int i = 0; i < width; ++i) {
            int count = 0;
            for (int j = 0; j < numInputs; ++j) {
                Value v = inputs[j].get(i);
                if (v == Value.TRUE) {
                    ++count;
                    continue;
                }
                if (v == Value.FALSE) continue;
                count = -1;
                break;
            }
            ret[i] = count < 0 ? Value.ERROR : (count == 1 ? Value.TRUE : Value.FALSE);
        }
        return Value.create(ret);
    }

    static Value computeOddParity(Value[] inputs, int numInputs) {
        Value ret = inputs[0];
        for (int i = 1; i < numInputs; ++i) {
            ret = ret.xor(inputs[i]);
        }
        return ret;
    }

    static Value computeOr(Value[] inputs, int numInputs) {
        Value ret = inputs[0];
        for (int i = 1; i < numInputs; ++i) {
            ret = ret.or(inputs[i]);
        }
        return ret;
    }

    private GateFunctions() {
    }
}

