/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.hdl;

import com.cburch.hdl.HdlModel;
import com.cburch.logisim.vhdl.Strings;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VhdlParser {
    private static final String ENTITY_PATTERN = "\\s*entity\\s+(\\w+)\\s+is\\s+(.*?end)\\s+(\\w+)\\s*;";
    private static final String ARCH_PATTERN = "\\s*architecture.*";
    private static final String LIBRARY_PATTERN = "\\s*library\\s+\\w+\\s*;";
    private static final String USING_PATTERN = "\\s*use\\s+\\S+\\s*;";
    private static final String PORTS_PATTERN = "\\s*port\\s*[(](.*)[)]\\s*;\\s*end";
    private static final String PORT_PATTERN = "\\s*(\\w+)\\s*";
    private static final String LINE_PATTERN = ":\\s*(\\w+)\\s+std_logic";
    private static final String VECTOR_PATTERN = ":\\s*(\\w+)\\s+std_logic_vector\\s*[(]\\s*(\\d+)\\s+downto\\s+(\\d+)\\s*[)]";
    private final List<HdlModel.PortDescription> inputs;
    private final List<HdlModel.PortDescription> outputs;
    private final String source;
    private String name;
    private String libraries;
    private String architecture;

    public VhdlParser(String source) {
        this.source = source;
        this.inputs = new ArrayList<HdlModel.PortDescription>();
        this.outputs = new ArrayList<HdlModel.PortDescription>();
    }

    public String getArchitecture() {
        return this.architecture;
    }

    private int getLineEndIndex(String input, int from) {
        int index = input.indexOf("\n", from);
        if (index != -1) {
            return index;
        }
        index = input.indexOf("\r\n", from);
        if (index != -1) {
            return index;
        }
        index = input.indexOf("\r", from);
        if (index != -1) {
            return index;
        }
        return input.length();
    }

    public List<HdlModel.PortDescription> getInputs() {
        return this.inputs;
    }

    public String getLibraries() {
        return this.libraries;
    }

    public String getName() {
        return this.name;
    }

    public List<HdlModel.PortDescription> getOutputs() {
        return this.outputs;
    }

    private String getType(String type) throws IllegalVhdlContentException {
        if (type.equals("in")) {
            return "input";
        }
        if (type.equals("out")) {
            return "output";
        }
        if (type.equals("inout")) {
            return "inout";
        }
        throw new IllegalVhdlContentException(Strings.S.get("invalidTypeException"));
    }

    public void parse() throws IllegalVhdlContentException {
        String input = this.removeComments();
        Pattern pattern = Pattern.compile(ENTITY_PATTERN, 34);
        String[] parts = pattern.split(input);
        Matcher matcher = pattern.matcher(input);
        if (parts.length > 2) {
            throw new IllegalVhdlContentException(Strings.S.get("duplicatedEntityException"));
        }
        if (!matcher.find() || matcher.groupCount() != 3 || !matcher.group(1).equals(matcher.group(3))) {
            throw new IllegalVhdlContentException(Strings.S.get("CannotFindEntityException"));
        }
        this.name = matcher.group(1);
        this.parsePorts(matcher.group(2));
        this.parseLibraries(parts[0]);
        this.parseContent(parts.length == 2 ? parts[1] : "");
    }

    private void parseContent(String input) {
        Matcher matcher = Pattern.compile(ARCH_PATTERN, 34).matcher(input);
        this.architecture = matcher.find() ? matcher.group().trim() : "";
    }

    private void parseLibraries(String input) {
        StringBuilder result = new StringBuilder();
        Matcher library = Pattern.compile(LIBRARY_PATTERN, 2).matcher(input);
        while (library.find()) {
            result.append(library.group().trim().replaceAll("\\s+", " "));
            result.append(System.getProperty("line.separator"));
        }
        Matcher using = Pattern.compile(USING_PATTERN, 2).matcher(input);
        while (using.find()) {
            result.append(using.group().trim().replaceAll("\\s+", " "));
            result.append(System.getProperty("line.separator"));
        }
        this.libraries = result.toString();
    }

    private int parseLine(Scanner scanner, StringBuilder type) throws IllegalVhdlContentException {
        if (scanner.findWithinHorizon(Pattern.compile(LINE_PATTERN, 2), 0) == null) {
            throw new IllegalVhdlContentException(Strings.S.get("lineDeclarationException"));
        }
        MatchResult result = scanner.match();
        if (result.groupCount() != 1) {
            throw new IllegalVhdlContentException(Strings.S.get("lineDeclarationException"));
        }
        type.append(this.getType(result.group(1).toLowerCase()));
        return 1;
    }

    private void parseMultiplePorts(String line) throws IllegalVhdlContentException {
        int index = line.indexOf(58);
        if (index == -1) {
            throw new IllegalVhdlContentException(Strings.S.get("multiplePortsDeclarationException"));
        }
        Scanner local = new Scanner(line.substring(0, index));
        local.useDelimiter(",");
        ArrayList<String> names = new ArrayList<String>();
        while (local.hasNext()) {
            names.add(local.next().trim());
        }
        local.close();
        local = new Scanner(line);
        StringBuilder type = new StringBuilder();
        int width = line.toLowerCase().contains("std_logic_vector") ? this.parseVector(local, type) : this.parseLine(local, type);
        for (String name : names) {
            if (type.toString().equals("input")) {
                this.inputs.add(new HdlModel.PortDescription(name, type.toString(), width));
                continue;
            }
            this.outputs.add(new HdlModel.PortDescription(name, type.toString(), width));
        }
        local.close();
    }

    private void parsePort(String line) throws IllegalVhdlContentException {
        Scanner local = new Scanner(line);
        if (local.findWithinHorizon(Pattern.compile(PORT_PATTERN, 2), 0) == null) {
            local.close();
            throw new IllegalVhdlContentException(Strings.S.get("portDeclarationException"));
        }
        String name = local.match().group().trim();
        StringBuilder type = new StringBuilder();
        int width = line.toLowerCase().contains("std_logic_vector") ? this.parseVector(local, type) : this.parseLine(local, type);
        if (type.toString().equals("input")) {
            this.inputs.add(new HdlModel.PortDescription(name, type.toString(), width));
        } else {
            this.outputs.add(new HdlModel.PortDescription(name, type.toString(), width));
        }
        local.close();
    }

    private void parsePorts(String input) throws IllegalVhdlContentException {
        Matcher matcher = Pattern.compile(PORTS_PATTERN, 34).matcher(input);
        if (!matcher.find() || matcher.groupCount() != 1) {
            return;
        }
        String ports = matcher.group(1);
        Scanner scanner = new Scanner(ports);
        scanner.useDelimiter(";");
        while (scanner.hasNext()) {
            String statement = scanner.next();
            if (statement.contains(",")) {
                this.parseMultiplePorts(statement.trim());
                continue;
            }
            this.parsePort(statement.trim());
        }
        scanner.close();
    }

    private int parseVector(Scanner scanner, StringBuilder type) throws IllegalVhdlContentException {
        if (scanner.findWithinHorizon(Pattern.compile(VECTOR_PATTERN, 2), 0) == null) {
            throw new IllegalVhdlContentException(Strings.S.get("vectorDeclarationException"));
        }
        MatchResult result = scanner.match();
        if (result.groupCount() != 3) {
            throw new IllegalVhdlContentException(Strings.S.get("vectorDeclarationException"));
        }
        type.append(this.getType(result.group(1).toLowerCase()));
        return Integer.parseInt(result.group(2)) - Integer.parseInt(result.group(3)) + 1;
    }

    private String removeComments() throws IllegalVhdlContentException {
        int from;
        StringBuilder input;
        try {
            input = new StringBuilder(this.source);
        }
        catch (NullPointerException ex) {
            throw new IllegalVhdlContentException(Strings.S.get("emptySourceException"));
        }
        while ((from = input.indexOf("--")) != -1) {
            int to = this.getLineEndIndex(input.toString(), from);
            input.delete(from, to);
        }
        return input.toString().trim();
    }

    public static class IllegalVhdlContentException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public IllegalVhdlContentException() {
        }

        public IllegalVhdlContentException(String message) {
            super(message);
        }

        public IllegalVhdlContentException(String message, Throwable cause) {
            super(message, cause);
        }

        public IllegalVhdlContentException(Throwable cause) {
            super(cause);
        }
    }
}

