/*
 * Decompiled with CFR 0.152.
 */
package com.cburch.logisim.std.ttl;

import com.cburch.logisim.data.Value;
import com.cburch.logisim.fpga.hdlgenerator.HdlGeneratorFactory;
import com.cburch.logisim.instance.InstancePainter;
import com.cburch.logisim.instance.InstanceState;
import com.cburch.logisim.std.ttl.AbstractTtlGate;
import com.cburch.logisim.std.ttl.Drawgates;
import com.cburch.logisim.std.ttl.Ttl7485HdlGenerator;

public class Ttl7485
extends AbstractTtlGate {
    public static final String _ID = "7485";

    public Ttl7485() {
        super(_ID, (byte)16, new byte[]{5, 6, 7}, new String[]{"B3", "A<B", "A=B", "A>B", "A>B", "A=B", "A<B", "B0", "A0", "B1", "A1", "A2", "B2", "A3"}, (HdlGeneratorFactory)new Ttl7485HdlGenerator());
    }

    @Override
    public void paintInternal(InstancePainter painter, int x, int y, int height, boolean up) {
        super.paintBase(painter, true, false);
        Drawgates.paintPortNames(painter, x, y, height, this.portNames);
    }

    @Override
    public void propagateTtl(InstanceState state) {
        int A0 = state.getPortValue(8) == Value.TRUE ? 1 : 0;
        int A1 = state.getPortValue(10) == Value.TRUE ? 2 : 0;
        int A2 = state.getPortValue(11) == Value.TRUE ? 4 : 0;
        int A3 = state.getPortValue(13) == Value.TRUE ? 8 : 0;
        int B0 = state.getPortValue(7) == Value.TRUE ? 1 : 0;
        int B1 = state.getPortValue(9) == Value.TRUE ? 2 : 0;
        int B2 = state.getPortValue(12) == Value.TRUE ? 4 : 0;
        byte A = (byte)(A3 + A2 + A1 + A0);
        int B3 = state.getPortValue(0) == Value.TRUE ? 8 : 0;
        byte B = (byte)(B3 + B2 + B1 + B0);
        if (A > B) {
            state.setPort(4, Value.TRUE, 1);
            state.setPort(5, Value.FALSE, 1);
            state.setPort(6, Value.FALSE, 1);
        } else if (A < B) {
            state.setPort(4, Value.FALSE, 1);
            state.setPort(5, Value.FALSE, 1);
            state.setPort(6, Value.TRUE, 1);
        } else if (state.getPortValue(2) == Value.TRUE) {
            state.setPort(4, Value.FALSE, 1);
            state.setPort(5, Value.TRUE, 1);
            state.setPort(6, Value.FALSE, 1);
        } else if (state.getPortValue(1) == Value.TRUE && state.getPortValue(3) == Value.TRUE) {
            state.setPort(4, Value.FALSE, 1);
            state.setPort(5, Value.FALSE, 1);
            state.setPort(6, Value.FALSE, 1);
        } else if (state.getPortValue(1) == Value.TRUE) {
            state.setPort(4, Value.FALSE, 1);
            state.setPort(5, Value.FALSE, 1);
            state.setPort(6, Value.TRUE, 1);
        } else if (state.getPortValue(3) == Value.TRUE) {
            state.setPort(4, Value.TRUE, 1);
            state.setPort(5, Value.FALSE, 1);
            state.setPort(6, Value.FALSE, 1);
        } else {
            state.setPort(4, Value.TRUE, 1);
            state.setPort(5, Value.FALSE, 1);
            state.setPort(6, Value.TRUE, 1);
        }
    }
}

