/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.beans;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jdesktop.beans.JavaBean;

public class JavaBeanProcessor
extends AbstractProcessor {
    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(JavaBean.class.getName());
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        FileObject fileObject;
        Filer filer;
        TreeSet<String> beans;
        block35: {
            if (roundEnv.processingOver()) {
                return false;
            }
            beans = new TreeSet<String>();
            for (TypeElement typeElement : roundEnv.getElementsAnnotatedWith(JavaBean.class)) {
                beans.add(typeElement.getQualifiedName().toString());
            }
            filer = this.processingEnv.getFiler();
            Object var5_6 = null;
            try {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Attempting to open manifest...");
                FileObject fileObject2 = filer.getResource(StandardLocation.SOURCE_PATH, "", "META-INF/MANIFEST.MF");
                if (fileObject2 == null) break block35;
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Succeeded: " + fileObject2.getName());
                BufferedReader r = null;
                try {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Attempting to find previously defined Java beans");
                    r = new BufferedReader(new InputStreamReader(fileObject2.openInputStream(), "UTF-8"));
                    String possibleBean = null;
                    String line = r.readLine();
                    while (line != null) {
                        if (possibleBean == null) {
                            if (line.startsWith("Name: ") && line.endsWith(".class")) {
                                possibleBean = line.substring("Name: ".length(), line.length() - ".class".length()).replace('/', '.');
                                try {
                                    Class.forName(possibleBean);
                                }
                                catch (ClassNotFoundException notABean) {
                                    possibleBean = null;
                                }
                            }
                        } else {
                            if (line.equals("Java-Bean: True")) {
                                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, possibleBean + " already defined");
                                beans.remove(possibleBean);
                            }
                            possibleBean = null;
                        }
                        line = r.readLine();
                    }
                    r.close();
                }
                catch (FileNotFoundException ignore) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Manifest not found");
                }
                catch (IOException e) {
                    throw new RuntimeException("Failed to read current Java-Bean information", e);
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException ignore) {}
                    }
                }
            }
            catch (FileNotFoundException ignore) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Manifest does not exist...");
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to load existing manifest for Java-Bean processing:\n" + e);
                return false;
            }
        }
        try {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Attempting to create output manifest...");
            fileObject = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "META-INF/MANIFEST.MF", new Element[0]);
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Succeeded: " + fileObject.getName());
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Cannot create manifest for Java-Bean processing:\n" + e);
            return false;
        }
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, "Appending Java-Beans to MANIFEST.MF");
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, ((Object)beans).toString());
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter(fileObject.openOutputStream(), "UTF-8"));
            pw.println();
            for (String value : beans) {
                pw.println("Name: " + value + ".class");
                pw.println("Java-Bean: True");
                pw.println();
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to write Java-Bean information", e);
        }
        finally {
            if (pw != null) {
                pw.close();
            }
        }
        return false;
    }
}

