/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.cli.common.profiling;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.cli.common.profiling.AsyncProfilerHelper;
import org.jetbrains.kotlin.cli.common.profiling.AsyncProfilerReflected;
import org.jetbrains.kotlin.gradle.internal.platform.jvm.JvmPlatforms;
import org.jetbrains.kotlin.gradle.internal.util.PerformanceManager;

@Metadata(k=1, mv={2, 0, 0}, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0007\u0018\u0000 $2\u00020\u0001:\u0001$B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000f\u0010\n\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u000f\u0010\f\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\f\u0010\u000bJ\u000f\u0010\r\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\r\u0010\u000bJ\u0017\u0010\u000f\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0011\u001a\u00020\tH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u000bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0006\u001a\u00020\u00058\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0019\u001a\u00020\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001c\u001a\u00020\u001b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001f\u001a\u00020\u001e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001f\u0010 R\u0016\u0010\"\u001a\u00020!8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\"\u0010#\u00a8\u0006%"}, d2={"Lorg/jetbrains/kotlin/cli/common/profiling/ProfilingCompilerPerformanceManager;", "Lorg/jetbrains/kotlin/gradle/internal/util/PerformanceManager;", "", "profilerPath", "command", "Ljava/io/File;", "outputDir", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/io/File;)V", "", "startProfiling", "()V", "stopProfiling", "restartProfiling", "postfix", "dumpProfile", "(Ljava/lang/String;)V", "notifyCompilationFinished", "Ljava/lang/String;", "getCommand", "()Ljava/lang/String;", "Ljava/io/File;", "getOutputDir", "()Ljava/io/File;", "Lorg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerReflected;", "profiler", "Lorg/jetbrains/kotlin/cli/common/profiling/AsyncProfilerReflected;", "Ljava/util/Date;", "runDate", "Ljava/util/Date;", "Ljava/text/SimpleDateFormat;", "formatter", "Ljava/text/SimpleDateFormat;", "", "active", "Z", "Companion", "cli"}, xi=48)
@Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
public final class ProfilingCompilerPerformanceManager
extends PerformanceManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String command;
    @NotNull
    private final File outputDir;
    @NotNull
    private final AsyncProfilerReflected profiler;
    @NotNull
    private final Date runDate;
    @NotNull
    private final SimpleDateFormat formatter;
    private boolean active;

    public ProfilingCompilerPerformanceManager(@NotNull String profilerPath, @NotNull String command, @NotNull File outputDir) {
        Intrinsics.checkNotNullParameter((Object)profilerPath, (String)"profilerPath");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Intrinsics.checkNotNullParameter((Object)outputDir, (String)"outputDir");
        super(JvmPlatforms.INSTANCE.getDefaultJvmPlatform(), "Profiling");
        this.command = command;
        this.outputDir = outputDir;
        this.profiler = AsyncProfilerHelper.INSTANCE.getInstance(profilerPath);
        this.runDate = new Date();
        this.formatter = new SimpleDateFormat("yyyy-MM-dd__HH-mm");
        this.startProfiling();
    }

    @NotNull
    public final String getCommand() {
        return this.command;
    }

    @NotNull
    public final File getOutputDir() {
        return this.outputDir;
    }

    private final void startProfiling() {
        this.profiler.execute(this.command);
        this.active = true;
    }

    private final void stopProfiling() {
        if (this.active) {
            this.profiler.stop();
        }
        this.active = false;
    }

    private final void restartProfiling() {
        this.stopProfiling();
        this.startProfiling();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void dumpProfile(String postfix) {
        this.outputDir.mkdirs();
        File outputFile2 = FilesKt.resolve((File)this.outputDir, (String)("snapshot-" + this.formatter.format(this.runDate) + '-' + postfix + ".collapsed"));
        String profile = this.profiler.execute("collapsed");
        Closeable closeable = new FileOutputStream(outputFile2);
        Throwable throwable = null;
        try {
            FileOutputStream out = (FileOutputStream)closeable;
            boolean bl = false;
            for (String chunk : StringsKt.chunkedSequence((CharSequence)profile, (int)0x100000)) {
                byte[] byArray = chunk.getBytes(Charsets.UTF_8);
                Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
                out.write(byArray);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        this.active = false;
    }

    @Override
    public void notifyCompilationFinished() {
        this.dumpProfile("final");
        this.stopProfiling();
    }

    @Metadata(k=1, mv={2, 0, 0}, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/cli/common/profiling/ProfilingCompilerPerformanceManager$Companion;", "", "<init>", "()V", "", "profileCompilerArgument", "Lorg/jetbrains/kotlin/cli/common/profiling/ProfilingCompilerPerformanceManager;", "create", "(Ljava/lang/String;)Lorg/jetbrains/kotlin/cli/common/profiling/ProfilingCompilerPerformanceManager;", "cli"}, xi=48)
    @Deprecated(message="You're using a Kotlin compiler class bundled into KGP for its internal needs.\nThis is discouraged and will not be supported in future releases.\nThe class in this artifact is scheduled for removal in Kotlin 2.2. Please define dependency on it in an alternative way.\nSee https://kotl.in/gradle/internal-compiler-symbols for more details")
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ProfilingCompilerPerformanceManager create(@NotNull String profileCompilerArgument) {
            Intrinsics.checkNotNullParameter((Object)profileCompilerArgument, (String)"profileCompilerArgument");
            String[] stringArray = new String[]{":"};
            List list = StringsKt.split$default((CharSequence)profileCompilerArgument, (String[])stringArray, (boolean)false, (int)3, (int)2, null);
            String path = (String)list.get(0);
            String command = (String)list.get(1);
            String outputDir = (String)list.get(2);
            return new ProfilingCompilerPerformanceManager(path, command, new File(outputDir));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

