/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.google.common.graph;

import java.util.AbstractSet;
import java.util.Set;
import javax.annotation.CheckForNull;
import org.jetbrains.kotlin.com.google.common.graph.BaseGraph;
import org.jetbrains.kotlin.com.google.common.graph.ElementTypesAreNonnullByDefault;
import org.jetbrains.kotlin.com.google.common.graph.EndpointPair;

@ElementTypesAreNonnullByDefault
abstract class IncidentEdgeSet<N>
extends AbstractSet<EndpointPair<N>> {
    final N node;
    final BaseGraph<N> graph;

    IncidentEdgeSet(BaseGraph<N> graph, N node2) {
        this.graph = graph;
        this.node = node2;
    }

    @Override
    public boolean remove(@CheckForNull Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        if (this.graph.isDirected()) {
            return this.graph.inDegree(this.node) + this.graph.outDegree(this.node) - (this.graph.successors((Object)this.node).contains(this.node) ? 1 : 0);
        }
        return this.graph.adjacentNodes(this.node).size();
    }

    @Override
    public boolean contains(@CheckForNull Object obj2) {
        if (!(obj2 instanceof EndpointPair)) {
            return false;
        }
        EndpointPair endpointPair = (EndpointPair)obj2;
        if (this.graph.isDirected()) {
            if (!endpointPair.isOrdered()) {
                return false;
            }
            Object source2 = endpointPair.source();
            Object target2 = endpointPair.target();
            return this.node.equals(source2) && this.graph.successors((Object)this.node).contains(target2) || this.node.equals(target2) && this.graph.predecessors((Object)this.node).contains(source2);
        }
        if (endpointPair.isOrdered()) {
            return false;
        }
        Set<N> adjacent = this.graph.adjacentNodes(this.node);
        Object nodeU = endpointPair.nodeU();
        Object nodeV = endpointPair.nodeV();
        return this.node.equals(nodeV) && adjacent.contains(nodeU) || this.node.equals(nodeU) && adjacent.contains(nodeV);
    }
}

