# First steps in Image Classification with Ikomia API

This guide will help you get started with classification tasks using the Ikomia API. We will cover both inference and training aspects.

## Inference

Inference is the process of using a pre-trained model to classify new, unseen data. To perform inference with the Ikomia API, follow these steps:

1. **Load the pre-trained model**: Import the model you want to use for classification.
2. **Preprocess the input data**: Prepare the input data according to the model requirements (e.g., resizing, normalization).
3. **Perform the classification**: Use the pre-trained model to classify the input data.
4. **Post-process the results**: Analyze and visualize the classification results.

## Training

Training is the process of creating a classification model from a dataset. To train a model using the Ikomia API, follow these steps:

1. **Prepare the dataset**: Organize and preprocess the dataset for training (e.g., data augmentation, splitting into training and validation sets).
2. **Define the model architecture**: Design the structure of the neural network or choose a pre-defined architecture.
3. **Configure the training parameters**: Set up the training parameters such as learning rate, batch size, and number of epochs.
4. **Train the model**: Start the training process and monitor the progress.
5. **Evaluate the model performance**: Assess the performance of the trained model using various metrics and visualization tools.


For more detailed information and examples, refer to the [Ikomia API documentation](https://ikomia.com/docs/api/).
