# Ikomia API Documentation

<!-- PROJECT LOGO -->
<div align="center">
  <a href="https://github.com/Ikomia-dev/IkomiaAPI">
    <img src="https://avatars.githubusercontent.com/u/53618017?s=400&u=e9c62c77b7c33b6b7f4883b115a0d7d05dcca9ec&v=4" alt="Logo" width="100" height="100">
  </a>
  <h3 align="center">Your end to end open source API to prototype Computer Vision solutions</h3>
</div>
<br />
<p align="center">
    <a href="https://github.com/Ikomia-dev/IkomiaAPI/stargazers">
        <img alt="Stars" src="https://img.shields.io/github/stars/Ikomia-dev/IkomiaAPI">
    </a>
    <a href="https://ikomia.com/en/computer-vision-api/">
        <img alt="Website" src="https://img.shields.io/website/http/ikomia.com/en.svg?down_color=red&down_message=offline&up_message=online">
    </a>
    <a href="">
        <img alt="Python" src="https://img.shields.io/badge/os-win%2C%20linux-9cf">
    </a>
    <a href="">
        <img alt="Python" src="https://img.shields.io/badge/python-3.8%2C%203.9%2C%203.10%2C%203.11-blueviolet">
    </a>
    <a href="https://github.com/Ikomia-dev/IkomiaAPI/blob/main/LICENSE.md">
        <img alt="GitHub" src="https://img.shields.io/github/license/Ikomia-dev/IkomiaAPI.svg?color=blue">
    </a>
    <a href="https://github.com/Ikomia-dev/IkomiaAPI/tags">
        <img alt="GitHub tags" src="https://img.shields.io/github/v/release/Ikomia-dev/IkomiaAPI.svg?color=red">
    </a>
    <br>
    <a href="https://discord.com/invite/82Tnw9UGGc">
        <img alt="Discord community" src="https://img.shields.io/badge/Discord-white?style=social&logo=discord">
    </a> 
</p>

<p align="center">
  <kbd>
    <img src="https://user-images.githubusercontent.com/42171814/200714085-399b7625-81ae-4c71-bb39-8483bf4e204e.gif"/>
  </kbd>
</p>


```{toctree}
:hidden:

getting_started
```

```{toctree}
:caption: Advanced Ikomia Guide
:hidden:

advanced_guide/index
integration/index
```

```{toctree}
:caption: Tutorials
:hidden:

tutorials/how_to_on_stream
object_detection/index
```

```{toctree}
:caption: Bonus
:hidden:

bonus/virtual_env
```

```{toctree}
:caption: Development
:hidden:

modules
release_notes/index
```

<!-- ABOUT THE PROJECT -->
## About The Project

Ikomia API is an **open source dev tool** designed to simplify the development and deployment of Computer Vision solutions. 
It enables effortless integration of state-of-the-art algorithms from multiple sources, such as **OpenCV**, **Detectron2**, **OpenMMLab**, and **YOLO**, into your projects.

With Ikomia API, you can focus on building powerful and innovative Computer Vision applications without worrying about the complexities of managing dependencies and integrating different frameworks. 
The API handles the download, installation and management of the selected algorithms, enabling the creation of customized solutions with minimal coding effort.

Whether you're a seasoned developer or new to the field of Computer Vision, Ikomia API provides an accessible and efficient way to stay up-to-date with the latest advancements and bring your ideas to life.

## Key Features

- **Ease of use**: Quickly integrate state-of-the-art Computer Vision algorithms into your projects with just a few lines of code.
- **Cross-platform**: Compatible with Windows and Linux operating systems.
- **Support for popular frameworks**: Seamlessly use popular frameworks like OpenCV, Detectron2, OpenMMLab, and YOLO.
- **Automatic dependency management**: Ikomia API automatically downloads, installs, and manages the requirements for the chosen algorithms.
- **Modular design**: Easily mix and match algorithms from different repositories to create custom solutions.
- **Open source**: Benefit from the collaborative development and transparency of an open source project.
- **Community**: Join the Slack community to get support, share ideas, and collaborate with other developers.
- **Regular updates**: Stay up-to-date with the latest Computer Vision advancements through frequent releases and updates.