#  :milky_way: Ikomia API Notebooks Collection

:star: Welcome to the Ikomia API Notebooks Collection!  Explore our wide range of Jupyter notebooks for computer vision tasks, including object detection, segmentation, classification, and more. 

## Documentation Notebook

| Notebook |   Description      |
|:----------|:-------------|
| [Make a simple workflow](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_make_a_simple_workflow_with_Ikomia_API.ipynb) |Learn how to use the Ikomia API to easily prototype some Computer Vision workflows |
| [Ikomia SCALE welcome on board](https://github.com/Ikomia-dev/notebooks/blob/main/examples/Ikomia_SCALE_welcome_on_board.ipynb) |Shows how to get started with Ikomia SCALE, a SaaS platform for deploying Ikomia workflows on dedicated endpoints| 
| [Ikomia SCALE - Deploy FLUX.1](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_deploy_Ikomia_SCALE_FLUX1.ipynb) |End-to-end example for deploying text-to-image models on dedicated endpoints| 



## Object Detection

| Notebook |   Description      |
|:----------|:-------------|
| [Run Camera Stream Processing](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Camera_Stream_Processing_with_Ikomia_API.ipynb) | Show how run video stream for real-time processing using YOLOv7 as an example | 
| [Run Face Detection and Blur](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Face_Detection_and_Blur_with_Ikomia_API.ipynb) | Shown how to create a workflow for face detection with Kornia and blurring with OpenCV |
| [Use Detectron2 Object Detection](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_Detectron2_Object_Detection_with_Ikomia_API.ipynb) | Shows how to use Detecton 2 for object detection| 
| [Use MMDetection](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_MMDetection_with_Ikomia_API.ipynb) | Shows how to run the MMDetection toolkit | |
| [Run Grounding Dino](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Grounding_DINO_with_Ikomia_API.ipynb) | Shows how to Grounding Dino for Zero-Shot object detection | 
| [Train YOLOR construction safety dataset](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_train_YOLOR_with_Ikomia_API_construction_safety_dataset%20.ipynb) | Shows how to train to fine-tune a YOLOR model on a safety construction dataset| 
| [Train YOLO v7](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_train_YOLO_v7_with_Ikomia_API.ipynb) |Shows how to train to fine-tune a YOLOv7 model on aerial airplane dataset | 
| [Train YOLO v9](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_train_YOLO_v9_with_Ikomia_API.ipynb) | Shows how to train to fine-tune a YOLOv9 model on a basketball dataset| 
| [Use YOLO-World](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_YOLO_World_with_Ikomia_API.ipynb) | Shows how to use YOLO-World for zero-shot object detection| 
| [Train YOLO v10](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_train_YOLO_v10_with_Ikomia_API.ipynb) | Shows how to train to fine-tune a YOLOv10 model on a Chess pieces dataset| 
| [Use OWLv2](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_OWLv2_with_Ikomia_API.ipynb) | Shows how to use OWLv2 for zero-shot object detection| 





## Segmentation

| Notebook |   Description      |
|:----------|:-------------|
| [Run DeepLabPlus](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_DeepLabPlus_with_Ikomia_API.ipynb) | Shows how to run DeepLabV3 + for semantic segmentation |
| [Run Mask R-CNN](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Mask_R-CNN_with_Ikomia_API.ipynb) | Shows how to run Mask R-CNN for segmentation | 
| [Run MnasNet](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_MnasNet_with_Ikomia_API.ipynb) |Shows how to run MnasNet for instance segmentation | 
| [Run YOLACT](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_YOLACT_with_Ikomia_API.ipynb) |Shows how to run YOLACT for instance segmentation | 
| [Run SparseInst](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_SparseInst_with_Ikomia_API.ipynb) |Shows how to run SparseInst for instance segmentation   | 
| [Run YOLOP v2](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_YOLOP_v2_with_Ikomia_API.ipynb) |Shows how to run YOLOPv2 road, lane segmentation and vehicule detection | 
| [Use MMSegmentation](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_MMSegmentation_with_Ikomia_API.ipynb) |Shows how to use the MMsegmentation toolkit | 
| [Use MobileSAM](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_MobileSAM_with_Ikomia_API.ipynb) |Shows how to run the Faster Segment Anything Model | 
| [Train YOLO v8 segmentation](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_train_YOLO_v8_seg_with_Ikomia_API_coral_dataset.ipynb) |Shows how to fine-tuned YOLOv8 instance segmentation on a coral dataset | 
| [Use YOLO v9 & SAM](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_YOLOv9_and_SAM_with_Ikomia_API.ipynb) |Shows how to create a workflow using object detection with YOLOv9 - object filtering by class - and segmentation with mobile_sam or SAM | 
| [Use SAM2](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_SAM_2_with_Ikomia_API.ipynb) |Shows how to run SAM2 | 



## Classification

| Notebook |   Description      |
|:----------|:-------------|
| [Run Faster R-CNN](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Faster_R-CNN_with_Ikomia_API.ipynb) | |
| [Run ResNext](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_ResNext_with_Ikomia_API.ipynb) | | |
| [Train Classification Model](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_train_Classification_Model_with_Ikomia_API.ipynb) | |

## Diffusion & Image Art

| Notebook |   Description      |
|:----------|:-------------|
| [Run Neural Style Transfer](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Neural_Style_Transfer_with_Ikomia_API.ipynb) | | 
| [Run Kandinsky](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Kandinsky_with_Ikomia_API.ipynb) | | 
| [Run Stable Diffusion](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Stable_Diffusion_with_Ikomia_API.ipynb) | | 
| [Use SAM and SD inpaint](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_SAM_and_SD_inpaint_with_Ikomia_API.ipynb) | |
| [Run Stable Cascade](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Stable_Cascade_with_Ikomia_API.ipynb) | |
| [Run and deploy Face inpainting](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_deploy_Ikomia_SCALE_face_inpainting.ipynb) | |


## Background Removal

| Notebook |   Description      |
|:----------|:-------------|
| [Run MODNet](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_MODNet_with_Ikomia_API.ipynb) | | 
| [Run P3M](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_P3M_with_Ikomia_API.ipynb) | | 

## Super Resolution and Image Restoration

| Notebook |   Description      |
|:----------|:-------------|
| [Run SwinIR super resolution](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_SwinIR_super_resolution_with_Ikomia_API.ipynb) | | 


## Tracking

| Notebook |   Description      |
|:----------|:-------------|
| [Use ByteTrack](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_ByteTrack_with_Ikomia_API.ipynb) | |
| [Use DeepSORT](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_DeepSORT_with_Ikomia_API.ipynb) | | 

## Pose Estimation

| Notebook |   Description      |
|:----------|:-------------|
| [Run YOLO v8 pose](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_YOLO_v8_pose_with_Ikomia_API.ipynb) | | 

## OCR (Optical Character Recognition)

| Notebook |   Description      |
|:----------|:-------------|
| [Use MMOCR](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_MMOCR_with_Ikomia_API.ipynb) | |
| [Run and deploy MMOCR](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_deploy_Ikomia_SCALE_text_extraction.ipynb) | |


## Other

| Notebook |   Description      |
|:----------|:-------------|
| [Use Canny](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_Canny_with_Ikomia_API.ipynb) ||
| [Use Google Cloud Vision API](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_use_Google_Cloud_Vision_API_with_Ikomia_API.ipynb) ||
| [Use Depth Anything](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Depth_Anything_with_Ikomia_API.ipynb) ||
| [Use Florence-2](https://github.com/Ikomia-dev/notebooks/blob/main/examples/HOWTO_run_Florence_2_with_Ikomia_API.ipynb) ||

