/*
 * Decompiled with CFR 0.152.
 */
package vmm.internal;

import com.sun.jna.Pointer;
import com.sun.jna.ptr.PointerByReference;
import leechcore.ILeechCoreTlpCallback;
import leechcore.ILeechCoreTlpContext;
import vmm.internal.JnaObjectMap;
import vmm.internal.LeechCoreImpl;
import vmm.internal.LeechCoreNative;
import vmm.internal.LeechCoreNativeEx;

class LeechCoreTlpContextImpl
implements ILeechCoreTlpContext {
    private LeechCoreImpl lc;
    private Integer key;
    private Pointer keyPointer;
    private ILeechCoreTlpCallback cbUser;
    private LeechCoreNative.CALLBACK_TLP cbNative;

    LeechCoreTlpContextImpl() {
    }

    static LeechCoreTlpContextImpl initializeLeechCoreTlpContextImpl(LeechCoreImpl lc, ILeechCoreTlpCallback cbUser) {
        LeechCoreTlpContextImpl ctx = new LeechCoreTlpContextImpl();
        ctx.cbNative = new LeechCoreNative.CALLBACK_TLP(){

            @Override
            public void invoke(int ctxNative, int cbTlp, Pointer pbTlp, int cbInfo, String szInfo) {
                try {
                    byte[] tlp = pbTlp.getByteArray(0L, cbTlp);
                    Integer key = ctxNative;
                    LeechCoreTlpContextImpl ctx = (LeechCoreTlpContextImpl)JnaObjectMap.getInstance().get(key);
                    ctx.cbUser.LeechCoreTlpCallback(ctx.lc, tlp, szInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        ctx.lc = lc;
        ctx.cbUser = cbUser;
        ctx.key = JnaObjectMap.getInstance().put(ctx);
        ctx.keyPointer = new Pointer(ctx.key.longValue());
        if (!LeechCoreNative.INSTANCE.LcSetOption(lc.hLC, 0x300009000000000L, 1L)) {
            ctx.close();
            return null;
        }
        if (!LeechCoreNative.INSTANCE.LcCommand(lc.hLC, 2305844194624667648L, 0, ctx.keyPointer, null, null)) {
            ctx.close();
            return null;
        }
        if (!LeechCoreNativeEx.INSTANCE.LcCommand(lc.hLC, 2305844198919634944L, 0, ctx.cbNative, null, null)) {
            ctx.close();
            return null;
        }
        return ctx;
    }

    @Override
    public void close() {
        if (this.lc == null || this.key == null) {
            return;
        }
        PointerByReference pptr = new PointerByReference();
        if (!LeechCoreNative.INSTANCE.LcCommand(this.lc.hLC, 2305844224689438720L, 0, null, pptr, null)) {
            return;
        }
        if (Pointer.nativeValue((Pointer)pptr.getPointer()) != this.key.longValue()) {
            return;
        }
        LeechCoreNative.INSTANCE.LcCommand(this.lc.hLC, 2305844198919634944L, 0, null, null, null);
        LeechCoreNative.INSTANCE.LcCommand(this.lc.hLC, 2305844194624667648L, 0, null, null, null);
        JnaObjectMap.getInstance().remove(this.key);
        this.keyPointer = null;
        this.cbNative = null;
        this.cbUser = null;
        this.key = null;
        this.lc = null;
    }

    public void finalize() {
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String toString() {
        return "LeechCoreTlpContext";
    }
}

