/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activeio.xnet.hba;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.activeio.xnet.hba.IPAddressPermission;

public class NetmaskIPv6AddressPermission
implements IPAddressPermission {
    private static final Pattern MASK_VALIDATOR = Pattern.compile("^(([a-fA-F0-9]{1,4}:){7}[a-fA-F0-9]{1,4})/((\\d{1,3})|(([a-fA-F0-9]{1,4}:){7}[a-fA-F0-9]{1,4}))$");
    private final byte[] networkAddressBytes;
    private final byte[] netmaskBytes;

    public static boolean canSupport(String mask) {
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        return matcher.matches();
    }

    public NetmaskIPv6AddressPermission(String mask) {
        int value;
        Matcher matcher = MASK_VALIDATOR.matcher(mask);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Mask " + mask + " does not match pattern " + MASK_VALIDATOR.pattern());
        }
        this.networkAddressBytes = new byte[16];
        int pos = 0;
        StringTokenizer tokenizer = new StringTokenizer(matcher.group(1), ":");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            value = Integer.parseInt(token, 16);
            this.networkAddressBytes[pos++] = (byte)((value & 0xFF00) >> 8);
            this.networkAddressBytes[pos++] = (byte)value;
        }
        this.netmaskBytes = new byte[16];
        String netmask = matcher.group(4);
        if (null != netmask) {
            value = Integer.parseInt(netmask);
            pos = value / 8;
            int shift = 8 - value % 8;
            for (int i = 0; i < pos; ++i) {
                this.netmaskBytes[i] = -1;
            }
            this.netmaskBytes[pos] = (byte)(255 << shift);
        } else {
            pos = 0;
            tokenizer = new StringTokenizer(matcher.group(5), ":");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                int value2 = Integer.parseInt(token, 16);
                this.netmaskBytes[pos++] = (byte)((value2 & 0xFF00) >> 8);
                this.netmaskBytes[pos++] = (byte)value2;
            }
        }
    }

    public boolean implies(InetAddress address) {
        if (!(address instanceof Inet6Address)) {
            return false;
        }
        byte[] byteAddress = address.getAddress();
        for (int i = 0; i < 16; ++i) {
            if ((this.netmaskBytes[i] & byteAddress[i]) == this.networkAddressBytes[i]) continue;
            return false;
        }
        return true;
    }
}

