/*
 * Decompiled with CFR 0.152.
 */
package org.linkedin.util.io.resource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.linkedin.util.io.PathUtils;
import org.linkedin.util.io.resource.Resource;
import org.linkedin.util.io.resource.ResourceInfo;
import org.linkedin.util.io.resource.internal.AbstractResource;
import org.linkedin.util.io.resource.internal.FileResourceProvider;
import org.linkedin.util.io.resource.internal.InternalResourceProvider;

public class FileResource
extends AbstractResource {
    private final File _file;

    public FileResource(InternalResourceProvider resourceProvider, String path, File file) {
        super(resourceProvider, path);
        this._file = file;
    }

    @Override
    public boolean exists() {
        return this._file.exists();
    }

    @Override
    public File getFile() throws IOException {
        return this._file;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return new FileInputStream(this._file);
    }

    @Override
    public ResourceInfo getInfo() throws IOException {
        if (this._file.exists()) {
            return new FileInfo();
        }
        throw new FileNotFoundException(this._file.getPath());
    }

    @Override
    public boolean isDirectory() {
        return this._file.isDirectory();
    }

    @Override
    public URI toURI() {
        return this._file.toURI();
    }

    public static Resource create(String filename) {
        return FileResource.create(new File(filename));
    }

    public static Resource create(File file) {
        try {
            String path = file.getCanonicalPath();
            if (file.isDirectory()) {
                path = PathUtils.addTrailingSlash(path);
            }
            return FileResource.create(new File("/"), path);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid file " + file, e);
        }
    }

    public static Resource createFromRoot(File rootFile) {
        File root = rootFile;
        String path = "/";
        if (!root.isDirectory()) {
            root = rootFile.getParentFile();
            path = rootFile.getName();
        }
        return FileResource.create(root, path);
    }

    public static Resource create(File root, String path) {
        FileResourceProvider frp = null;
        try {
            frp = new FileResourceProvider(root);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return frp.createResource(path);
    }

    private class FileInfo
    implements ResourceInfo {
        private FileInfo() {
        }

        @Override
        public long getContentLength() throws IOException {
            return FileResource.this._file.isDirectory() ? 0L : FileResource.this._file.length();
        }

        @Override
        public long getLastModified() throws IOException {
            return FileResource.this._file.lastModified();
        }
    }
}

