/**
 * @author: bergo
 * @homepage: https://bergo.dev
 */

import { LanguageDict } from '@common/types'

const lang: LanguageDict = {
  _app_name: 'SwitchHosts',
  _key: 'de',
  _name: 'Deutsch',
  about: 'Über',
  acknowledgement: 'Danksagung',
  advanced: 'Erweitert',
  all: 'Alle',
  append: 'Anhängen',
  auto_refresh: 'Automatisch aktualisieren',
  btn_cancel: 'Abbrechen',
  btn_ok: 'OK',
  change: 'Ändern',
  check_update: 'Aktualisierung prüfen',
  choice_mode: 'Auswahlmodus',
  choice_mode_default: 'Standard',
  choice_mode_desc:
    'Gilt nur für das oberste Element, jeder Ordner kann seinen eigenen Auswahlmodus festlegen.',
  choice_mode_multiple: 'Mehrfach',
  choice_mode_single: 'Einfach',
  choices: 'Auswahlen',
  chosen: 'Ausgewählt',
  clear_history: 'Verlauf löschen',
  click_to_open: 'Klicken zum Öffnen',
  close: 'Schließen',
  colon: ': ',
  commands: 'Befehle',
  commands_help: 'Die folgenden Systembefehle werden ausgeführt, wenn Hosts angewendet werden:',
  commands_title: 'Befehl nach dem Anlegen eines Hosts',
  comment_current_line: 'Aktuelle Zeile kommentieren',
  content: 'Inhalt',
  copy: 'Kopieren',
  cut: 'Ausschneiden',
  day: 'Tag',
  days: 'Tage',
  delete: 'Löschen',
  download: 'Herunterladen',
  edit: 'Bearbeiten',
  export: 'Exportieren',
  export_done: 'Der Export ist abgeschlossen.',
  fail: 'Fehlgeschlagen!',
  feedback: 'Rückmeldung',
  file: 'Datei',
  find: 'Suchen',
  find_all: 'Alles suchen',
  find_and_replace: 'Suchen und ersetzen',
  find_history: 'Verlauf suchen',
  folder: 'Ordner',
  front: 'Vorderseite',
  general: 'Allgemein',
  group: 'Gruppe',
  help: 'Hilfe',
  hide: 'Ausblenden',
  hide_at_launch: 'Beim Start ausblenden',
  hide_dock_icon: 'Dock-Symbol ausblenden',
  hide_history: 'Verlauf ausblenden',
  hide_others: 'Andere ausblenden',
  homepage: 'Startseite',
  host: 'Gastgeber',
  hosts_add: 'Neue Hosts hinzufügen',
  hosts_delete: 'Diesen Host löschen',
  hosts_delete_confirm: 'Sind Sie sicher, dass Sie die aktuellen Hosts löschen wollen?',
  hosts_edit: 'Hosts bearbeiten',
  hosts_title: 'Titel des Hosts',
  hosts_type: 'Hosts Typ',
  hosts_updated: 'Die Hosts-Datei wurde aktualisiert.',
  hour: 'Stunde',
  hours: 'Stunden',
  http_api_on: 'HTTP-API eingeschaltet',
  http_api_on_desc:
    'Läuft auf Port {0}, kann von Software von Drittanbietern wie Alfred verwendet werden, um den Host zu wechseln.',
  http_api_only_local: 'HTTP-API hört nur auf 127.0.0.1',
  ignore_case: 'Groß- und Kleinschreibung ignorieren',
  import: 'Importieren',
  import_done: 'Der Import ist abgeschlossen.',
  import_fail: 'Der Import ist fehlgeschlagen!',
  import_from_url: 'Importieren von URL',
  is_latest_version_inform: 'Super, Sie haben die neueste Version!',
  check_update_failed: 'Suche nach Updates fehlgeschlagen!',
  item_found: '{0} Einträge gefunden.',
  items: 'items',
  items_found: '{0} Einträge gefunden.',
  language: 'Sprache',
  last_refresh: 'Letzte Aktualisierung: ',
  latest_version_desc: 'Die neueste Version ist: {0}',
  line: 'Zeile',
  lines: 'Zeilen',
  loading: 'Loading...',
  local: 'Lokal',
  match: 'Übereinstimmung',
  migrate_confirm:
    'SwitchHosts v4.0 verwendet ein neues Datenspeicherformat, möchten Sie alte Daten in das neue Format migrieren?',
  migrate_data: 'Daten migrieren',
  minimize: 'Minimieren',
  minute: 'Minute',
  minutes: 'Minuten',
  move_items_to_trashcan: 'Verschiebe {0} Objekte in den Mülleimer',
  move_to_trashcan: 'In die Mülltonne verschieben',
  multi_chose_folder_switch_all: 'Mehrfachauswahl-Ordnerschalter zur Steuerung von Unterelementen',
  need_to_relaunch: 'Muss neu gestartet werden',
  need_to_relaunch_after_setting_changed:
    'Die Einstellungen wurden geändert und werden erst nach einem Neustart der App wirksam.',
  never: 'Niemals',
  new: 'Neu',
  new_version_found: 'Neue Version gefunden',
  next: 'Nächste',
  no_access_to_hosts: 'Keine Berechtigung zum Schreiben in die Hosts-Datei.',
  no_record: 'Kein Datensatz',
  overwrite: 'Überschreiben',
  password: 'Passwort',
  paste: 'Einfügen',
  port: 'Anschluss',
  preferences: 'Präferenzen',
  previous: 'Vorhergehend',
  protocol: 'Protokoll',
  proxy: 'Proxy',
  quit: 'Beenden',
  read_only: 'Nur Lesen',
  redo: 'Wiederherstellen',
  refresh: 'Auffrischen',
  regexp: 'Regulärer Ausdruck',
  reload: 'Neu laden',
  remote: 'Entfernt',
  remove_duplicate_records: 'Doppelte Datensätze entfernen',
  remove_duplicate_records_desc:
    'Wenn eine Domain auf mehrere IPs verweist, wird nur die erste wirksam, die folgenden werden in Kommentare umgewandelt.',
  replace: 'Ersetzen',
  replace_all: 'Ersetze alle',
  replace_history: 'Historie ersetzen',
  reset: 'Zurücksetzen',
  reset_data_dir_confirm:
    'Sind Sie sicher, dass Sie den Datenordner an der Standardadresse ({0}) wiederherstellen wollen?',
  reset_zoom: 'Zoom zurücksetzen',
  search: 'Suchen',
  select_all: 'Alles auswählen',
  selected: 'Ausgewählt',
  show_dock_icon: 'Dock-Symbol anzeigen',
  show_history: 'Historie anzeigen',
  show_main_window: 'Hauptfenster anzeigen',
  show_title_on_tray: 'Titel auf dem Tablett anzeigen',
  source_code: 'Quellcode',
  success: 'Erfolg!',
  sudo_prompt_title: 'Geben Sie Ihr sudo-Passwort ein',
  system_hosts: 'System-Hosts',
  system_hosts_history: 'Historische Versionen der System-Hosts',
  system_hosts_history_delete_confirm: 'Sind Sie sicher, dass Sie dieses Element löschen wollen?',
  system_hosts_history_help:
    'Wenn die Gesamtzahl der historischen Einträge diese Grenze überschreitet, wird der älteste Eintrag gelöscht.',
  system_hosts_history_limit: 'Maximale Anzahl von Datensätzen: ',
  test: 'Test',
  theme: 'Thema',
  theme_dark: 'Dunkel',
  theme_light: 'Hell',
  title: 'Titel',
  to_show_source: 'Durch Doppelklick wird der Quellcode angezeigt.',
  toggle_developer_tools: 'Entwicklerwerkzeuge einschalten',
  toggle_dock_icon: 'Das Dock-Symbol einschalten',
  toggle_full_screen: 'Vollbildmodus einschalten',
  trashcan: 'Mülleimer',
  trashcan_clear: 'Den Mülleimer leeren',
  trashcan_clear_confirm: 'Sind Sie sicher, dass Sie den Mülleimer leeren wollen?',
  trashcan_delete_confirm: 'Möchten Sie dieses Objekt vollständig löschen?',
  trashcan_restore: 'Wiederherstellen',
  tray_mini_window: 'Taskleistensymbol-Verknüpfung',
  undo: 'Rückgängig machen',
  unhide: 'Einblenden',
  untitled: 'Ohne Titel',
  url_placeholder: 'http:// oder https:// oder file://',
  usage_data_agree: 'Ja, übermitteln Sie anonymisierte Nutzungsdaten',
  usage_data_help:
    'Möchten Sie uns helfen, SwitchHosts zu verbessern, indem Sie regelmäßig anonyme Nutzungsdaten übermitteln?',
  usage_data_title: 'Machen Sie SwitchHosts besser!',
  use_proxy: 'Proxy verwenden',
  use_system_window_frame:
    'Verwenden Sie den Systemfensterrahmen, ein Neustart der Anwendung ist erforderlich',
  view: 'Ansicht',
  where_is_my_data: 'Wo sind meine Daten gespeichert?',
  where_is_my_hosts: 'Wo ist meine Hosts-Datei?',
  window: 'Fenster',
  write_mode: 'Schreibmodus',
  write_mode_append_help:
    'Hängen Sie die neuen Datensätze an das Ende der Hosts-Datei des Systems an.',
  write_mode_overwrite_help: 'Überschreibt die Systemhosts-Datei mit den neuen Datensätzen.',
  write_mode_set: 'Schreibmodus einstellen',
  your_data_is: 'Ihre Datendateien sind gespeichert in:',
  your_hosts_file_is: 'Ihre Hosts-Datei befindet sich in:',
  zoom: 'Vergrößern',
  zoom_in: 'Vergrößern',
  zoom_out: 'Herauszoomen',
}

export default lang
