/**
 * @author: Aktilor
 * @homepage: https://github.com/Aktilor
 */

import { LanguageDict } from '@common/types'

const lang: LanguageDict = {
  _app_name: 'SwitchHosts',
  _key: 'fr',
  _name: 'Français',
  about: 'À propos',
  acknowledgement: 'Remerciements',
  advanced: 'Avancé',
  all: 'Tout',
  append: 'Ajouter',
  auto_refresh: 'Rafraîchissement automatique',
  btn_cancel: 'Annuler',
  btn_ok: 'OK',
  change: 'Changer',
  check_update: 'Vérifier les mises à jour',
  choice_mode: 'Choice mode',
  choice_mode_default: 'Défaut',
  choice_mode_desc:
    "Uniquement valable pour l'élément le plus haut, chaque dossier peut définir son propre mode.",
  choice_mode_multiple: 'Multiple',
  choice_mode_single: 'Seul',
  choices: 'Choix',
  chosen: 'Choisi',
  clear_history: "Effacer l'historique",
  click_to_open: 'Cliquer pour ouvrir',
  close: 'Fermer',
  colon: ' : ',
  commands: 'Commandes',
  commands_help: "Les commandes systèmes suivantes seront exécutées quand l'hosts sera activé :",
  commands_title: "Commandes une fois qu'un hosts est activé",
  comment_current_line: 'Commenter cette ligne',
  content: 'Contenu',
  copy: 'Copier',
  cut: 'Couper',
  day: 'jour',
  days: 'jours',
  delete: 'Supprimer',
  download: 'Télécharger',
  edit: 'Éditer',
  export: 'Exporter',
  export_done: "L'export est terminé.",
  fail: 'Échec !',
  feedback: 'Laisser un commentaire',
  file: 'Fichier',
  find: 'Rechercher',
  find_all: 'Rechercher tout',
  find_and_replace: 'Rechercher et remplacer',
  find_history: 'Historique des recherches',
  folder: 'Dossier',
  front: 'Front',
  general: 'Général',
  group: 'Groupe',
  help: 'Aide',
  hide: 'Cacher',
  hide_at_launch: 'Cacher au lancement',
  hide_dock_icon: "Cacher l'icone dans le Dock",
  hide_history: "Cacher l'historique",
  hide_others: 'Cacher les autres',
  homepage: "Page d'accueil",
  host: 'Host',
  hosts_add: 'Ajouter un nouvel hosts',
  hosts_delete: 'Supprimer cet hosts',
  hosts_delete_confirm: 'Êtes-vous sûr de vouloir supprimer cet hosts?',
  hosts_edit: "Éditer l'hosts",
  hosts_title: "Titre de l'hosts",
  hosts_type: "Type d'hosts",
  hosts_updated: 'Le fichier hosts a été mis à jour',
  hour: 'heure',
  hours: 'heures',
  http_api_on: 'Activer HTTP API',
  http_api_on_desc:
    "Actif sur le port {0}, peut être utilisé par un logiciel tier comme Alfred pour changer d'hosts",
  http_api_only_local: "L'API HTTP n'écoute que sur 127.0.0.1",
  ignore_case: 'Ignorer la casse',
  import: 'Importer',
  import_done: "L'importation est terminée",
  import_fail: "Échec de l'importation !",
  import_from_url: "Importer à partir d'une URL",
  is_latest_version_inform: 'Super, vous avez la dernière version !',
  check_update_failed: 'La vérification des mises à jour a échoué !',
  item_found: '{0} élément trouvé.',
  items: 'éléments',
  items_found: '{0} éléments trouvés.',
  language: 'Langage',
  last_refresh: 'Dernier rafraîchissement : ',
  latest_version_desc: 'La dernière version est : {0}',
  line: 'ligne',
  lines: 'lignes',
  loading: 'Chargement...',
  local: 'Local',
  match: 'Correspondance',
  migrate_confirm:
    'SwitchHosts v4.0 utilise un nouveau format de stockage des données, voulez-vous migrer les anciennes données dans ce nouveau format ?',
  migrate_data: 'Migrer les données',
  minimize: 'Réduire',
  minute: 'minute',
  minutes: 'minutes',
  move_items_to_trashcan: 'Déplacer {0} éléments dans la corbeille',
  move_to_trashcan: 'Déplacer dans la corbeille',
  multi_chose_folder_switch_all:
    'Commutateur de dossier à sélection multiple pour contrôler les sous-éléments',
  need_to_relaunch: 'Besoin de redémarrer',
  need_to_relaunch_after_setting_changed:
    "Le paramètre a été modifié et prendra effet après le redémarrage de l'application.",
  never: 'Jamais',
  new: 'Nouveau',
  new_version_found: 'Nouvelle version trouvée',
  next: 'Suivant',
  no_access_to_hosts: 'Aucune autorisation pour écrire dans le fichier hosts.',
  no_record: 'Aucun enregistrement',
  overwrite: 'Écraser',
  password: 'Mot de passe',
  paste: 'Coller',
  port: 'Port',
  preferences: 'Préférences',
  previous: 'Précédent',
  protocol: 'Protocol',
  proxy: 'Proxy',
  quit: 'Quitter',
  read_only: 'Lecture seule',
  redo: 'Rétablir',
  refresh: 'Rafraîchir',
  regexp: 'Expression régulière',
  reload: 'Recharger',
  remote: 'Distant',
  remove_duplicate_records: 'Supprimer les enregistrements doublons',
  remove_duplicate_records_desc:
    'Si un domaine pointe sur plusieurs IPs, seulement la première sera prise en compte, et les autres seront converties en commentaires.',
  replace: 'Remplacer',
  replace_all: 'Tout remplacer',
  replace_history: "Remplacer l'historique",
  reset: 'Réinitialiser',
  reset_data_dir_confirm:
    "Êtes-vous sûr de vouloir réinitialiser le dossier de données à l'adresse par défaut?({0})?",
  reset_zoom: 'Réinitialiser le zoom',
  search: 'Rechercher',
  select_all: 'Tout sélectionner',
  selected: 'Sélectionné',
  show_dock_icon: "Afficher l'icone dans le Dock",
  show_history: "Afficher l'historique",
  show_main_window: 'Afficher la fenêtre principale',
  show_title_on_tray: 'Afficher le titre dans la barre des menus',
  source_code: 'Code source',
  success: 'Succès !',
  sudo_prompt_title: 'Entrez votre mot de passe sudo',
  system_hosts: 'Hosts du système',
  system_hosts_history: 'Historique des versions hosts du système',
  system_hosts_history_delete_confirm: 'Êtes-vous sûr de vouloir supprimer cet élément ?',
  system_hosts_history_help:
    "Si le nombre total d'enregistrements dépasse cette limite, l'enregistrement le plus ancien sera supprimé.",
  system_hosts_history_limit: "Nombre max. d'enregistrements : ",
  test: 'Test',
  theme: 'Thème',
  theme_dark: 'Sombre',
  theme_light: 'Clair',
  title: 'Titre',
  to_show_source: 'Double-cliquez pour afficher le code source',
  toggle_developer_tools: 'Afficher/Cacher le Developer Tools',
  toggle_dock_icon: "Afficher/Cacher l'icone dans le Dock",
  toggle_full_screen: 'Activer/Désactiver le plein écran',
  trashcan: 'Corbeille',
  trashcan_clear: 'Vider la corbeille',
  trashcan_clear_confirm: 'Êtes-vous sûr de vouloir vider la corbeille ?',
  trashcan_delete_confirm: 'Voulez-vous supprimer définitivement cet élément ?',
  trashcan_restore: 'Restaurer',
  tray_mini_window: "raccourci de l'icône de la barre des tâches",
  undo: 'Annuler',
  unhide: 'Démasquer',
  untitled: 'Sans titre',
  url_placeholder: 'http:// ou https:// ou file://',
  usage_data_agree: "Oui, soumettre de manière anonyme mes données d'utilisation",
  usage_data_help:
    "Voulez-vous nous aider à améliorer SwitchHosts en soumettant périodiquement vos données d'utilisation de manière anonyme ?",
  usage_data_title: 'Rendez SwitchHosts meilleur !',
  use_proxy: 'Utiliser un proxy',
  use_system_window_frame:
    "Utiliser le cadre de la fenêtre système, le redémarrage de l'application est requis",
  view: 'Vue',
  where_is_my_data: 'Où sont stockées mes données ?',
  where_is_my_hosts: 'Où est mon fichier hosts ?',
  window: 'Fenêtre',
  write_mode: "Mode d'écriture",
  write_mode_append_help:
    "Ajoutez les nouveaux enregistrements à la fin du fichier d'hôtes système.",
  write_mode_overwrite_help:
    "Écrasez le fichier d'hôtes système avec les nouveaux enregistrements.",
  write_mode_set: "Définir le mode d'écriture",
  your_data_is: 'Les fichiers contenant vos données sont stockés ici :',
  your_hosts_file_is: 'Votre fichier hosts est situé ici :',
  zoom: 'Zoom',
  zoom_in: 'Zoommer',
  zoom_out: 'Dézoommer',
}

export default lang
