# Spring Boot Projects

该仓库中主要是 Spring Boot 的入门学习教程以及一些常用的 Spring Boot 实战项目教程，包括 Spring Boot 使用的各种示例代码，同时也包括一些实战项目的项目源码和效果展示，实战项目包括基本的 Web 开发以及目前大家普遍使用的前后端分离实践项目等，后续会根据大家的反馈继续增加一些实战项目源码，摆脱各种 Hello World 入门案例的束缚，真正的掌握 Spring Boot 开发。

实战项目源码都已升级至 Spring Boot 3.x 版本，本仓库中的 Spring Boot 入门案例也已经升级至 Spring Boot 3.x 版本，Java 最低版本要求为 17，请知悉，想要学习和使用 Spring Boot 2.x 版本请自行切换分支。。

## 项目导航

[Spring Boot 入门小案例](./SpringBoot入门案例源码)&nbsp;|&nbsp;[Spring Boot 入门小案例](./SpringBoot入门案例源码)&nbsp;|&nbsp;[Spring Boot 整合案例系列2](./玩转SpringBoot系列案例源码)&nbsp;|&nbsp;[Spring Boot 前后端分离项目实践](./SpringBoot前后端分离实战项目源码)&nbsp;|&nbsp;[Spring Boot 咨询发布系统项目实践](./SpringBoot咨询发布系统实战项目源码) &nbsp;| &nbsp;[Spring Boot + Mybatis + Thymeleaf 实现的开源博客系统](https://github.com/ZHENFENG13/My-Blog)&nbsp;|&nbsp;[Spring Boot + Mybatis + Thymeleaf 实现的 BBS 论坛系统](https://github.com/ZHENFENG13/My-BBS)&nbsp;|&nbsp;[Spring Boot + Mybatis + Thymeleaf 仿知乎专栏项目](https://github.com/ZHENFENG13/My-Column)&nbsp;|&nbsp;[Spring Boot + layui 实现的后台管理系统](https://github.com/ZHENFENG13/My-Blog-layui) &nbsp;| &nbsp;[Spring Boot 大型商城项目实践](https://github.com/newbee-ltd/newbee-mall)&nbsp;| &nbsp;[Spring Boot + Vue 前后端分离商城项目](https://github.com/newbee-ltd/newbee-mall-vue-app)&nbsp;| &nbsp;[Spring Boot + Vue3 前后端分离商城项目](https://github.com/newbee-ltd/newbee-mall-vue3-app)&nbsp;| &nbsp;[Github地址](https://github.com/ZHENFENG13/spring-boot-projects) &nbsp;| &nbsp;[码云 Gitee 地址](https://gitee.com/zhenfeng13/spring-boot-projects)

---

#### 项目演示

- [Spring Boot 前后端分离项目预览](https://www.bilibili.com/video/av52551579)
- [Spring Boot 咨询发布系统项目预览](https://www.bilibili.com/video/av52551450)
- [Spring Boot 开源博客系统预览](https://www.bilibili.com/video/av52551095)
- [Spring Boot 商城项目总览](https://edu.csdn.net/course/play/26258/326466)
- [Spring Boot 商城系统介绍](https://edu.csdn.net/course/play/26258/326467)
- [Spring Boot 商城后台管理系统介绍](https://edu.csdn.net/course/play/26258/328801)

---

#### Spring Boot 实战项目源码

- [前后端分离项目](./SpringBoot前后端分离实战项目源码/spring-boot-project-front-end&back-end)
- [咨询发布项目](./SpringBoot咨询发布系统实战项目源码/springboot-project-news-publish-system)
- [博客系统](https://github.com/ZHENFENG13/My-Blog)
- [BBS 论坛系统](https://github.com/ZHENFENG13/My-BBS)
- [仿知乎专栏项目](https://github.com/ZHENFENG13/My-Column)
- [Spring Boot + layui 实现的后台管理系统](https://github.com/ZHENFENG13/My-Blog-layui)
- [Spring Boot 大型商城项目](https://github.com/newbee-ltd/newbee-mall)
- [Spring Boot + Vue 前后端分离商城项目](https://github.com/newbee-ltd/newbee-mall-vue-app)
- [Spring Boot + Vue3 前后端分离商城项目](https://github.com/newbee-ltd/newbee-mall-vue3-app)

---

## Spring Boot 基础使用案例

**示例代码**

- [spring-boot-hello](./SpringBoot入门案例源码/spring-boot-helloworld)：Spring Boot 第一个案例代码
- [spring-boot-logging](./玩转SpringBoot系列案例源码/spring-boot-logging)：Spring Boot 基础开发之日志输出案例
- [spring-boot-test](./玩转SpringBoot系列案例源码/spring-boot-test)：Spring Boot 基础开发之单元测试案例
- [spring-boot-static-resources](./SpringBoot入门案例源码/spring-boot-static-resources)：Spring Boot 基础开发之静态资源处理案例
- [spring-boot-ajax](./SpringBoot入门案例源码/spring-boot-ajax)：Spring Boot 项目实践之 Ajax 技术使用教程
- [spring-boot-message-converter](./玩转SpringBoot系列案例源码/spring-boot-message-converter)：Spring Boot 基础开发之消息转换器案例
- [spring-boot-jdbc](./SpringBoot入门案例源码/spring-boot-jdbc)：Spring Boot 连接数据库以及在 Spring Boot 项目中操作数据库
- [spring-boot-druid](./玩转SpringBoot系列案例源码/spring-boot-druid)：Spring Boot 中使用自定义 Druid 数据源案例
- [spring-boot-mybatis](./SpringBoot入门案例源码/spring-boot-mybatis)：Spring Boot 整合 MyBatis 操作数据库案例
- [spring-boot-transaction](./玩转SpringBoot系列案例源码/spring-boot-transaction)：Spring Boot 中的事务处理案例
- [spring-boot-redis](./玩转SpringBoot系列案例源码/spring-boot-redis)：Spring Boot 整合 Redis 操作缓存模块
- [spring-boot-schedule](./玩转SpringBoot系列案例源码/spring-boot-schedule)：Spring Boot 项目开发之@Scheduled实现定时任务案例
- [spring-boot-quartz](./玩转SpringBoot系列案例源码/spring-boot-quartz)：Spring Boot 项目开发之Quartz定时任务案例
- [spring-boot-error-page](./玩转SpringBoot系列案例源码/spring-boot-error-page)：Spring Boot 自定义错误页面案例
- [spring-boot-swagger](./玩转SpringBoot系列案例源码/spring-boot-swagger)：Spring Boot 集成 Swagger 生成接口文档案例
- [spring-boot-file-upload](./SpringBoot入门案例源码/spring-boot-file-upload)：Spring Boot 处理文件上传及路径回显
- [spring-boot-RESTful-api](./SpringBoot入门案例源码/spring-boot-RESTful-api) ：Spring Boot 项目实践之 RESTful API 设计与实现
- [spring-boot-web-jsp](./玩转SpringBoot系列案例源码/spring-boot-web-jsp) ：Spring Boot 整合 JSP 开发 web 项目
- [spring-boot-web-thymeleaf](./玩转SpringBoot系列案例源码/spring-boot-web-thymeleaf) ：Spring Boot 整合 Thymeleaf 案例
- [spring-boot-web-thymeleaf-syntax](./玩转SpringBoot系列案例源码/spring-boot-web-thymeleaf-syntax) ：Thymeleaf 语法详解
- [spring-boot-web-freemarker](./玩转SpringBoot系列案例源码/spring-boot-web-freemarker) ：Spring Boot 整合 FreeMarker 案例
- [spring-boot-admin](./玩转SpringBoot系列案例源码/spring-boot-admin) ：Spring Boot Admin 整合使用案例

这些案例主要是为了让大家能够掌握 Spring Boot 的开发和使用，旨在让读者更加熟悉 Spring Boot 及企业开发中需要注意的事项并具有使用 Spring Boot 技术进行大部分企业项目功能开发的能力。

关注公众号：**程序员十三**，回复"勾搭"进群交流。

![wx-gzh](https://newbee-mall.oss-cn-beijing.aliyuncs.com/wx-gzh/%E7%A8%8B%E5%BA%8F%E5%91%98%E5%8D%81%E4%B8%89-%E5%85%AC%E4%BC%97%E5%8F%B7.png)

---

## 开发文档

### 《SpringBoot + Mybatis + Thymeleaf 搭建美观实用的个人博客》

[![lesson-03](https://newbee-mall.oss-cn-beijing.aliyuncs.com/poster/store/lesson-03.png)](https://www.lanqiao.cn/courses/1367)

- [**第01课：Spring Boot 搭建简洁实用的个人博客系统导读**](https://www.lanqiao.cn/courses/1367)
- [第02课：快速构建 Spring Boot 应用](https://www.lanqiao.cn/courses/1367)
- [第03课：Spring Boot 项目开发之web项目开发讲解](https://www.lanqiao.cn/courses/1367)
- [第04课：Spring Boot 整合 Thymeleaf 模板引擎](https://www.lanqiao.cn/courses/1367)
- [第05课：Spring Boot 处理文件上传及路径回显](https://www.lanqiao.cn/courses)
- [第06课：Spring Boot 自动配置数据源及操作数据库](https://www.lanqiao.cn/courses/1367)
- [第07课：Spring Boot 整合 MyBatis 操作数据库](https://www.lanqiao.cn/courses/1367)
- [第08课：Mybatis-Generator 自动生成代码](https://www.lanqiao.cn/courses/1367)
- [第09课：Spring Boot 中的事务处理](https://www.lanqiao.cn/courses/1367)
- [第10课：Spring Boot 项目实践之 Ajax 技术使用教程](https://www.lanqiao.cn/courses/1367)
- [第11课：Spring Boot 项目实践之  RESTful API 设计与实现](https://www.lanqiao.cn/courses/1367)
- [第12课：Spring Boot 博客系统项目开发之分页功能实现](https://www.lanqiao.cn/courses/1367)
- [第13课：Spring Boot 博客系统项目开发之验证码功能](https://www.lanqiao.cn/courses/1367)
- [第14课：Spring Boot 博客系统项目开发之登录模块实现](https://www.lanqiao.cn/courses/1367)
- [第15课：Spring Boot 博客系统项目开发之登陆拦截器](https://www.lanqiao.cn/courses/1367)
- [第16课：Spring Boot 博客系统项目开发之分类功能实现](https://www.lanqiao.cn/courses/1367)
- [第17课：Spring Boot 博客系统项目开发之标签功能实现](https://www.lanqiao.cn/courses/1367)
- [第18课：Spring Boot 博客系统项目开发之文章编辑功能](https://www.lanqiao.cn/courses/1367)
- [第19课：Spring Boot 博客系统项目开发之文章编辑完善](https://www.lanqiao.cn/courses/1367)
- [第20课：Spring Boot 博客系统项目开发之文章模块实现](https://www.lanqiao.cn/courses/1367)
- [第21课：Spring Boot 博客系统项目开发之友链模块实现](https://www.lanqiao.cn/courses/1367)
- [第22课：Spring Boot 博客系统项目开发之网站首页制作](https://www.lanqiao.cn/courses/1367)
- [第23课：Spring Boot 博客系统项目开发之分页及侧边栏制作](https://www.lanqiao.cn/courses/1367)
- [第24课：Spring Boot 博客系统项目开发之搜索页面制作](https://www.lanqiao.cn/courses/1367)
- [第25课：Spring Boot 博客系统项目开发之文章详情页制作](https://www.lanqiao.cn/courses/1367)
- [第26课：Spring Boot 博客系统项目开发之错误页面制作](https://www.lanqiao.cn/courses/1367)
- [第27课：Spring Boot 博客系统项目开发之评论功能实现](https://www.lanqiao.cn/courses/1367)
- [第28课：Spring Boot 博客系统项目开发之项目打包部署](https://www.lanqiao.cn/courses/1367)

### 《SpringBoot + Mybatis + Thymeleaf 开发 BBS 论坛项目》

[![lesson-11](https://newbee-mall.oss-cn-beijing.aliyuncs.com/poster/store/lesson-11.png)](https://www.shiyanlou.com/courses/4830)

- [**第01课：Spring Boot 技术栈详解**](https://www.shiyanlou.com/courses/4830)
- [第02课：快速构建 Spring Boot 应用](https://www.shiyanlou.com/courses/4830)
- [第03课：Spring Boot 项目开发之Web项目开发讲解](https://www.shiyanlou.com/courses/4830)
- [第04课：Spring Boot 整合 Thymeleaf 模板引擎](https://www.shiyanlou.com/courses/4830)
- [第05课：Thymeleaf 语法详解](https://www.shiyanlou.com/courses/4830)
- [第06课：Spring Boot 自动配置数据源及操作数据库](https://www.shiyanlou.com/courses/4830)
- [第07课：Spring Boot 整合 MyBatis 操作数据库](https://www.shiyanlou.com/courses/4830)
- [第08课：分页功能的设计与实现](https://www.shiyanlou.com/courses/4830)
- [第09课：BBS论坛项目开发之验证码功能](https://www.shiyanlou.com/courses/4830)
- [第10课：BBS论坛项目开发之前端技术选型及源码目录详解](https://www.shiyanlou.com/courses/4830)
- [第11课：BBS论坛项目开发之用户注册模块实现](https://www.shiyanlou.com/courses/4830)
- [第12课：BBS论坛项目开发之用户登录模块实现](https://www.shiyanlou.com/courses/4830)
- [第13课：BBS论坛项目开发之用户登录拦截器](https://www.shiyanlou.com/courses/4830)
- [第14课：BBS论坛项目实战之处理文件上传及路径回显](https://www.shiyanlou.com/courses/4830)
- [第15课：BBS论坛项目实战之个人中心页面制作](https://www.shiyanlou.com/courses/4830)
- [第16课：富文本编辑器 wangEditor 整合](https://www.shiyanlou.com/courses/4830)
- [第17课：BBS论坛项目实战之论坛首页开发](https://www.shiyanlou.com/courses/4830)
- [第18课：BBS论坛项目实战之帖子发布功能开发](https://www.shiyanlou.com/courses/4830)
- [第19课：BBS论坛项目实战之帖子详情和修改功能开发](https://www.shiyanlou.com/courses/4830)
- [第20课：BBS论坛项目实战之评论功能开发](https://www.shiyanlou.com/courses/4830)

### 《Spring Boot 前后端分离项目实践》

[![lesson-01](https://newbee-mall.oss-cn-beijing.aliyuncs.com/poster/store/lesson-springboot3-01.png)](https://www.lanqiao.cn/courses/1244)

- [**开篇词：SpringBoot入门及前后端分离项目实践导读**](https://www.lanqiao.cn/courses/1244)
- [第02课：快速认识 Spring Boot 技术栈](https://www.lanqiao.cn/courses/1244)
- [第03课：开发环境搭建](https://www.lanqiao.cn/courses/1244)
- [第04课：快速构建 Spring Boot 应用](https://www.lanqiao.cn/courses/1244)
- [第05课：Spring Boot 之基础 web 功能开发](https://www.lanqiao.cn/courses)
- [第06课：Spring Boot 之数据库连接操作](https://www.lanqiao.cn/courses/1244)
- [第07课：Spring Boot 整合 MyBatis 操作数据库](https://www.lanqiao.cn/courses/1244)
- [第08课：Spring Boot 处理文件上传及路径回显](https://www.lanqiao.cn/courses/1244)
- [第09课：Spring Boot 项目实践之前后端分离详解](https://www.lanqiao.cn/courses/1244)
- [第10课：Spring Boot 项目实践之 Ajax 技术使用教程](https://www.lanqiao.cn/courses/1244)
- [第11课：Spring Boot 项目实践之  RESTful API 设计与实现](https://www.lanqiao.cn/courses/1244)
- [第12课：Spring Boot 项目实践之登录模块实现](https://www.lanqiao.cn/courses/1244)
- [第13课：Spring Boot 项目实践之分页功能实现](https://www.lanqiao.cn/courses/1244)
- [第14课：Spring Boot 项目实践之 jqgrid 分页整合](https://www.lanqiao.cn/courses/1244)
- [第15课：Spring Boot 项目实践之用户编辑功能实现](https://www.lanqiao.cn/courses/1244)
- [第16课：Spring Boot 项目实践之用户管理模块实现](https://www.lanqiao.cn/courses/1244)
- [第17课：Spring Boot 项目实践之图片管理模块](https://www.lanqiao.cn/courses/1244)
- [第18课：Spring Boot 项目实践之信息管理模块实现](https://www.lanqiao.cn/courses/1244)

### 《25 个实验带你轻松玩转 Spring Boot》

[![lesson-02](https://newbee-mall.oss-cn-beijing.aliyuncs.com/poster/store/lesson-springboot3-02.png)](https://www.lanqiao.cn/courses/1274)

- [**开篇词：《25 个实验带你轻松玩转 Spring Boot》导读**](https://www.lanqiao.cn/courses/1274)
- [第02课：Spring Boot 项目开发环境搭建](https://www.lanqiao.cn/courses/1274)
- [第03课：快速构建 Spring Boot 应用](https://www.lanqiao.cn/courses/1274)
- [第04课：Spring Boot 基础功能开发](https://www.lanqiao.cn/courses/1274)
- [第05课：Spring Boot 项目开发之 web 项目开发讲解](https://www.lanqiao.cn/courses/1274)
- [第06课：Spring Boot 整合 JSP 开发 web 项目](https://www.lanqiao.cn/courses/1274)
- [第07课：模板引擎介绍及 Spring Boot 整合 Thymeleaf](https://www.lanqiao.cn/courses/1274)
- [第08课：Thymeleaf 语法详解](https://www.lanqiao.cn/courses/1274)
- [第09课：FreeMarker 模板引擎整合使用教程](https://www.lanqiao.cn/courses/1274)
- [第10课：Spring Boot 处理文件上传及路径回显](https://www.lanqiao.cn/courses/1274)
- [第11课：Spring Boot 自动配置数据源及操作数据库](https://www.lanqiao.cn/courses/1274)
- [第12课：Spring Boot 整合 Druid 数据源](https://www.lanqiao.cn/courses/1274)
- [第13课：Spring Boot 整合 MyBatis 操作数据库](https://www.lanqiao.cn/courses/1274)
- [第14课：Spring Boot 中的事务处理](https://www.lanqiao.cn/courses/1274)
- [第15课：Spring Boot 整合 Redis 操作缓存模块](https://www.lanqiao.cn/courses/1274)
- [第16课：Spring Boot 项目开发之实现定时任务](https://www.lanqiao.cn/courses/1274)
- [第17课：Spring Boot 自定义错误页面](https://www.lanqiao.cn/courses/1274)
- [第18课：Spring Boot 集成 Swagger 生成接口文档](https://www.lanqiao.cn/courses/1274)
- [第19课：Spring Boot 项目打包部署介绍](https://www.lanqiao.cn/courses/1274)
- [第20课：Spring Boot Admin 介绍及整合使用](https://www.lanqiao.cn/courses/1274)
- [第21课：Spring Boot 资讯管理信息系统开发实战(一)](https://www.lanqiao.cn/courses/1274)
- [第22课：Spring Boot 资讯管理信息系统开发实战(二)](https://www.lanqiao.cn/courses/1274)
- [第23课：Spring Boot 资讯管理信息系统开发实战(三)](https://www.lanqiao.cn/courses/1274)
- [第24课：Spring Boot 资讯管理信息系统开发实战(四)](https://www.lanqiao.cn/courses/1274)

---

## 交流

> 大家有任何问题或者建议都可以在 [issues](https://github.com/ZHENFENG13/spring-boot-projects/issues) 中反馈给我，我会慢慢完善这个 Spring Boot 仓库。

- 我的邮箱：2449207463@qq.com
- QQ技术交流群：719099151 784785001
