/*
 * Decompiled with CFR 0.152.
 */
package progressed;

import arc.Core;
import arc.Events;
import arc.func.Func;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.mod.Mod;
import mindustry.mod.Mods;
import progressed.content.PMItems;
import progressed.content.PMLiquids;
import progressed.content.PMLoadouts;
import progressed.content.PMSounds;
import progressed.content.PMStatusEffects;
import progressed.content.PMTechTree;
import progressed.content.PMUnitTypes;
import progressed.content.blocks.PMBlocks;
import progressed.content.blocks.PMModules;
import progressed.content.bullets.PMBullets;
import progressed.gen.entities.EntityRegistry;
import progressed.graphics.PMPal;
import progressed.graphics.PMShaders;
import progressed.graphics.draw3d.Draw3D;
import progressed.graphics.draw3d.Perspective;
import progressed.graphics.renders.PMRenders;
import progressed.ui.PMHints;
import progressed.ui.PMStyles;
import progressed.ui.dialogs.ModuleSwapDialog;
import progressed.util.PMSettings;
import progressed.world.blocks.defence.turret.payload.modular.ModularTurret;

public class ProgMats
extends Mod {
    public static ModuleSwapDialog swapDialog;
    public static PMHints hints;

    public ProgMats() {
        Events.on(EventType.ClientLoadEvent.class, e -> {
            PMSettings.init();
            PMPal.init();
            hints.load();
        });
        Events.on(EventType.FileTreeInitEvent.class, e -> Core.app.post(() -> {
            if (!Vars.headless) {
                PMShaders.init();
                PMSounds.load();
            }
        }));
        if (!Vars.headless) {
            Events.on(EventType.ContentInitEvent.class, e -> Vars.content.blocks().each(b -> b instanceof ModularTurret, b -> b.setClip(PMModules.maxClip)));
            Core.settings.put("tu-disable-zoom", (Object)true);
        }
    }

    public void init() {
        if (!Vars.headless) {
            Mods.LoadedMod progM = Vars.mods.locateMod("prog-mats");
            Func getModBundle = value -> Core.bundle.get("mod." + progM.meta.name + "." + value);
            progM.meta.displayName = "[#4a6de5]" + progM.meta.displayName + "[]";
            progM.meta.description = (String)getModBundle.get((Object)"description");
            progM.meta.subtitle = (String)getModBundle.get((Object)"subtitle");
            StringBuilder contributors = new StringBuilder((String)getModBundle.get((Object)"author"));
            contributors.append("\n\n").append("[#4a6de5]Contributors:[]");
            int i = 0;
            while (Core.bundle.has("mod." + progM.meta.name + ".contributor-" + i)) {
                contributors.append("\n        ").append((String)getModBundle.get((Object)("contributor-" + i)));
                ++i;
            }
            progM.meta.author = contributors.toString();
            Events.on(EventType.ClientLoadEvent.class, e -> {
                PMStyles.load();
                swapDialog = new ModuleSwapDialog();
                PMRenders.init();
                Draw3D.init();
                if (ProgMats.farting()) {
                    PMSounds.overrideSounds();
                }
            });
            ProgMats.setupZoom();
        }
    }

    public void loadContent() {
        EntityRegistry.register();
        PMStatusEffects.load();
        PMLiquids.load();
        PMUnitTypes.load();
        PMItems.load();
        PMBullets.load();
        PMBlocks.load();
        PMTechTree.load();
        PMLoadouts.load();
    }

    public static boolean farting() {
        return Core.settings.getBool("pm-farting", false);
    }

    public static void updateZoomRange() {
        if (Vars.state.isGame()) {
            if (Vars.control.input.logicCutscene) {
                Vars.renderer.minZoom = 1.5f;
                Vars.renderer.maxZoom = 6.0f;
            } else {
                Vars.renderer.minZoom = 0.667f;
                Vars.renderer.maxZoom = Perspective.maxZoom();
            }
        }
    }

    private static void setupZoom() {
        Vars.renderer.minZoom = Math.min(Vars.renderer.minZoom, 0.667f);
        Vars.renderer.maxZoom = Perspective.maxZoom();
        Events.run((Object)EventType.Trigger.update, ProgMats::updateZoomRange);
    }

    static {
        hints = new PMHints();
    }
}

