/*
 * Decompiled with CFR 0.152.
 */
package progressed.ai;

import arc.math.Mathf;
import mindustry.ai.types.MissileAI;
import mindustry.gen.Building;
import mindustry.gen.Teamc;
import mindustry.gen.TimedKillc;
import mindustry.gen.Unit;
import progressed.type.unit.RocketUnitType;

public class DelayMissileAI
extends MissileAI {
    public void updateMovement() {
        float time;
        float f;
        this.unloadPayloads();
        Unit unit = this.unit;
        if (unit instanceof TimedKillc) {
            TimedKillc t = (TimedKillc)unit;
            f = t.time();
        } else {
            f = time = this.unit.type.homingDelay;
        }
        if (time >= this.unit.type.homingDelay && this.shooter != null) {
            this.unit.lookAt(this.shooter.aimX, this.shooter.aimY);
        }
        this.unit.moveAt(vec.trns(this.unit.rotation, this.unit.type.missileAccelTime <= 0.0f ? this.unit.speed() : Mathf.pow((float)Math.min(time / this.unit.type.missileAccelTime, 1.0f), (float)2.0f) * this.unit.speed()));
        if (time < this.unit.type.homingDelay) {
            return;
        }
        Building build = this.unit.buildOn();
        if (!(build == null || build.team == this.unit.team || build != this.target && build.block.underBullets)) {
            this.unit.kill();
        }
    }

    public boolean retarget() {
        TimedKillc t;
        Unit unit = this.unit;
        return !(unit instanceof TimedKillc && (t = (TimedKillc)unit).time() < ((RocketUnitType)this.unit.type).targetDelay || !super.retarget());
    }

    public Teamc target(float x, float y, float range, boolean air, boolean ground) {
        TimedKillc t;
        Unit unit = this.unit;
        if (unit instanceof TimedKillc && (t = (TimedKillc)unit).time() < ((RocketUnitType)this.unit.type).targetDelay) {
            return null;
        }
        return super.target(x, y, range, air, ground);
    }
}

