/*
 * Decompiled with CFR 0.152.
 */
package progressed.content;

import arc.audio.Sound;
import arc.files.Fi;
import mindustry.Vars;
import mindustry.gen.Sounds;
import mindustry.world.blocks.power.PowerGenerator;

public class PMSounds {
    public static Sound pixelShoot = new Sound();
    public static Sound pixelHit = new Sound();
    public static Sound rockExplode = new Sound();
    public static Sound nuclearExplosion = new Sound();
    public static Sound pulseBeam = new Sound();
    public static Sound funiBoom = new Sound();
    public static Sound gigaFard = new Sound();

    public static void load() {
        if (Vars.headless) {
            return;
        }
        pixelShoot = Vars.tree.loadSound("pixel-shoot");
        pixelHit = Vars.tree.loadSound("pixel-hit");
        rockExplode = Vars.tree.loadSound("rock-explode");
        nuclearExplosion = Vars.tree.loadSound("nuclear-explosion");
        pulseBeam = Vars.tree.loadSound("pulse-beam");
        funiBoom = Vars.tree.loadSound("funi-boom");
        gigaFard = Vars.tree.loadSound("giga-fard");
    }

    public static void overrideSounds() {
        if (Vars.headless) {
            return;
        }
        Vars.content.blocks().each(b -> {
            b.destroySound = Sounds.wind3;
        });
        Vars.content.blocks().each(b -> b instanceof PowerGenerator, b -> {
            b.explodeSound = funiBoom;
        });
        Vars.content.units().each(u -> {
            u.deathSound = Sounds.wind3;
        });
        Sounds.press.load(PMSounds.soundFile("press-boom"));
    }

    protected static String soundPath(String soundName) {
        String name = "sounds/" + soundName;
        return Vars.tree.get(name + ".ogg").exists() ? name + ".ogg" : name + ".mp3";
    }

    protected static Fi soundFile(String soundName) {
        return Vars.tree.get(PMSounds.soundPath(soundName));
    }
}

