/*
 * Decompiled with CFR 0.152.
 */
package progressed.content;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Mathf;
import arc.struct.Seq;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.content.StatusEffects;
import mindustry.gen.Unit;
import mindustry.graphics.Pal;
import mindustry.type.StatusEffect;
import progressed.content.effects.MissileFx;
import progressed.graphics.PMPal;
import progressed.type.statuseffects.ExclusiveStatusEffect;
import progressed.type.statuseffects.PMStatusEffect;

public class PMStatusEffects {
    public static StatusEffect incendiaryBurn;
    public static StatusEffect empStun;
    public static StatusEffect pinpointTarget;
    public static StatusEffect vcFrenzy;
    public static StatusEffect vcDisassembly;
    public static StatusEffect vcWeaken;
    public static StatusEffect vcCorvus;
    public static StatusEffect speedBoost;
    public static StatusEffect strengthBoost;

    public static void load() {
        incendiaryBurn = new PMStatusEffect("incend-burn"){
            {
                this.color = Pal.lightPyraFlame;
                this.damage = 3.6f;
                this.effect = MissileFx.incendBurning;
                this.transitionDamage = 14.0f;
                this.init(() -> {
                    this.opposite(new StatusEffect[]{StatusEffects.wet, StatusEffects.freezing});
                    this.affinity(StatusEffects.tarred, (unit, result, time) -> {
                        unit.damagePierce(this.transitionDamage);
                        Fx.burning.at(unit.x + Mathf.range((float)(unit.bounds() / 2.0f)), unit.y + Mathf.range((float)(unit.bounds() / 2.0f)));
                        result.set(incendiaryBurn, Math.min(time + result.time, 450.0f));
                    });
                });
            }
        };
        empStun = new PMStatusEffect("emp-stun"){
            {
                this.color = PMPal.nukeEmp;
                this.effect = MissileFx.hitEmpSpark;
                this.effectChance = 0.1f;
                this.speedMultiplier = 0.05f;
                this.reloadMultiplier = 0.05f;
                this.buildSpeedMultiplier = 0.05f;
                this.parentizeEffect = true;
            }
        };
        pinpointTarget = new PMStatusEffect("pinpoint-target"){
            {
                this.color = Pal.surge;
                this.healthMultiplier = 0.5f;
                this.speedMultiplier = 0.9f;
            }

            public void draw(Unit u) {
                float r = u.hitSize / 2.0f;
                float l = u.hitSize / 3.0f;
                Draw.z((float)110.0f);
                Lines.stroke((float)1.5f, (Color)this.color);
                Lines.circle((float)u.x, (float)u.y, (float)r);
                int points = 4;
                float offset = Mathf.randomSeed((long)u.id, (float)360.0f) - Time.time;
                r += Mathf.sin((float)4.774648f, (float)(l / 4.0f));
                for (int i = 0; i < points; ++i) {
                    float a = (float)i * 360.0f / (float)points + offset;
                    Lines.lineAngleCenter((float)(u.x + Angles.trnsx((float)a, (float)r)), (float)(u.y + Angles.trnsy((float)a, (float)r)), (float)a, (float)l);
                }
            }
        };
        vcFrenzy = new ExclusiveStatusEffect("frenzy"){
            {
                this.color = Color.valueOf((String)"E25656");
                this.damageMultiplier = 3.0f;
                this.speedMultiplier = 3.0f;
                this.reloadMultiplier = 3.0f;
                this.healthMultiplier = 0.25f;
            }
        };
        vcDisassembly = new ExclusiveStatusEffect("disassembly"){
            {
                this.color = Color.darkGray;
                this.reloadMultiplier = 0.6f;
                this.speedMultiplier = 0.7f;
                this.healthMultiplier = 0.6f;
                this.damage = 1.0f;
            }
        };
        vcWeaken = new ExclusiveStatusEffect("weaken"){
            {
                this.color = Pal.sapBulletBack;
                this.healthMultiplier = 0.7f;
                this.damageMultiplier = 0.5f;
            }
        };
        vcCorvus = new ExclusiveStatusEffect("corvus-19"){
            {
                this.color = Pal.heal;
                this.speedMultiplier = 0.8f;
                this.reloadMultiplier = 0.8f;
                this.damage = 8.0f;
                this.hideDetails = false;
            }
        };
        speedBoost = new PMStatusEffect("speed-boost"){
            {
                this.color = Pal.lancerLaser;
                this.speedMultiplier = 1.25f;
                this.reloadMultiplier = 1.25f;
                this.effect = Fx.overclocked;
            }
        };
        strengthBoost = new PMStatusEffect("strength-boost"){
            {
                this.color = Pal.redderDust;
                this.damageMultiplier = 1.25f;
                this.effect = Fx.overclocked;
            }
        };
        PMStatusEffects.afterLoad();
    }

    public static void afterLoad() {
        ((ExclusiveStatusEffect)PMStatusEffects.vcFrenzy).exclusives = Seq.with((Object[])new StatusEffect[]{vcDisassembly, vcWeaken, vcCorvus});
        ((ExclusiveStatusEffect)PMStatusEffects.vcDisassembly).exclusives = Seq.with((Object[])new StatusEffect[]{vcFrenzy, vcWeaken, vcCorvus});
        ((ExclusiveStatusEffect)PMStatusEffects.vcWeaken).exclusives = Seq.with((Object[])new StatusEffect[]{vcFrenzy, vcDisassembly, vcCorvus});
        ((ExclusiveStatusEffect)PMStatusEffects.vcCorvus).exclusives = Seq.with((Object[])new StatusEffect[]{vcFrenzy, vcDisassembly, vcWeaken});
    }
}

