/*
 * Decompiled with CFR 0.152.
 */
package progressed.content;

import arc.graphics.Color;
import arc.math.geom.Geometry;
import arc.struct.Seq;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.entities.abilities.RegenAbility;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.ExplosionBulletType;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.Item;
import mindustry.type.UnitType;
import mindustry.type.Weapon;
import mindustry.type.unit.ErekirUnitType;
import mindustry.type.unit.MissileUnitType;
import progressed.ai.DepotMinerAI;
import progressed.content.effects.MissileFx;
import progressed.content.effects.OtherFx;
import progressed.gen.entities.EntityRegistry;
import progressed.gen.entities.NoCoreDepositBuildingTetherLegsUnit;
import progressed.gen.entities.SentryUnit;
import progressed.gen.entities.SignalFlareUnit;
import progressed.gen.entities.SwordUnit;
import progressed.type.unit.SentryUnitType;
import progressed.type.unit.SignalFlareUnitType;
import progressed.type.unit.SwordUnitType;
import progressed.type.weapons.RocketWeapon;

public class PMUnitTypes {
    public static UnitType echo;
    public static UnitType presence;
    public static UnitType ghoul;
    public static UnitType phantom;
    public static UnitType apparition;
    public static UnitType puncture;
    public static UnitType penetration;
    public static UnitType incision;
    public static UnitType laceration;
    public static UnitType amputation;
    public static UnitType barrage;
    public static UnitType strikedown;
    public static UnitType draug;
    public static UnitType flareSmall;
    public static UnitType flareMedium;
    public static UnitType flareLarge;
    public static UnitType danceSword;
    public static UnitType masqueradeSword;

    public static void load() {
        barrage = (UnitType)EntityRegistry.content("barrage", SentryUnit.class, name -> new SentryUnitType((String)name){
            {
                this.lifetime = 2340.0f;
                Weapon gunL = new Weapon(this.name + "-gun-r"){
                    {
                        super(name);
                        this.top = false;
                        this.rotate = false;
                        this.mirror = false;
                        this.alternate = true;
                        this.otherSide = 1;
                        this.x = 2.375f;
                        this.y = 5.5f;
                        this.shootX = -0.25f;
                        this.shootY = 1.5f;
                        this.reload = 6.0f;
                        this.recoil = 0.75f;
                        this.ejectEffect = Fx.casing1;
                        this.bullet = new BasicBulletType(3.0f, 23.0f){
                            {
                                super(speed, damage);
                                this.lifetime = 80.0f;
                                this.buildingDamageMultiplier = 0.3f;
                                this.width = 7.0f;
                                this.height = 9.0f;
                                this.recoil = 0.1f;
                                this.homingPower = 0.03f;
                                this.homingRange = 120.0f;
                            }
                        };
                    }
                };
                Weapon gunR = gunL.copy();
                gunR.name = this.name + "-gun-l";
                gunR.x *= -1.0f;
                gunR.shootX *= -1.0f;
                gunR.flipSprite = true;
                gunR.otherSide = 0;
                this.weapons.add((Object)gunL, (Object)gunR);
                for (int i = 0; i < 4; ++i) {
                    this.engines.add((Object)new SentryUnitType.AnchorEngine(3.0f * (float)Geometry.d8edge((int)i).x, 3.0f * (float)Geometry.d8edge((int)i).y, 1.25f, (float)i * 90.0f + 45.0f));
                }
            }
        });
        strikedown = (UnitType)EntityRegistry.content("downpour", SentryUnit.class, name -> new SentryUnitType((String)name){
            {
                this.lifetime = 1920.0f;
                this.maxRange = 320.0f;
                this.range = 320.0f;
                this.weapons.add((Object)new RocketWeapon(this.name + "-rocket"){
                    {
                        super(name);
                        this.x = 0.0f;
                        this.shootY = 0.0f;
                        this.mirror = false;
                        this.rotate = false;
                        this.reload = 120.0f;
                        this.shootCone = 5.0f;
                        this.shootSound = Sounds.missileSmall;
                        this.layerOffset = -0.005f;
                        this.bullet = new BulletType(0.0f, 0.0f){
                            {
                                super(speed, damage);
                                this.shootEffect = Fx.none;
                                this.smokeEffect = MissileFx.shootSmokeDownpour;
                                this.hitColor = Pal.sap;
                                this.recoil = 1.0f;
                                this.spawnUnit = new MissileUnitType("downpour-rocket"){
                                    {
                                        super(name);
                                        this.speed = 6.4f;
                                        this.maxRange = 9.0f;
                                        this.lifetime = 72.0f;
                                        this.missileAccelTime = 30.0f;
                                        this.outlineColor = Pal.darkOutline;
                                        this.engineColor = this.trailColor = Pal.sapBulletBack;
                                        this.engineLayer = 110.0f;
                                        this.engineOffset = 10.0f;
                                        this.engineSize = 1.5f;
                                        this.health = 45.0f;
                                        this.loopSoundVolume = 0.1f;
                                        this.weapons.add((Object)new Weapon(){
                                            {
                                                this.shootCone = 360.0f;
                                                this.mirror = false;
                                                this.reload = 1.0f;
                                                this.shootOnDeath = true;
                                                this.bullet = new ExplosionBulletType(260.0f, 21.0f){
                                                    {
                                                        super(splashDamage, splashDamageRadius);
                                                        this.shootEffect = Fx.massiveExplosion;
                                                        this.buildingDamageMultiplier = 0.3f;
                                                    }
                                                };
                                            }
                                        });
                                    }
                                };
                            }
                        };
                    }
                });
                for (int i = 0; i < 4; ++i) {
                    this.engines.add((Object)new SentryUnitType.AnchorEngine(3.0f * (float)Geometry.d8edge((int)i).x, 3.0f * (float)Geometry.d8edge((int)i).y, 1.25f, (float)i * 90.0f + 45.0f));
                }
            }
        });
        draug = (UnitType)EntityRegistry.content("draug", NoCoreDepositBuildingTetherLegsUnit.class, name -> new ErekirUnitType((String)name){
            {
                this.controller = u -> new DepotMinerAI();
                this.isEnemy = false;
                this.allowedInPayloads = false;
                this.logicControllable = false;
                this.playerControllable = false;
                this.hidden = true;
                this.hideDetails = false;
                this.hitSize = 14.0f;
                this.speed = 1.0f;
                this.rotateSpeed = 2.5f;
                this.health = 1300.0f;
                this.armor = 5.0f;
                this.omniMovement = false;
                this.rotateMoveFirst = true;
                this.itemOffsetY = 5.0f;
                this.itemCapacity = 50;
                this.mineTier = 5;
                this.mineSpeed = 6.0f;
                this.mineWalls = true;
                this.mineItems = Seq.with((Object[])new Item[]{Items.beryllium, Items.graphite, Items.tungsten});
                this.allowLegStep = true;
                this.legCount = 6;
                this.legGroupSize = 3;
                this.legLength = 12.0f;
                this.lockLegBase = true;
                this.legContinuousMove = true;
                this.legExtension = -3.0f;
                this.legBaseOffset = 5.0f;
                this.legMaxLength = 1.1f;
                this.legMinLength = 0.2f;
                this.legForwardScl = 1.0f;
                this.legMoveSpace = 2.5f;
                this.hovering = true;
                this.weapons.add((Object)new Weapon("prog-mats-draug-you-have-incurred-my-wrath-prepare-to-die"){
                    {
                        super(name);
                        this.x = 5.5f;
                        this.y = -3.0f;
                        this.shootX = -0.75f;
                        this.shootY = 1.125f;
                        this.rotate = true;
                        this.rotateSpeed = 35.0f;
                        this.reload = 35.0f;
                        this.shootSound = Sounds.laser;
                        this.bullet = new LaserBulletType(){
                            {
                                this.damage = 45.0f;
                                this.sideAngle = 30.0f;
                                this.sideWidth = 1.0f;
                                this.sideLength = 42.0f;
                                this.length = 110.0f;
                                this.colors = new Color[]{Pal.heal.cpy().a(0.4f), Pal.heal, Color.white};
                            }
                        };
                    }
                });
                this.abilities.add((Object)new RegenAbility(){
                    {
                        this.percentAmount = 0.018518519f;
                    }
                });
            }
        });
        flareSmall = (UnitType)EntityRegistry.content("small-flare", SignalFlareUnit.class, name -> new SignalFlareUnitType((String)name){
            {
                this.health = 400.0f;
                this.hideDetails = false;
                this.attraction = 800.0f;
                this.flareY = 7.25f;
            }
        });
        flareMedium = (UnitType)EntityRegistry.content("medium-flare", SignalFlareUnit.class, name -> new SignalFlareUnitType((String)name, 480.0f){
            {
                this.health = 1500.0f;
                this.hideDetails = false;
                this.attraction = 11000.0f;
                this.flareY = 11.25f;
                this.flareEffectSize = 1.5f;
            }
        });
        flareLarge = (UnitType)EntityRegistry.content("large-flare", SignalFlareUnit.class, name -> new SignalFlareUnitType((String)name, 900.0f){
            {
                this.health = 6000.0f;
                this.hideDetails = false;
                this.attraction = 26000.0f;
                this.flareY = 15.25f;
                this.flareEffectSize = 2.0f;
            }
        });
        danceSword = (UnitType)EntityRegistry.content("dance-sword", SwordUnit.class, name -> new SwordUnitType((String)name){
            {
                this.baseY = -4.0f;
                this.tipY = 11.0f;
                this.damage = 65.0f;
                this.hitEffect = OtherFx.swordStab;
                this.trailLength = 5;
            }
        });
        masqueradeSword = (UnitType)EntityRegistry.content("ball-sword", SwordUnit.class, name -> new SwordUnitType((String)name){
            {
                this.baseY = -8.25f;
                this.tipY = 22.25f;
                this.damage = 90.0f;
                this.hitEffect = OtherFx.swordStab;
                this.trailLength = 8;
                this.trailScl = 4.0f;
                this.trailVel = 8.0f;
            }
        });
    }
}

