/*
 * Decompiled with CFR 0.152.
 */
package progressed.content.blocks;

import arc.graphics.Blending;
import arc.graphics.Color;
import arc.math.Interp;
import arc.math.Mathf;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.entities.UnitSorts;
import mindustry.entities.part.DrawPart;
import mindustry.entities.part.RegionPart;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.blocks.defense.turrets.PowerTurret;
import mindustry.world.blocks.production.HeatCrafter;
import mindustry.world.draw.DrawBlock;
import mindustry.world.draw.DrawBlurSpin;
import mindustry.world.draw.DrawDefault;
import mindustry.world.draw.DrawGlowRegion;
import mindustry.world.draw.DrawHeatInput;
import mindustry.world.draw.DrawLiquidTile;
import mindustry.world.draw.DrawMulti;
import mindustry.world.draw.DrawRegion;
import mindustry.world.draw.DrawTurret;
import progressed.content.PMItems;
import progressed.content.blocks.PMBlocks;
import progressed.content.blocks.PMPayloads;
import progressed.content.bullets.PMBullets;
import progressed.content.bullets.PayloadBullets;
import progressed.content.effects.CrafterFx;
import progressed.entities.part.AimLaserPart;
import progressed.entities.part.LaunchPart;
import progressed.world.blocks.defence.turret.payload.SinglePayloadAmmoTurret;
import progressed.world.blocks.defence.turret.payload.modular.ModularTurret;
import progressed.world.blocks.payloads.PayloadCrafter;
import progressed.world.draw.DrawPayloadAmmo;
import progressed.world.draw.DrawPayloadTurret;
import progressed.world.module.ModuleModule;

public class PMErekirBlocks {
    public static Block sentinel;
    public static Block sergeant;
    public static Block matrix;
    public static Block teneliumFuser;
    public static Block moduleAssembler;
    public static Block moduleFoundry;
    public static Block sentryBuilder;

    public static void load() {
        sentinel = new PowerTurret("sentinel"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.silicon, 450, Items.graphite, 300, Items.tungsten, 350, Items.surgeAlloy, 150, PMItems.tenelium, 200}));
                final float aimLength = 48.0f;
                this.clipSize = aimLength * 2.0f;
                this.drawer = new DrawTurret("reinforced-"){
                    {
                        super(basePrefix);
                        this.parts.add((Object)new RegionPart("-blade"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.heatColor = Pal.techBlue;
                                this.mirror = true;
                                this.under = true;
                                this.moveX = 4.75f;
                                this.children.add((Object)new RegionPart("-blade-glow"){
                                    {
                                        super(region);
                                        this.heatProgress = DrawPart.PartProgress.warmup.add(-0.2f).add(p -> Mathf.sin((float)9.0f, (float)0.2f) * p.warmup);
                                        this.heatColor = Pal.techBlue;
                                        this.drawRegion = false;
                                    }
                                });
                            }
                        }, (Object)new RegionPart("-glow"){
                            {
                                super(region);
                                this.heatProgress = DrawPart.PartProgress.warmup;
                                this.heatColor = Pal.techBlue;
                                this.drawRegion = false;
                                this.mirror = false;
                            }
                        }, (Object)new AimLaserPart(){
                            {
                                this.alpha = DrawPart.PartProgress.warmup.mul(0.5f).add(0.5f);
                                this.blending = Blending.additive;
                                this.length = aimLength;
                                this.y = -4.0f;
                            }
                        }, (Object)new RegionPart("-top"){
                            {
                                super(region);
                                this.progress = DrawPart.PartProgress.warmup;
                                this.moves.add((Object)new DrawPart.PartMove(DrawPart.PartProgress.warmup.curve(Interp.smooth), 0.0f, -4.0f, 0.0f));
                                this.heatColor = Pal.techBlue;
                                this.mirror = true;
                                this.moveX = 3.25f;
                                this.children.add((Object)new RegionPart("-top-glow"){
                                    {
                                        super(region);
                                        this.heatProgress = DrawPart.PartProgress.warmup.add(-0.2f).add(p -> Mathf.sin((float)9.0f, (float)0.2f) * p.warmup);
                                        this.heatColor = Pal.techBlue;
                                        this.drawRegion = false;
                                    }
                                });
                            }
                        });
                    }
                };
                this.heatColor = Pal.techBlue;
                this.cooldownTime = 75.0f;
                this.size = 4;
                this.scaledHealth = 210.0f;
                this.shootY = 1.5f;
                this.range = 328.0f;
                this.reload = 120.0f;
                this.recoil = 3.0f;
                this.outlineColor = Pal.darkOutline;
                this.linearWarmup = true;
                this.shootWarmupSpeed = 0.03f;
                this.minWarmup = 1.0f;
                this.warmupMaintainTime = 30.0f;
                this.shootSound = Sounds.pulseBlast;
                this.rotateSpeed = 1.5f;
                this.shootType = PMBullets.sentinelLaser;
                this.unitSort = UnitSorts.strongest;
                this.limitRange(12.0f);
                this.consumePower(13.666667f);
                this.consumeLiquid(Liquids.cyanogen, 0.13333334f);
                this.coolant = this.consumeLiquid(Liquids.water, 0.6666667f);
                this.coolantMultiplier = 0.75f;
            }
        };
        sergeant = new SinglePayloadAmmoTurret("sergeant"){
            {
                this.requirements(Category.turret, ItemStack.with((Object[])new Object[]{Items.beryllium, 300, Items.tungsten, 150, Items.silicon, 300, Items.surgeAlloy, 50}));
                this.ammo(new Object[]{PMPayloads.basicSentry, PayloadBullets.barrageLaunch, PMPayloads.missileSentry, PayloadBullets.strikedownLaunch});
                this.size = 3;
                this.reload = 300.0f;
                this.hideDetails = false;
                this.scaledHealth = 140.0f;
                this.minRange = 40.0f;
                this.range = 320.0f;
                this.velocityRnd = 0.2f;
                this.cooldownTime = 30.0f;
                this.recoil = 6.0f;
                this.recoilTime = 60.0f;
                this.shake = 2.0f;
                this.shootY = -1.0f;
                this.shootSound = Sounds.artillery;
                this.setWarmupTime(0.75f);
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawPayloadTurret(true, "reinforced-"){
                    {
                        super(drawTurret, basePrefix);
                        this.parts.add((Object)new LaunchPart(){
                            {
                                this.progress = DrawPart.PartProgress.warmup.shorten(0.125f);
                                this.start = (float)(size * 8) / 2.0f + 1.5f;
                                this.length = (float)(size * 8) / 2.0f * 1.5f;
                                this.spacing = (float)(size * 8) / 4.0f;
                                clipSize = Math.max(clipSize, (float)(size * 8) + (this.length + this.start) * 2.0f);
                            }
                        });
                    }
                }, new DrawPayloadAmmo(){
                    {
                        this.matProgress = DrawPart.PartProgress.reload.inv().shorten(0.125f);
                        this.y = shootY;
                    }
                }});
                this.outlineColor = Pal.darkOutline;
                this.coolant = this.consumeLiquid(Liquids.water, 0.4f);
            }
        };
        matrix = new ModularTurret("matrix"){
            {
                this.requirements(Category.turret, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.size = 7;
                this.scaledHealth = 370.0f;
                this.regionSuffix = "-dark";
                this.squareSprite = false;
                this.hideDetails = false;
                this.moduleGroups = new ModularTurret.ModuleGroup[]{new ModularTurret.ModuleGroup(ModuleModule.ModuleSize.small, ModularTurret.ModuleGroup.ModuleGroupType.oct, 18.25f, 12.0f), new ModularTurret.ModuleGroup(ModuleModule.ModuleSize.medium, ModularTurret.ModuleGroup.ModuleGroupType.quad, 0.0f, 18.25f), new ModularTurret.ModuleGroup(ModuleModule.ModuleSize.large)};
            }
        };
        teneliumFuser = new HeatCrafter("tenelium-fuser"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{Items.silicon, 120, Items.graphite, 60, Items.tungsten, 100, Items.oxide, 40, Items.surgeAlloy, 60}));
                this.size = 3;
                this.itemCapacity = 20;
                this.heatRequirement = 20.0f;
                this.craftTime = 120.0f;
                this.liquidCapacity = 300.0f;
                this.hasLiquids = true;
                this.outputItem = new ItemStack(PMItems.tenelium, 1);
                this.craftEffect = CrafterFx.teneliumFuse;
                this.drawer = new DrawMulti(new DrawBlock[]{new DrawRegion("-bottom"), new DrawLiquidTile(Liquids.slag, 3.0f), new DrawDefault(), new DrawHeatInput(), new DrawGlowRegion("-glow"){
                    {
                        super(suffix);
                        this.color = Color.valueOf((String)"70170b");
                    }
                }, new DrawBlurSpin("-rotator", 12.0f)});
                this.consumeItem(Items.thorium, 1);
                this.consumeLiquid(Liquids.slag, 0.5f);
            }
        };
        sentryBuilder = new PayloadCrafter("sentry-builder"){
            {
                this.requirements(Category.crafting, ItemStack.with((Object[])new Object[]{Items.beryllium, 100, Items.graphite, 90, Items.tungsten, 50, Items.surgeAlloy, 30, Items.silicon, 150}));
                this.size = 3;
                this.regionSuffix = "-dark";
                this.recipes(PMPayloads.basicSentry, PMPayloads.missileSentry);
                this.recipes.each(r -> {
                    r.blockBuild = false;
                });
                this.setRecipeProductionStats();
            }
        };
    }
}

