/*
 * Decompiled with CFR 0.152.
 */
package progressed.content.blocks;

import arc.graphics.Color;
import mindustry.ai.types.MissileAI;
import mindustry.content.Fx;
import mindustry.content.Items;
import mindustry.content.Liquids;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.bullet.PointLaserBulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.part.RegionPart;
import mindustry.entities.pattern.ShootBarrel;
import mindustry.entities.pattern.ShootSpread;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import mindustry.type.Category;
import mindustry.type.ItemStack;
import mindustry.world.Block;
import mindustry.world.consumers.Consume;
import mindustry.world.consumers.ConsumeLiquid;
import mindustry.world.consumers.ConsumeLiquidBase;
import progressed.content.blocks.PMBlocks;
import progressed.content.bullets.ModuleBullets;
import progressed.content.effects.ModuleFx;
import progressed.entities.bullet.energy.AbyssBulletType;
import progressed.entities.bullet.energy.BeamBulletType;
import progressed.entities.bullet.physical.AntiMissileRailBulletType;
import progressed.entities.pattern.EnhancedShootHelix;
import progressed.world.blocks.defence.turret.payload.modular.modules.ArcModule;
import progressed.world.blocks.defence.turret.payload.modular.modules.BeamModule;
import progressed.world.blocks.defence.turret.payload.modular.modules.BoostModule;
import progressed.world.blocks.defence.turret.payload.modular.modules.ItemTurretModule;
import progressed.world.blocks.defence.turret.payload.modular.modules.PowerTurretModule;
import progressed.world.blocks.defence.turret.payload.modular.modules.SweepLaserTurretModule;
import progressed.world.blocks.defence.turret.payload.modular.modules.TractorConeModule;
import progressed.world.draw.DrawTurretModule;
import progressed.world.module.ModuleModule;

public class PMModules {
    public static float maxClip = 0.0f;
    public static Block coil;
    public static Block skeet;
    public static Block burst;
    public static Block accentuate;
    public static Block augment;
    public static Block abyss;
    public static Block halberd;
    public static Block gravity;
    public static Block firestorm;
    public static Block wasteland;
    public static Block judgement;

    public static void load() {
        coil = new ItemTurretModule("coil"){
            {
                this.requirements(Category.units, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.outlineColor = Pal.darkOutline;
                MultiEffect sfe = new MultiEffect(new Effect[]{Fx.shootSmallColor, Fx.colorSpark});
                this.ammo(new Object[]{Items.beryllium, new BasicBulletType(2.0f, 16.0f, (Effect)sfe){
                    final /* synthetic */ Effect val$sfe;
                    {
                        this.val$sfe = effect;
                        super(speed, damage);
                        this.lifetime = 80.0f;
                        this.width = 3.0f;
                        this.hitSize = 3.0f;
                        this.height = 5.0f;
                        this.shootEffect = this.val$sfe;
                        this.smokeEffect = Fx.shootSmallSmoke;
                        this.ammoMultiplier = 1.0f;
                        this.pierceCap = 2;
                        this.pierce = true;
                        this.pierceBuilding = true;
                        this.backColor = this.trailColor = Pal.berylShot;
                        this.hitColor = this.trailColor;
                        this.frontColor = Color.white;
                        this.trailWidth = 0.75f;
                        this.trailLength = 10;
                        this.hitEffect = this.despawnEffect = Fx.hitBulletColor;
                        this.buildingDamageMultiplier = 0.3f;
                    }
                }});
                this.shootSound = Sounds.shootAlt;
                this.targetUnderBlocks = false;
                this.reload = 40.0f;
                this.range = 144.0f;
                this.shoot = new EnhancedShootHelix(5.0f, 0.4f){
                    {
                        super(scl, mag);
                        this.shots = 4;
                        this.offset *= 0.7853982f;
                    }
                };
                this.coolantMultiplier = 5.0f;
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(Liquids.water, 0.083333336f));
                this.limitRange();
            }
        };
        skeet = new ItemTurretModule("skeet"){
            {
                this.requirements(Category.units, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.outlineColor = Pal.darkOutline;
                final float brange = 140.0f;
                this.ammo(new Object[]{Items.tungsten, new AntiMissileRailBulletType(){
                    {
                        this.length = brange;
                        this.damage = 45.0f;
                        this.ammoMultiplier = 3.0f;
                        this.hitColor = Color.valueOf((String)"feb380");
                        this.hitEffect = Fx.hitBulletColor;
                        this.pierceDamageFactor = 0.5f;
                        this.shootEffect = ModuleFx.skeetShoot;
                        this.smokeEffect = Fx.colorSpark;
                        this.lineEffect = ModuleFx.skeetLine;
                        this.endEffect = ModuleFx.skeetEnd;
                    }
                }});
                this.range = brange;
                this.reload = 45.0f;
                this.targetInterval = 10.0f;
                this.rotateSpeed = 20.0f;
                this.shootCone = 1.0f;
                this.playerControllable = false;
                this.targetGround = false;
                this.unitFilter = u -> u.controller() instanceof MissileAI;
                this.coolantMultiplier = 5.0f;
                this.coolant = (ConsumeLiquidBase)this.consume((Consume)new ConsumeLiquid(Liquids.water, 0.083333336f));
            }
        };
        burst = new PowerTurretModule("burst"){
            {
                this.requirements(Category.units, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.outlineColor = Pal.darkOutline;
                this.shootType = new BulletType(4.5f, 4.0f){
                    {
                        super(speed, damage);
                        this.hitSize = 7.0f;
                        this.lifetime = 24.0f;
                        this.pierce = true;
                        this.impact = true;
                        this.knockback = 5.0f;
                        this.hitColor = Color.white;
                        this.hitEffect = ModuleFx.hitSteam;
                        this.despawnEffect = Fx.none;
                        this.hittable = false;
                    }
                };
                this.reload = 75.0f;
                this.range = 108.0f;
                this.shootEffect = ModuleFx.steamBurst;
                this.shootSound = Sounds.flame;
                this.shootCone = 60.0f;
                this.shoot = new ShootSpread(12, 3.0f);
                this.consumePower(2.0f);
                this.consumeLiquid(Liquids.water, 0.2f);
                this.limitRange(2.0f);
            }
        };
        accentuate = new SweepLaserTurretModule("accentuate"){
            {
                this.requirements(Category.units, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.outlineColor = Pal.darkOutline;
                this.shootType = new PointLaserBulletType(){
                    {
                        this.damageInterval = 2.0f;
                        this.damage = 25.0f * this.damageInterval;
                        this.beamEffect = Fx.none;
                        this.color = this.trailColor = Pal.remove;
                        this.shake = 0.0f;
                        this.trailLength = 24;
                    }
                };
                this.reload = 180.0f;
                this.range = 112.0f;
                this.sweepDuration = 120.0f;
                this.consumePower(0.75f);
            }
        };
        augment = new BoostModule("augment"){
            {
                this.requirements(Category.units, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.outlineColor = Pal.darkOutline;
                this.hasPower = true;
                this.healPercent = 0.027777778f;
                this.consumePower(1.0f);
                this.consumeLiquid(Liquids.hydrogen, 0.016666668f);
            }
        };
        abyss = new PowerTurretModule("abyss"){
            {
                float brange;
                this.requirements(Category.units, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.moduleSize = ModuleModule.ModuleSize.medium;
                this.size = 2;
                this.outlineColor = Pal.darkOutline;
                this.range = brange = 116.0f;
                this.shootType = new AbyssBulletType(){
                    {
                        this.splashDamage = 280.0f;
                        this.splashDamageRadius = 20.0f;
                        this.pierceArmor = true;
                        this.buildingDamageMultiplier = 0.3f;
                        this.lifetime = ModuleFx.abyssGrow.lifetime;
                        this.swirlEffects = 10;
                        this.maxSwirlDelay = this.lifetime - ModuleFx.abyssSwirl.lifetime;
                        this.length = brange;
                        this.beamEffect = ModuleFx.abyssBeam;
                        this.swirlEffect = ModuleFx.abyssSwirl;
                        this.growEffect = ModuleFx.abyssGrow;
                        this.despawnEffect = ModuleFx.abyssBurst;
                        this.displayAmmoMultiplier = false;
                    }
                };
                this.drawer = new DrawTurretModule(){
                    {
                        this.parts.add((Object)new RegionPart("-shell"){
                            {
                                super(region);
                                this.x = 0.75f;
                                this.y = -2.5f;
                                this.moveX = 0.9f;
                                this.moveY = -0.5f;
                                this.moveRot = -6.5f;
                                this.mirror = true;
                            }
                        });
                    }
                };
                this.reload = 150.0f;
                this.shootSound = Sounds.bolt;
                this.linearWarmup = true;
                this.minWarmup = 1.0f;
                this.shootWarmupSpeed = 0.025f;
                this.shootY = -0.5f;
                this.consumePower(8.0f);
            }
        };
        halberd = new BeamModule("halberd"){
            {
                float brange;
                this.requirements(Category.units, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.moduleSize = ModuleModule.ModuleSize.medium;
                this.size = 2;
                this.outlineColor = Pal.darkOutline;
                this.shootY = 4.0f;
                this.range = brange = 96.0f;
                this.ammo(new Object[]{Liquids.nitrogen, new BeamBulletType(40.0f, "prog-mats-halberd-beam"){
                    {
                        super(damage, beamSprite);
                        this.length = brange - shootY * 2.0f + 1.0f;
                        this.pierceCap = 4;
                        this.knockback = 1.0f;
                        this.growTime = 16.0f;
                        this.fadeTime = 28.0f;
                        this.lifetime = this.growTime + this.fadeTime;
                        this.optimalLifeFract = this.growTime / this.lifetime;
                    }
                }});
            }
        };
        gravity = new TractorConeModule("gravity"){
            {
                this.requirements(Category.units, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.moduleSize = ModuleModule.ModuleSize.medium;
                this.size = 2;
                this.outlineColor = Pal.darkOutline;
                this.range = 528.0f;
                this.tractorCone = 30.0f;
                this.ignoreMass = true;
                this.force = 0.02f;
                this.scaledForce = 0.06f;
                this.consumePower(4.0f);
            }
        };
        firestorm = new ArcModule("firestorm"){
            {
                this.requirements(Category.units, PMBlocks.incompleteVisibility(), ItemStack.with((Object[])new Object[0]));
                this.moduleSize = ModuleModule.ModuleSize.large;
                this.size = 3;
                this.outlineColor = Pal.darkOutline;
                this.ammo(new Object[]{Items.carbide, ModuleBullets.firestormMissile});
                this.reload = 300.0f;
                this.maxAmmo = 27;
                this.range = 216.0f;
                this.minRange = 56.0f;
                this.targetAir = false;
                this.shootSound = Sounds.missileSmall;
                this.hideDetails = false;
                this.shoot = new ShootBarrel(){
                    {
                        this.barrels = new float[]{0.0f, 0.0f, 0.0f, -3.0f, 3.0f, 0.0f, 3.0f, 3.0f, 0.0f, -3.0f, -3.0f, 0.0f, 3.0f, -3.0f, 0.0f};
                        this.shots = 9;
                        this.shotDelay = 10.0f;
                    }
                };
            }
        };
    }

    public static void setClip(float newClip) {
        maxClip = Math.max(maxClip, newClip);
    }
}

