/*
 * Decompiled with CFR 0.152.
 */
package progressed.content.bullets;

import arc.graphics.Color;
import blackhole.entities.bullet.BlackHoleBulletType;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.entities.bullet.BulletType;
import mindustry.entities.effect.MultiEffect;
import mindustry.entities.effect.WrapEffect;
import mindustry.gen.Sounds;
import mindustry.graphics.Pal;
import progressed.content.PMStatusEffects;
import progressed.content.PMUnitTypes;
import progressed.content.bullets.MinigunBullets;
import progressed.content.bullets.ModuleBullets;
import progressed.content.bullets.PayloadBullets;
import progressed.content.bullets.SniperBullets;
import progressed.content.effects.EnergyFx;
import progressed.entities.bullet.PillarFieldBulletType;
import progressed.entities.bullet.energy.BitBulletType;
import progressed.entities.bullet.energy.CrossLaserBulletType;
import progressed.entities.bullet.energy.LaserBlastBulletType;
import progressed.entities.bullet.physical.BurstDriverOrb;
import progressed.entities.bullet.physical.InjectorBulletType;
import progressed.entities.bullet.physical.MagnetBulletType;
import progressed.entities.bullet.unit.SignalFlareBulletType;
import progressed.entities.effect.RepeatEffect;

public class PMBullets {
    public static BulletType magnetCopper;
    public static BulletType magnetTitanium;
    public static BulletType magenetTenelium;
    public static BulletType pixel;
    public static BulletType syringe;
    public static BulletType smallFlare;
    public static BulletType mediumFlare;
    public static BulletType largeFlare;
    public static BulletType pillarField;
    public static BulletType blackHole;
    public static BulletType excaliburLaser;
    public static BulletType sentinelLaser;
    public static BulletType harmanuke;
    public static BulletType burstDriverOrb;

    public static void load() {
        magnetCopper = new MagnetBulletType(2.5f, 12.0f){
            {
                this.lifetime = 300.0f;
                this.scaledForce = 0.3f;
                this.attractRange = 96.0f;
                this.frontColor = Color.valueOf((String)"EAC2A9");
                this.backColor = Color.valueOf((String)"B8705C");
            }
        };
        magnetTitanium = new MagnetBulletType(2.8f, 25.0f){
            {
                this.lifetime = 400.0f;
                this.scaledForce = 0.8f;
                this.attractRange = 120.0f;
                this.frontColor = Color.valueOf((String)"A4B8FA");
                this.backColor = Color.valueOf((String)"7575C8");
            }
        };
        magenetTenelium = new MagnetBulletType(3.4f, 45.0f){
            {
                this.lifetime = 500.0f;
                this.scaledForce = 1.7f;
                this.attractRange = 168.0f;
                this.frontColor = Color.valueOf((String)"B0BAC0");
                this.backColor = Color.valueOf((String)"6E7080");
            }
        };
        pixel = new BitBulletType(2.0f, 5.0f){
            {
                this.lifetime = 90.0f;
                this.splashDamage = 27.0f;
                this.splashDamageRadius = 40.0f;
                this.size = 8.0f;
                this.hitSize = 8.0f;
                this.homingPower = 0.01f;
                this.homingRange = 160.0f;
                this.knockback = 3.0f;
                this.weaveScale = 10.0f;
                this.weaveMag = 2.0f;
                this.trailDelay = 7.5f;
            }
        };
        syringe = new InjectorBulletType(3.0f, 7.0f){
            {
                this.nanomachines = true;
                this.vaccines = new InjectorBulletType.Vaccine[]{new InjectorBulletType.Vaccine(PMStatusEffects.vcFrenzy), new InjectorBulletType.Vaccine(PMStatusEffects.vcDisassembly), new InjectorBulletType.Vaccine(PMStatusEffects.vcWeaken), new InjectorBulletType.Vaccine(PMStatusEffects.vcCorvus)};
                this.height = 8.0f;
                this.width = 8.0f;
                this.lifetime = 50.0f;
                this.ammoMultiplier = 4.0f;
            }
        };
        smallFlare = new SignalFlareBulletType(8.0f, 60.0f, PMUnitTypes.flareSmall){
            {
                this.size = 4.0f;
                this.spinSpeed = 3.0f;
            }
        };
        mediumFlare = new SignalFlareBulletType(7.0f, 70.0f, PMUnitTypes.flareMedium){
            {
                this.size = 8.0f;
                this.spinSpeed = 5.0f;
            }
        };
        largeFlare = new SignalFlareBulletType(6.0f, 80.0f, PMUnitTypes.flareLarge){
            {
                this.size = 12.0f;
                this.spinSpeed = 8.0f;
            }
        };
        pillarField = new PillarFieldBulletType(){
            {
                this.lifetime = 90.0f;
                this.radius = 40.0f;
                this.amount = 10;
            }
        };
        blackHole = new BlackHoleBulletType(0.5f, 46.666668f){
            {
                this.lifetime = 630.0f;
                this.lightRadius = 8.0f;
                this.lightOpacity = 0.7f;
                int times = 25;
                float life = EnergyFx.kugelblitzGrow.lifetime;
                this.chargeEffect = new MultiEffect(new Effect[]{new WrapEffect((Effect)new RepeatEffect(EnergyFx.kugelblitzCharge, (life - EnergyFx.kugelblitzCharge.lifetime - 1.0f) / (float)times, times), Color.black, 48.0f), EnergyFx.kugelblitzGrow});
                this.chargeEffect.lifetime = life;
                this.despawnEffect = EnergyFx.blackHoleDespawn;
            }
        };
        excaliburLaser = new CrossLaserBulletType(1500.0f){
            {
                this.length = 800.0f;
                this.width = 26.0f;
                this.growTime = 10.0f;
                this.fadeTime = 40.0f;
                this.lifetime = 70.0f;
                this.crossLength = 300.0f;
                this.crossWidth = 18.0f;
                this.colors = new Color[]{Color.valueOf((String)"E8D174").a(0.4f), Pal.surge, Color.white};
            }
        };
        sentinelLaser = new LaserBlastBulletType(12.0f, 150.0f){
            {
                this.lifetime = 36.0f;
                this.splashDamage = 450.0f;
                this.splashDamageRadius = 48.0f;
                this.scaledSplashDamage = true;
                this.buildingDamageMultiplier = 0.3f;
                this.length = 8.0f;
                this.width = 3.0f;
                this.trailLength = 12;
                this.makeFire = true;
                this.trailColor = this.hitColor = Pal.lancerLaser;
                this.hitEffect = EnergyFx.sentinelBlast;
                this.hitSound = Sounds.shockBlast;
                this.hitSoundVolume = 4.0f;
            }
        };
        harmanuke = new BasicBulletType(){
            {
                this.sprite = "large-bomb";
                this.height = 30.0f;
                this.width = 30.0f;
                this.backColor = Color.red;
                this.frontColor = Color.white;
                this.mixColorTo = Color.white;
                this.hitSound = Sounds.plasmaboom;
                this.hitShake = 4.0f;
                this.lifetime = 70.0f;
                this.despawnEffect = EnergyFx.redBomb;
                this.hitEffect = Fx.massiveExplosion;
                this.keepVelocity = false;
                this.spin = 2.0f;
                this.shrinkY = 0.7f;
                this.shrinkX = 0.7f;
                this.speed = 0.0f;
                this.collides = false;
                this.splashDamage = 1000.0f;
                this.splashDamageRadius = 80.0f;
                this.displayAmmoMultiplier = false;
            }
        };
        burstDriverOrb = new BurstDriverOrb();
        MinigunBullets.load();
        SniperBullets.load();
        ModuleBullets.load();
        PayloadBullets.load();
    }
}

