/*
 * Decompiled with CFR 0.152.
 */
package progressed.content.effects;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import blackhole.entities.effect.SwirlEffect;
import mindustry.entities.Effect;
import mindustry.gen.Posc;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;
import progressed.gen.entities.TurretParentEffectState;
import progressed.graphics.PMPal;
import progressed.util.PMMathf;

public class EnergyFx {
    public static Effect eruptorBurn = new Effect(30.0f, e -> {
        Draw.color((Color)PMPal.magma);
        Angles.randLenVectors((long)e.id, (int)6, (float)(64.0f * e.fin()), (float)e.rotation, (float)20.0f, (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Angles.angle((float)x, (float)y), (float)(8.0f * e.fout())));
    });
    public static Effect bitTrail = new Effect(75.0f, e -> {
        float offset = Mathf.randomSeed((long)e.id);
        Color c = Tmp.c1.set(PMPal.pixelFront).lerp(PMPal.pixelBack, Mathf.absin((float)(Time.time * 0.05f + offset), (float)1.0f, (float)1.0f));
        Draw.color((Color)c);
        Fill.square((float)e.x, (float)e.y, (float)(e.rotation * e.fout()));
    });
    public static Effect bitBurst = new Effect(30.0f, e -> {
        float[] set = new float[]{Mathf.curve((float)e.time, (float)0.0f, (float)(e.lifetime * 2.0f / 3.0f)), Mathf.curve((float)e.time, (float)(e.lifetime * 1.0f / 3.0f), (float)e.lifetime)};
        float offset = Mathf.randomSeed((long)e.id);
        Color c = Tmp.c1.set(PMPal.pixelFront).lerp(PMPal.pixelBack, Mathf.absin((float)(Time.time * 0.05f + offset), (float)1.0f, (float)1.0f));
        Draw.color((Color)c);
        Lines.stroke((float)2.5f);
        for (int i = 0; i < 2; ++i) {
            if (!(set[i] > 0.0f) || !(set[i] < 1.0f)) continue;
            for (int j = 0; j < 8; ++j) {
                float s = 41.0f * set[i];
                float front = Mathf.clamp((float)s, (float)0.0f, (float)15.0f);
                float back = Mathf.clamp((float)(s - 3.0f), (float)0.0f, (float)15.0f);
                Tmp.v1.trns((float)j * 45.0f, 0.0f, front);
                Tmp.v1.add(e.x, e.y);
                Tmp.v2.trns((float)j * 45.0f, 0.0f, back);
                Tmp.v2.add(e.x, e.y);
                Lines.line((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y);
            }
        }
    });
    public static Effect kugelblitzGrow = new Effect(80.0f, e -> {
        int sides = 80;
        float space = 360.0f / (float)sides;
        float fin = e.fin(Interp.circleOut);
        float rX = 20.0f * fin;
        float rY = 10.0f * fin;
        float in = Color.whiteFloatBits;
        float out = e.color.toFloatBits();
        for (int i = 0; i < sides; ++i) {
            float t1 = (float)i * space;
            float t2 = (float)(i + 1) * space;
            Tmp.v1.trns(t1, PMMathf.circleStarPoint(t1)).scl(rX, rY).add(e.x, e.y);
            Tmp.v2.trns(t2, PMMathf.circleStarPoint(t2)).scl(rX, rY).add(e.x, e.y);
            Fill.quad((float)e.x, (float)e.y, (float)in, (float)e.x, (float)e.y, (float)in, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)out, (float)Tmp.v2.x, (float)Tmp.v2.y, (float)out);
        }
        Drawf.light((float)e.x, (float)e.y, (float)(rX * 2.0f), (Color)e.color, (float)0.8f);
    }){

        protected void add(float x, float y, float rotation, Color color, Object data) {
            TurretParentEffectState entity = TurretParentEffectState.create();
            entity.effect = this;
            entity.rotation = this.baseRotation + rotation;
            entity.data = data;
            entity.lifetime = this.lifetime;
            entity.set(x, y);
            entity.color.set(color);
            if (this.followParent && data instanceof Posc) {
                Posc p;
                entity.parent = p = (Posc)data;
                entity.rotWithParent = this.rotWithParent;
            }
            entity.add();
        }
    }.followParent(true).rotWithParent(true);
    public static Effect kugelblitzCharge = new SwirlEffect(30.0f, null, 8, 2.0f, 30.0f, 90.0f, -1.0f, -1.0f){
        {
            this.lightOpacity = -1.0f;
        }
    }.layer(99.97f);
    public static Effect blackHoleDespawn = new Effect(80.0f, e -> {
        float rad = 24.0f;
        e.scaled(60.0f, s -> {
            Lines.stroke((float)(6.0f * s.fout()), (Color)e.color);
            Lines.circle((float)e.x, (float)e.y, (float)(1.5f * rad * s.fin((Interp)Interp.pow3Out)));
        });
        Lines.stroke((float)(2.0f * e.fout()), (Color)Color.black);
        Lines.circle((float)e.x, (float)e.y, (float)(rad * e.fin((Interp)Interp.pow3Out)));
    }).layer(110.03f);
    public static Effect sentinelBlast = new Effect(80.0f, 150.0f, e -> {
        Draw.color((Color)Pal.missileYellow);
        e.scaled(50.0f, s -> {
            Lines.stroke((float)(5.0f * s.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(4.0f + s.fin() * 40.0f));
        });
        Draw.color((Color)e.color);
        Angles.randLenVectors((long)e.id, (int)20, (float)(3.0f + 60.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(1.0f + e.fout() * 6.0f)));
        Draw.color((Color)Pal.missileYellowBack);
        Lines.stroke((float)e.fout());
        Angles.randLenVectors((long)(e.id + 1), (int)11, (float)(2.0f + 73.0f * e.finpow()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Angles.angle((float)x, (float)y), (float)(2.0f + e.fout() * 5.0f)));
    });
    public static Effect redBomb = new Effect(40.0f, 100.0f, e -> {
        int i;
        Draw.color((Color)Color.red);
        Lines.stroke((float)(e.fout() * 2.0f));
        float circleRad = 4.0f + e.finpow() * 65.0f;
        Lines.circle((float)e.x, (float)e.y, (float)circleRad);
        Draw.color((Color)Color.red);
        for (i = 0; i < 4; ++i) {
            Drawf.tri((float)e.x, (float)e.y, (float)6.0f, (float)(100.0f * e.fout()), (float)(i * 90));
        }
        Draw.color();
        for (i = 0; i < 4; ++i) {
            Drawf.tri((float)e.x, (float)e.y, (float)3.0f, (float)(35.0f * e.fout()), (float)(i * 90));
        }
        Drawf.light((float)e.x, (float)e.y, (float)(circleRad * 1.6f), (Color)Pal.heal, (float)e.fout());
    });
}

