/*
 * Decompiled with CFR 0.152.
 */
package progressed.content.effects;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.Rand;
import arc.util.Tmp;
import blackhole.entities.effect.SwirlEffect;
import mindustry.entities.Effect;
import mindustry.gen.Fire;
import mindustry.graphics.Drawf;
import mindustry.graphics.Pal;

public class MissileFx {
    public static final Rand rand = new Rand();
    public static Effect shootSmokeDownpour = new Effect(70.0f, e -> {
        rand.setSeed((long)e.id);
        for (int i = 0; i < 25; ++i) {
            Tmp.v1.trns(e.rotation + 180.0f + rand.range(30.0f), rand.random(e.finpow() * 40.0f));
            e.scaled(e.lifetime * rand.random(0.3f, 1.0f), b -> {
                Draw.color((Color)e.color, (Color)Pal.lightishGray, (float)b.fin());
                Fill.circle((float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y), (float)(b.fout() * 3.4f + 0.3f));
            });
        }
    });
    public static Effect rocketTrailSmoke = new Effect(180.0f, 300.0f, b -> {
        float intensity = 2.0f;
        Draw.color((Color)b.color, (float)0.7f);
        int i = 0;
        while (i < 4) {
            rand.setSeed((long)(b.id * 2 + i));
            float lenScl = rand.random(0.5f, 1.0f);
            int fi = i++;
            b.scaled(b.lifetime * lenScl, e -> Angles.randLenVectors((long)(e.id + fi - 1), (float)e.fin((Interp)Interp.pow10Out), (int)((int)(2.9f * intensity)), (float)(28.0f * intensity), (float)(e.rotation - 180.0f), (float)15.0f, (x, y, in, out) -> {
                float fout = e.fout((Interp)Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((1.0f + intensity) * 1.65f);
                Fill.circle((float)(e.x + x), (float)(e.y + y), (float)rad);
                Drawf.light((float)(e.x + x), (float)(e.y + y), (float)(rad * 2.5f), (Color)b.color, (float)0.5f);
            }));
        }
    }).layer(99.0f);
    public static Effect flameRing = new Effect(45.0f, e -> {
        if (Fire.regions[0] == null) {
            for (int i = 0; i < 40; ++i) {
                Fire.regions[i] = Core.atlas.find("fire" + i);
            }
        }
        float amount = 40.0f;
        float fin = e.fin((Interp)Interp.pow5Out);
        Draw.alpha((float)e.fout((Interp)Interp.pow3Out));
        rand.setSeed((long)e.id);
        int i = 0;
        while ((float)i < amount) {
            int frame = (int)Mathf.mod((float)(e.time * 2.25f + (float)rand.random(40)), (float)40.0f);
            Tmp.v1.trns((float)i * (360.0f / amount) + rand.range(180.0f), 88.0f * fin);
            Draw.rect((TextureRegion)Fire.regions[frame], (float)(e.x + Tmp.v1.x), (float)(e.y + Tmp.v1.y));
            ++i;
        }
        Draw.color();
    });
    public static Effect incendBurning = new Effect(35.0f, e -> {
        Draw.color((Color)Pal.lightPyraFlame, (Color)Pal.darkPyraFlame, (float)e.fin());
        Angles.randLenVectors((long)e.id, (int)5, (float)(2.0f + e.fin() * 12.0f), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(0.1f + e.fout() * 1.9f)));
    });
    public static Effect smallBoom = new Effect(30.0f, e -> {
        Draw.color((Color)Pal.missileYellow);
        e.scaled(7.0f, s -> {
            Lines.stroke((float)(1.5f * s.fout()));
            Lines.circle((float)e.x, (float)e.y, (float)(2.0f + s.fin() * 15.0f));
        });
        Draw.color((Color)Color.darkGray);
        Draw.alpha((float)0.9f);
        Angles.randLenVectors((long)e.id, (int)13, (float)(1.0f + 27.0f * e.finpow()), (x, y) -> Fill.circle((float)(e.x + x), (float)(e.y + y), (float)(0.5f + e.fout() * 7.0f)));
        Lines.stroke((float)(e.fout() * 0.75f), (Color)Pal.missileYellowBack);
        Angles.randLenVectors((long)(e.id + 1), (int)6, (float)(0.5f + 32.0f * e.finpow()), (x, y) -> Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)Angles.angle((float)x, (float)y), (float)(0.5f + e.fout() * 2.0f)));
    }).layer(99.979f);
    public static Effect missileExplosion = new Effect(30.0f, 500.0f, e -> {
        float intensity = 2.0f;
        float baseLifetime = 25.0f + intensity * 15.0f;
        e.lifetime = 50.0f + intensity * 64.0f;
        Draw.color((Color)Color.darkGray);
        Draw.alpha((float)0.9f);
        int i = 0;
        while (i < 5) {
            rand.setSeed((long)e.id * 2L + (long)i);
            float lenScl = rand.random(0.25f, 1.0f);
            int fi = i++;
            e.scaled(e.lifetime * lenScl, s -> Angles.randLenVectors((long)(s.id + fi - 1), (float)s.fin((Interp)Interp.pow10Out), (int)((int)(2.8f * intensity)), (float)(25.0f * intensity), (x, y, in, out) -> {
                float fout = s.fout((Interp)Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 2.35f);
                Fill.circle((float)(s.x + x), (float)(s.y + y), (float)rad);
            }));
        }
        e.scaled(baseLifetime, s -> {
            Draw.color((Color)Color.gray);
            s.scaled(3.0f + intensity * 2.0f, i -> {
                Lines.stroke((float)((3.1f + intensity / 5.0f) * i.fout()));
                Lines.circle((float)s.x, (float)s.y, (float)((3.0f + i.fin() * 14.0f) * intensity));
                Drawf.light((float)s.x, (float)s.y, (float)(i.fin() * 28.0f * 2.0f * intensity), (Color)Color.white, (float)(0.9f * i.fout()));
            });
            Draw.color((Color)Pal.lighterOrange, (Color)Pal.lightOrange, (Color)Pal.redSpark, (float)s.fin());
            Lines.stroke((float)(2.0f * s.fout()));
            Draw.z((float)110.001f);
            Angles.randLenVectors((long)(s.id + 1), (float)(s.finpow() + 0.001f), (int)((int)(8.0f * intensity)), (float)(30.0f * intensity), (x, y, in, out) -> {
                Lines.lineAngleCenter((float)(s.x + x), (float)(s.y + y), (float)Angles.angle((float)x, (float)y), (float)(1.0f + out * 4.0f * (4.0f + intensity)));
                Drawf.light((float)(s.x + x), (float)(s.y + y), (float)(out * 4.0f * (3.0f + intensity) * 3.5f), (Color)Draw.getColor(), (float)0.8f);
            });
        });
    }).layer(99.979f);
    public static Effect nuclearExplosion = new Effect(30.0f, 500.0f, e -> {
        float intensity = 8.0f;
        float baseLifetime = 25.0f + intensity * 15.0f;
        e.lifetime = 50.0f + intensity * 64.0f;
        Draw.color((Color)Color.darkGray);
        Draw.alpha((float)0.9f);
        int i = 0;
        while (i < 5) {
            rand.setSeed((long)e.id * 2L + (long)i);
            float lenScl = rand.random(0.25f, 1.0f);
            int fi = i++;
            e.scaled(e.lifetime * lenScl, s -> Angles.randLenVectors((long)(s.id + fi - 1), (float)s.fin((Interp)Interp.pow10Out), (int)((int)(2.8f * intensity)), (float)(25.0f * intensity), (x, y, in, out) -> {
                float fout = s.fout((Interp)Interp.pow5Out) * rand.random(0.5f, 1.0f);
                float rad = fout * ((2.0f + intensity) * 2.35f);
                Fill.circle((float)(s.x + x), (float)(s.y + y), (float)rad);
            }));
        }
        e.scaled(baseLifetime, s -> {
            Draw.color((Color)Color.gray);
            s.scaled(5.0f + intensity * 2.0f, i -> {
                Lines.stroke((float)((3.1f + intensity / 5.0f) * i.fout()));
                Lines.circle((float)s.x, (float)s.y, (float)((3.0f + i.fin() * 14.0f) * intensity));
                Drawf.light((float)s.x, (float)s.y, (float)(i.fin() * 28.0f * 2.0f * intensity), (Color)Draw.getColor(), (float)(0.9f * i.fout()));
            });
            Draw.color((Color)Pal.lighterOrange, (Color)Pal.lightOrange, (Color)Pal.redSpark, (float)s.fin());
            Lines.stroke((float)(2.0f * s.fout()));
            Draw.z((float)110.001f);
            Angles.randLenVectors((long)(s.id + 1), (float)(s.finpow() + 0.001f), (int)((int)(8.0f * intensity)), (float)(30.0f * intensity), (x, y, in, out) -> {
                Lines.lineAngleCenter((float)(s.x + x), (float)(s.y + y), (float)Angles.angle((float)x, (float)y), (float)(1.0f + out * 4.0f * (4.0f + intensity)));
                Drawf.light((float)(s.x + x), (float)(s.y + y), (float)(out * 4.0f * (3.0f + intensity) * 3.5f), (Color)Draw.getColor(), (float)0.8f);
            });
        });
    }).layer(99.979f);
    public static Effect hitEmpSpark = new Effect(40.0f, e -> {
        Draw.color((Color)e.color);
        Lines.stroke((float)(e.fout() * 1.2f));
        Angles.randLenVectors((long)e.id, (int)11, (float)(e.finpow() * 18.0f), (float)e.rotation, (float)360.0f, (x, y) -> {
            float ang = Mathf.angle((float)x, (float)y);
            Lines.lineAngle((float)(e.x + x), (float)(e.y + y), (float)ang, (float)(e.fout() * 3.0f + 1.0f));
        });
    });
    public static Effect bigBlackHoleSwirl = new SwirlEffect(90.0f, 16, 8.0f, 120.0f, 480.0f).layer(110.005f);
    public static Effect blackHoleNukeParticle = new Effect(300.0f, e -> {
        rand.setSeed((long)e.id);
        float rad = rand.random(1.0f, 4.0f) * 8.0f * (1.0f - Interp.pow3Out.apply(Mathf.curve((float)e.time, (float)120.0f, (float)300.0f)));
        float ang = rand.random(360.0f);
        float dst = rand.random(8.0f, 24.0f) * 8.0f * e.fin((Interp)Interp.pow5Out);
        Draw.color((Color)Color.black);
        Fill.circle((float)(e.x + Angles.trnsx((float)ang, (float)dst)), (float)(e.y + Angles.trnsy((float)ang, (float)dst)), (float)rad);
    }).layer(110.02f);
    public static Effect blackHoleNukeWaves = new Effect(180.0f, e -> {
        float rad = 96.0f;
        e.scaled(150.0f, s -> {
            Lines.stroke((float)(24.0f * s.fout()), (Color)e.color);
            Lines.circle((float)e.x, (float)e.y, (float)(1.5f * rad * s.fin((Interp)Interp.pow3Out)));
        });
        Lines.stroke((float)(16.0f * e.fout()), (Color)Color.black);
        Lines.circle((float)e.x, (float)e.y, (float)(rad * e.fin((Interp)Interp.pow3Out)));
    }).layer(110.03f);
}

