/*
 * Decompiled with CFR 0.152.
 */
package progressed.content.effects;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.graphics.g2d.Lines;
import arc.math.Angles;
import arc.math.Interp;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import mindustry.Vars;
import mindustry.entities.Effect;
import mindustry.graphics.Pal;
import progressed.graphics.draw3d.Perspective;
import progressed.world.blocks.defence.ShieldProjector;

public class Pseudo3DFx {
    public static Effect absorbedSmall = new Effect(38.0f, e -> {
        Draw.color((Color)Pal.missileYellow);
        float z = e.rotation;
        float zScl = Perspective.scale(e.x, e.y, z);
        e.scaled(13.0f, s -> {
            Lines.stroke((float)(2.0f * s.fout() * zScl));
            Angles.randLenVectors((long)e.id, (int)8, (float)((2.0f + 34.0f * s.fin()) * zScl), (x, y) -> {
                Vec2 pos = Perspective.drawPos(e.x + x, e.y + y, z);
                Lines.lineAngle((float)pos.x, (float)pos.y, (float)Angles.angle((float)x, (float)y), (float)((2.0f + s.fout() * 8.0f) * zScl));
            });
        });
        float in = Interp.pow2Out.apply(Mathf.curve((float)e.fin(), (float)0.0f, (float)0.6f));
        float out = 1.0f - Interp.pow2In.apply(Mathf.curve((float)e.fin(), (float)0.6f));
        Lines.stroke((float)((0.5f * out + e.fout()) * zScl));
        Vec2 pos = Perspective.drawPos(e.x, e.y, z);
        Lines.circle((float)pos.x, (float)pos.y, (float)((2.0f * out + 13.0f * in * out) * zScl));
    });
    public static Effect absorbed = new Effect(52.0f, e -> {
        Draw.color((Color)Pal.missileYellow);
        float z = e.rotation;
        float zScl = Perspective.scale(e.x, e.y, z);
        e.scaled(24.0f, s -> {
            Lines.stroke((float)(3.0f * s.fout() * zScl));
            Angles.randLenVectors((long)e.id, (int)14, (float)((2.0f + 53.0f * s.fin()) * zScl), (x, y) -> {
                Vec2 pos = Perspective.drawPos(e.x + x, e.y + y, z);
                Lines.lineAngle((float)pos.x, (float)pos.y, (float)Angles.angle((float)x, (float)y), (float)((2.0f + s.fout() * 13.0f) * zScl));
            });
        });
        float in = Interp.pow2Out.apply(Mathf.curve((float)e.fin(), (float)0.0f, (float)0.6f));
        float out = 1.0f - Interp.pow2In.apply(Mathf.curve((float)e.fin(), (float)0.6f));
        Lines.stroke((float)((out + 2.0f * e.fout()) * zScl));
        Vec2 pos = Perspective.drawPos(e.x, e.y, z);
        Lines.circle((float)pos.x, (float)pos.y, (float)((6.0f * out + 31.0f * in * out) * zScl));
    });
    public static Effect absorbedLarge = new Effect(74.0f, e -> {
        Draw.color((Color)Pal.missileYellow);
        float z = e.rotation;
        float zScl = Perspective.scale(e.x, e.y, z);
        e.scaled(32.0f, s -> {
            Lines.stroke((float)(5.0f * s.fout() * zScl));
            Angles.randLenVectors((long)e.id, (int)20, (float)(4.0f + 114.0f * s.fin() * zScl), (x, y) -> {
                Vec2 pos = Perspective.drawPos(e.x + x, e.y + y, z);
                Lines.lineAngle((float)pos.x, (float)pos.y, (float)Angles.angle((float)x, (float)y), (float)((3.0f + s.fout() * 18.0f) * zScl));
            });
        });
        float in = Interp.pow2Out.apply(Mathf.curve((float)e.fin(), (float)0.0f, (float)0.6f));
        float out = 1.0f - Interp.pow2In.apply(Mathf.curve((float)e.fin(), (float)0.6f));
        Lines.stroke((float)((2.0f * out + 3.0f * e.fout()) * zScl));
        Vec2 pos = Perspective.drawPos(e.x, e.y, z);
        Lines.circle((float)pos.x, (float)pos.y, (float)((6.0f * out + 57.0f * in * out) * zScl));
    });
    public static Effect shieldRecharge = new Effect(20.0f, e -> {
        ShieldProjector.ShieldBuild build;
        Object patt3030$temp = e.data;
        if (!(patt3030$temp instanceof ShieldProjector.ShieldBuild) || !(build = (ShieldProjector.ShieldBuild)((Object)((Object)patt3030$temp))).isAdded()) {
            return;
        }
        Draw.color((Color)e.color, (float)e.fout());
        Lines.stroke((float)(1.0f + e.fout()));
        float finpow = e.finpow();
        float[] corners = build.getShieldCorners(build.realRadius() * finpow);
        build.drawCorners(corners, build.realHeight() * finpow, (x1, y1, x2, y2, x3, y3, x4, y4) -> {
            Lines.line((float)x1, (float)y1, (float)x2, (float)y2);
            Lines.line((float)x1, (float)y1, (float)x4, (float)y4);
            Lines.line((float)x2, (float)y2, (float)x3, (float)y3);
            Lines.line((float)x4, (float)y4, (float)x3, (float)y3);
        });
    }).layer(124.99f);
    public static Effect shieldBreak = new Effect(40.0f, e -> {
        Object patt3641$temp = e.data;
        if (!(patt3641$temp instanceof ShieldSizeData)) {
            return;
        }
        ShieldSizeData data = (ShieldSizeData)patt3641$temp;
        Lines.stroke((float)(3.0f * e.fout()), (Color)e.color);
        float[] corners = ShieldProjector.getShieldCorners(e.x, e.y, e.rotation, data.sides, data.rotation);
        ShieldProjector.drawCorners(corners, data.z, data.sides, (x1, y1, x2, y2, x3, y3, x4, y4) -> {
            Lines.line((float)x1, (float)y1, (float)x2, (float)y2);
            Lines.line((float)x1, (float)y1, (float)x4, (float)y4);
            Lines.line((float)x2, (float)y2, (float)x3, (float)y3);
            Lines.line((float)x4, (float)y4, (float)x3, (float)y3);
        });
    });
    public static Effect shieldShrink = new Effect(20.0f, e -> {
        Object patt4177$temp = e.data;
        if (!(patt4177$temp instanceof ShieldSizeData)) {
            return;
        }
        ShieldSizeData data = (ShieldSizeData)patt4177$temp;
        float radius = e.rotation * e.fout();
        if (radius > 0.001f) {
            Draw.color((Color)e.color);
            float[] corners = ShieldProjector.getShieldCorners(e.x, e.y, radius, data.sides, data.rotation);
            if (Vars.renderer.animateShields) {
                Draw.z((float)125.001f);
            } else {
                Draw.z((float)125.0f);
                Lines.stroke((float)1.5f);
                Draw.alpha((float)(0.09f + Mathf.clamp((float)0.08f)));
            }
            Fill.polyBegin();
            ShieldProjector.drawCorners(corners, data.z * e.fout(), data.sides, (x1, y1, x2, y2, x3, y3, x4, y4) -> {
                Fill.quad((float)x1, (float)y1, (float)x2, (float)y2, (float)x3, (float)y3, (float)x4, (float)y4);
                Fill.polyPoint((float)x4, (float)y4);
            });
            Fill.polyEnd();
            if (Vars.renderer.animateShields) {
                Draw.z((float)126.01f);
            } else {
                Draw.z((float)125.001f);
            }
            Draw.alpha((float)1.0f);
            ShieldProjector.drawCorners(corners, data.z * e.fout(), data.sides, (x1, y1, x2, y2, x3, y3, x4, y4) -> {
                Lines.line((float)x1, (float)y1, (float)x2, (float)y2);
                Lines.line((float)x1, (float)y1, (float)x4, (float)y4);
                Lines.line((float)x2, (float)y2, (float)x3, (float)y3);
                Lines.line((float)x4, (float)y4, (float)x3, (float)y3);
            });
            Draw.color();
        }
    });

    public static class ShieldSizeData {
        public int sides;
        public float z;
        public float rotation;

        public ShieldSizeData(int sides, float rotation, float z) {
            this.sides = sides;
            this.rotation = rotation;
            this.z = z;
        }
    }
}

