/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Vec2;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.entities.Effect;
import mindustry.gen.EffectState;
import mindustry.gen.Posc;

public class LightningEffect
extends Effect {
    private static final Rand rand = new Rand();
    private static final Vec2 v = new Vec2();
    public Color colorFrom = null;
    public Color colorTo = null;
    public float stroke = 4.0f;
    public float width = 6.0f;
    public boolean extend;
    public boolean shrink;
    private boolean initialized;

    public LightningEffect(float life, float clipsize, float stroke) {
        this();
        this.lifetime = life;
        this.clip = clipsize;
        this.stroke = stroke;
    }

    public LightningEffect() {
        this.followParent = false;
    }

    public LightningEffect colorFrom(Color colorFrom) {
        this.colorFrom = colorFrom;
        return this;
    }

    public LightningEffect colorTo(Color colorTo) {
        this.colorTo = colorTo;
        return this;
    }

    public LightningEffect shrink(boolean s) {
        this.shrink = s;
        return this;
    }

    public LightningEffect extend(boolean e) {
        this.extend = e;
        return this;
    }

    public LightningEffect startDelay(float d) {
        this.startDelay = d;
        return this;
    }

    public LightningEffect followParent(boolean follow) {
        this.followParent = follow;
        return this;
    }

    public LightningEffect rotWithParent(boolean follow) {
        this.rotWithParent = follow;
        return this;
    }

    public LightningEffect layer(float l) {
        this.layer = l;
        return this;
    }

    public LightningEffect layer(float l, float duration) {
        this.layer = l;
        this.layerDuration = duration;
        return this;
    }

    public LightningEffect width(float w) {
        this.width = w;
        return this;
    }

    public void at(float x, float y, float ex, float ey, Color color) {
        this.at(x, y, ex, ey, color, null);
    }

    public void at(float x, float y, float ex, float ey, Color color, Object data) {
        this.create(x, y, ex, ey, color, data);
    }

    public void create(float x, float y, float ex, float ey, Color color, Object data) {
        if (!this.shouldCreate()) {
            return;
        }
        if (Core.camera.bounds(Tmp.r1).overlaps(Tmp.r2.setCentered(x, y, this.clip))) {
            if (!this.initialized) {
                this.initialized = true;
                this.init();
            }
            if (this.startDelay <= 0.0f) {
                this.add(ex, ey, x, y, color, data);
            } else {
                Time.run((float)this.startDelay, () -> this.add(x, y, ex, ey, color, data));
            }
        }
    }

    protected void add(float x, float y, float ex, float ey, Color color, Object data) {
        LightningEffectState entity = LightningEffectState.create();
        entity.effect = this;
        entity.data = data;
        entity.lifetime = this.lifetime;
        entity.ex = ex;
        entity.ey = ey;
        entity.set(x, y);
        entity.color.set(color);
        if (this.followParent && data instanceof Posc) {
            Posc p;
            entity.parent = p = (Posc)data;
            entity.rotWithParent = this.rotWithParent;
        }
        entity.add();
    }

    public float render(int id, Color color, float life, float lifetime, float x, float y, float ex, float ey, Object data) {
        Draw.z((float)this.layer);
        Draw.reset();
        float dst = Mathf.dst((float)x, (float)y, (float)ex, (float)ey);
        v.set(ex, ey).sub(x, y).nor();
        float fin = life / lifetime;
        float fout = 1.0f - fin;
        float normx = LightningEffect.v.x;
        float normy = LightningEffect.v.y;
        int links = Mathf.ceil((float)(dst / this.width));
        float spacing = dst / (float)links;
        Lines.stroke((float)(this.stroke * fout));
        Draw.color((Color)(this.colorFrom == null ? color : this.colorFrom), (Color)(this.colorTo == null ? color : this.colorTo), (float)fin);
        Lines.beginLine();
        Lines.linePoint((float)x, (float)y);
        rand.setSeed((long)id);
        float l = links;
        if (this.extend) {
            l *= Mathf.curve((float)fin, (float)0.0f, (float)0.5f);
        }
        int i = 0;
        while ((float)i < l) {
            float ny;
            float nx;
            if (i == links - 1) {
                nx = ex;
                ny = ey;
            } else {
                float len = (float)(i + 1) * spacing;
                float r = this.width / 2.0f;
                if (this.shrink) {
                    r *= (float)i / (float)links;
                }
                v.setToRandomDirection(rand).scl(r);
                nx = x + normx * len + LightningEffect.v.x;
                ny = y + normy * len + LightningEffect.v.y;
            }
            Lines.linePoint((float)nx, (float)ny);
            ++i;
        }
        Lines.endLine();
        Draw.reset();
        return lifetime;
    }

    public static class LightningEffectState
    extends EffectState {
        public float ex;
        public float ey;

        public void draw() {
            this.lifetime = ((LightningEffect)this.effect).render(this.id, this.color, this.time, this.lifetime, this.x, this.y, this.ex, this.ey, this.data);
        }

        public static LightningEffectState create() {
            return (LightningEffectState)((Object)Pools.obtain(LightningEffectState.class, LightningEffectState::new));
        }
    }
}

