/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities;

import arc.func.Boolf;
import arc.func.Cons;
import arc.func.Intc2;
import arc.math.Mathf;
import arc.math.geom.Geometry;
import arc.math.geom.Intersector;
import arc.math.geom.Point2;
import arc.math.geom.Position;
import arc.math.geom.Rect;
import arc.math.geom.Vec2;
import arc.struct.FloatSeq;
import arc.struct.IntSet;
import arc.struct.Seq;
import arc.util.Tmp;
import arc.util.pooling.Pool;
import arc.util.pooling.Pools;
import mindustry.Vars;
import mindustry.ai.types.MissileAI;
import mindustry.core.World;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Units;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Healthc;
import mindustry.gen.Hitboxc;
import mindustry.gen.Teamc;
import mindustry.gen.Unit;
import mindustry.type.StatusEffect;
import mindustry.world.Tile;

public class PMDamage {
    private static final Rect rect = new Rect();
    private static final Rect hitrect = new Rect();
    private static final Vec2 tr = new Vec2();
    private static final Vec2 seg1 = new Vec2();
    private static final Vec2 seg2 = new Vec2();
    private static final Seq<Unit> units = new Seq();
    private static final IntSet collidedBlocks = new IntSet();
    private static final Seq<Damage.Collided> collided = new Seq();
    private static final Pool<Damage.Collided> collidePool = Pools.get(Damage.Collided.class, Damage.Collided::new);
    private static final FloatSeq distances = new FloatSeq();
    private static Tile furthest;
    private static Building tmpBuilding;
    private static Unit tmpUnit;
    private static float tmpFloat;
    private static boolean check;

    public static void trueEachBlock(float wx, float wy, float range, Cons<Building> cons) {
        collidedBlocks.clear();
        int tx = World.toTile((float)wx);
        int ty = World.toTile((float)wy);
        int tileRange = Mathf.floorPositive((float)(range / 8.0f));
        for (int x = tx - tileRange - 2; x <= tx + tileRange + 2; ++x) {
            for (int y = ty - tileRange - 2; y <= ty + tileRange + 2; ++y) {
                Building other;
                if (!Mathf.within((float)(x * 8), (float)(y * 8), (float)wx, (float)wy, (float)range) || (other = Vars.world.build(x, y)) == null || collidedBlocks.contains(other.pos())) continue;
                cons.get((Object)other);
                collidedBlocks.add(other.pos());
            }
        }
    }

    public static void trueEachTile(float wx, float wy, float range, Cons<Tile> cons) {
        collidedBlocks.clear();
        int tx = World.toTile((float)wx);
        int ty = World.toTile((float)wy);
        int tileRange = Mathf.floorPositive((float)(range / 8.0f));
        for (int x = tx - tileRange - 2; x <= tx + tileRange + 2; ++x) {
            for (int y = ty - tileRange - 2; y <= ty + tileRange + 2; ++y) {
                Tile other;
                if (!Mathf.within((float)(x * 8), (float)(y * 8), (float)wx, (float)wy, (float)range) || (other = Vars.world.tile(x, y)) == null || collidedBlocks.contains(other.pos())) continue;
                cons.get((Object)other);
                collidedBlocks.add(other.pos());
            }
        }
    }

    public static void allNearbyEnemies(Team team, float x, float y, float radius, Cons<Healthc> cons) {
        Units.nearbyEnemies((Team)team, (float)(x - radius), (float)(y - radius), (float)(radius * 2.0f), (float)(radius * 2.0f), unit -> {
            if (unit.within(x, y, radius + unit.hitSize / 2.0f) && !unit.dead) {
                cons.get(unit);
            }
        });
        PMDamage.trueEachBlock(x, y, radius, (Cons<Building>)((Cons)build -> {
            if (build.team != team && !build.dead && build.block != null) {
                cons.get(build);
            }
        }));
    }

    public static boolean checkForTargets(Team team, float x, float y, float radius) {
        check = false;
        Units.nearbyEnemies((Team)team, (float)(x - radius), (float)(y - radius), (float)(radius * 2.0f), (float)(radius * 2.0f), unit -> {
            if (unit.within(x, y, radius + unit.hitSize / 2.0f) && !unit.dead) {
                check = true;
            }
        });
        PMDamage.trueEachBlock(x, y, radius, (Cons<Building>)((Cons)build -> {
            if (build.team != team && !build.dead && build.block != null) {
                check = true;
            }
        }));
        return check;
    }

    public static Teamc bestTarget(Team team, float cx, float cy, float x, float y, float range, Boolf<Unit> unitPred, Boolf<Building> tilePred, Units.Sortf sort) {
        if (team == Team.derelict) {
            return null;
        }
        Unit unit = PMDamage.findEnemyUnit(team, cx, cy, x, y, range, unitPred, sort);
        if (unit != null) {
            return unit;
        }
        return PMDamage.findEnemyTile(team, cx, cy, x, y, range, tilePred);
    }

    public static Unit findEnemyUnit(Team team, float cx, float cy, float x, float y, float range, Boolf<Unit> pred, Units.Sortf unitSort) {
        tmpUnit = null;
        tmpFloat = Float.NEGATIVE_INFINITY;
        Units.nearbyEnemies((Team)team, (float)(cx - range), (float)(cy - range), (float)(range * 2.0f), (float)(range * 2.0f), unit -> {
            float cost = unitSort.cost(unit, x, y);
            if (!unit.dead && tmpFloat < cost && unit.within(cx, cy, range + unit.hitSize / 2.0f) && pred.get(unit)) {
                tmpUnit = unit;
                tmpFloat = cost;
            }
        });
        return tmpUnit;
    }

    public static Building findEnemyTile(Team team, float cx, float cy, float x, float y, float range, Boolf<Building> pred) {
        tmpBuilding = null;
        tmpFloat = 0.0f;
        PMDamage.trueEachBlock(cx, cy, range, (Cons<Building>)((Cons)b -> {
            if (b.team() != team && (b.team() != Team.derelict || Vars.state.rules.coreCapture) && pred.get(b)) {
                float dist = b.dst(x, y) - b.hitSize() / 2.0f;
                if (tmpBuilding == null || dist < tmpFloat && b.block.priority >= PMDamage.tmpBuilding.block.priority || b.block.priority > PMDamage.tmpBuilding.block.priority) {
                    tmpBuilding = b;
                    tmpFloat = dist;
                }
            }
        }));
        return tmpBuilding;
    }

    public static boolean collideLine(float damage, Team team, Effect effect, StatusEffect status, float statusDuration, float x, float y, float angle, float length, boolean ground, boolean air) {
        return PMDamage.collideLine(damage, team, effect, status, statusDuration, x, y, angle, length, ground, air, false);
    }

    public static boolean collideLine(float damage, Team team, Effect effect, StatusEffect status, float statusDuration, float x, float y, float angle, float length, boolean ground, boolean air, boolean buildings) {
        tr.trnsExact(angle, length);
        rect.setPosition(x, y).setSize(PMDamage.tr.x, PMDamage.tr.y);
        float x2 = x + PMDamage.tr.x;
        float y2 = y + PMDamage.tr.y;
        if (PMDamage.rect.width < 0.0f) {
            PMDamage.rect.x += PMDamage.rect.width;
            PMDamage.rect.width *= -1.0f;
        }
        if (PMDamage.rect.height < 0.0f) {
            PMDamage.rect.y += PMDamage.rect.height;
            PMDamage.rect.height *= -1.0f;
        }
        float expand = 3.0f;
        PMDamage.rect.y -= expand;
        PMDamage.rect.x -= expand;
        PMDamage.rect.width += expand * 2.0f;
        PMDamage.rect.height += expand * 2.0f;
        check = false;
        Cons cons = e -> {
            e.hitbox(hitrect);
            Vec2 vec = Geometry.raycastRect((float)x, (float)y, (float)x2, (float)y2, (Rect)hitrect.grow(expand * 2.0f));
            if (vec != null && damage > 0.0f) {
                effect.at(vec.x, vec.y, angle, team.color);
                e.damage(damage);
                e.apply(status, statusDuration);
                check = true;
            }
        };
        units.clear();
        Units.nearbyEnemies((Team)team, (Rect)rect, u -> {
            if (u.checkTarget(air, ground)) {
                units.add(u);
            }
        });
        units.sort(u -> u.dst2(x, y));
        units.each(cons);
        if (buildings) {
            collidedBlocks.clear();
            Intc2 collider = (cx, cy) -> {
                boolean collide;
                Building tile = Vars.world.build(cx, cy);
                boolean bl = collide = tile != null && collidedBlocks.add(tile.pos());
                if (collide && damage > 0.0f && tile.team != team) {
                    effect.at(tile.x, tile.y, angle, team.color);
                    tile.damage(damage);
                    check = true;
                }
            };
            seg1.set(x, y);
            seg2.set(seg1).add(tr);
            World.raycastEachWorld((float)x, (float)y, (float)PMDamage.seg2.x, (float)PMDamage.seg2.y, (cx, cy) -> {
                collider.get(cx, cy);
                for (Point2 p : Geometry.d4) {
                    Tile other = Vars.world.tile(p.x + cx, p.y + cy);
                    if (other == null || !Intersector.intersectSegmentRectangle((Vec2)seg1, (Vec2)seg2, (Rect)other.getBounds(Tmp.r1))) continue;
                    collider.get(cx + p.x, cy + p.y);
                }
                return false;
            });
        }
        return check;
    }

    public static void missileCollideLine(Bullet hitter, Team team, Effect effect, float x, float y, float angle, float length, boolean large, boolean laser, int pierceCap) {
        if (pierceCap > 0) {
            length = PMDamage.findPierceLength(hitter, pierceCap, length);
        } else if (laser) {
            length = Damage.findLaserLength((Bullet)hitter, (float)length);
        }
        collidedBlocks.clear();
        tr.trnsExact(angle, length);
        float expand = 3.0f;
        rect.setPosition(x, y).setSize(PMDamage.tr.x, PMDamage.tr.y).normalize().grow(expand * 2.0f);
        float x2 = PMDamage.tr.x + x;
        float y2 = PMDamage.tr.y + y;
        Units.nearbyEnemies((Team)team, (Rect)rect, u -> {
            if (u.checkTarget(hitter.type.collidesAir, hitter.type.collidesGround) && u.hittable() && u.controller() instanceof MissileAI) {
                u.hitbox(hitrect);
                Vec2 vec = Geometry.raycastRect((float)x, (float)y, (float)x2, (float)y2, (Rect)hitrect.grow(expand * 2.0f));
                if (vec != null) {
                    collided.add((Object)((Damage.Collided)collidePool.obtain()).set(vec.x, vec.y, (Teamc)u));
                }
            }
        });
        int[] collideCount = new int[]{0};
        collided.sort(c -> hitter.dst2(c.x, c.y));
        collided.each(c -> {
            Teamc patt10006$temp;
            if (hitter.damage > 0.0f && (pierceCap <= 0 || collideCount[0] < pierceCap) && (patt10006$temp = c.target) instanceof Unit) {
                Unit u = (Unit)patt10006$temp;
                effect.at(c.x, c.y);
                u.collision((Hitboxc)hitter, c.x, c.y);
                hitter.collision((Hitboxc)u, c.x, c.y);
                collideCount[0] = collideCount[0] + 1;
            }
        });
        collidePool.freeAll(collided);
        collided.clear();
    }

    public static float findLaserLength(float x, float y, float angle, Team team, float length) {
        Tmp.v1.trns(angle, length);
        furthest = null;
        boolean found = World.raycast((int)World.toTile((float)x), (int)World.toTile((float)y), (int)World.toTile((float)(x + Tmp.v1.x)), (int)World.toTile((float)(y + Tmp.v1.y)), (tx, ty) -> {
            furthest = Vars.world.tile(tx, ty);
            return furthest != null && furthest.team() != team && PMDamage.furthest.block().absorbLasers;
        });
        return found && furthest != null ? Math.max(6.0f, Mathf.dst((float)x, (float)y, (float)furthest.worldx(), (float)furthest.worldy())) : length;
    }

    public static float findPierceLength(Bullet b, int pierceCap, float length) {
        tr.trnsExact(b.rotation(), length);
        rect.setPosition(b.x, b.y).setSize(PMDamage.tr.x, PMDamage.tr.y).normalize().grow(3.0f);
        tmpFloat = Float.POSITIVE_INFINITY;
        distances.clear();
        World.raycast((int)b.tileX(), (int)b.tileY(), (int)World.toTile((float)(b.x + PMDamage.tr.x)), (int)World.toTile((float)(b.y + PMDamage.tr.y)), (x, y) -> {
            Building build = Vars.world.build(x, y);
            if (build != null && build.team != b.team && build.collide(b) && b.checkUnderBuild(build, (float)(x * 8), (float)(y * 8))) {
                float dst = b.dst((float)(x * 8), (float)(y * 8)) - 8.0f;
                distances.add(dst);
                if (b.type.laserAbsorb && build.absorbLasers()) {
                    tmpFloat = Math.min(tmpFloat, dst);
                    return true;
                }
            }
            return false;
        });
        Units.nearbyEnemies((Team)b.team, (Rect)rect, u -> {
            u.hitbox(hitrect);
            if (u.checkTarget(b.type.collidesAir, b.type.collidesGround) && u.hittable() && Intersector.intersectSegmentRectangle((float)b.x, (float)b.y, (float)(b.x + PMDamage.tr.x), (float)(b.y + PMDamage.tr.y), (Rect)hitrect)) {
                distances.add(b.dst((Position)u) - u.hitSize());
            }
        });
        distances.sort();
        return Math.min(PMDamage.distances.size < pierceCap || pierceCap < 0 ? length : Math.max(6.0f, distances.get(pierceCap - 1)), tmpFloat);
    }

    public static void completeDamage(Team team, float x, float y, float radius, float damage, float buildDmbMult, boolean air, boolean ground) {
        PMDamage.allNearbyEnemies(team, x, y, radius, (Cons<Healthc>)((Cons)t -> {
            if (t instanceof Unit) {
                Unit u = (Unit)t;
                if (u.isFlying() && air || u.isGrounded() && ground) {
                    u.damage(damage);
                }
            } else if (t instanceof Building) {
                Building b = (Building)t;
                if (ground) {
                    b.damage(team, damage * buildDmbMult);
                }
            }
        }));
    }

    public static void completeDamage(Team team, float x, float y, float radius, float damage) {
        PMDamage.completeDamage(team, x, y, radius, damage, 1.0f, true, true);
    }

    public static Vec2 linecast(boolean ground, boolean air, Team team, float x, float y, float angle, float length) {
        tr.trnsExact(angle, length);
        tmpBuilding = null;
        if (ground) {
            seg1.set(x, y);
            seg2.set(seg1).add(tr);
            World.raycastEachWorld((float)x, (float)y, (float)PMDamage.seg2.x, (float)PMDamage.seg2.y, (cx, cy) -> {
                Building tile = Vars.world.build(cx, cy);
                if (tile != null && tile.team != team) {
                    tmpBuilding = tile;
                    Tmp.v1.set((float)(cx * 8), (float)(cy * 8));
                    return true;
                }
                return false;
            });
        }
        float expand = 3.0f;
        rect.setPosition(x, y).setSize(PMDamage.tr.x, PMDamage.tr.y).normalize().grow(expand * 2.0f);
        float x2 = PMDamage.tr.x + x;
        float y2 = PMDamage.tr.y + y;
        tmpUnit = null;
        Units.nearbyEnemies((Team)team, (Rect)rect, e -> {
            if (tmpUnit != null && e.dst2(x, y) > tmpUnit.dst2(x, y) || !e.checkTarget(ground, air)) {
                return;
            }
            e.hitbox(hitrect);
            Vec2 vec = Geometry.raycastRect((float)x, (float)y, (float)x2, (float)y2, (Rect)hitrect.grow(expand * 2.0f));
            if (vec != null) {
                tmpUnit = e;
                Tmp.v2.set(vec);
            }
        });
        if (tmpBuilding != null && tmpUnit != null) {
            if (Mathf.dst2((float)x, (float)y, (float)Tmp.v1.x, (float)Tmp.v1.y) <= Mathf.dst2((float)x, (float)y, (float)Tmp.v2.x, (float)Tmp.v2.y)) {
                return Tmp.v1;
            }
        } else {
            if (tmpBuilding != null) {
                return Tmp.v1;
            }
            if (tmpUnit != null) {
                return Tmp.v2;
            }
        }
        return tr.add(x, y);
    }
}

