/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet;

import arc.audio.Sound;
import arc.func.Cons;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.struct.Seq;
import arc.util.Tmp;
import blackhole.utils.BlackHoleUtils;
import mindustry.content.Blocks;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Groups;
import mindustry.gen.Sounds;
import mindustry.gen.Unitc;
import mindustry.world.Block;
import mindustry.world.Tile;
import progressed.content.effects.LightningFx;
import progressed.content.effects.OtherFx;
import progressed.entities.LightningEffect;
import progressed.entities.PMDamage;
import progressed.graphics.PMPal;
import progressed.util.PMMathf;
import progressed.world.blocks.defence.IgneousPillar;

public class PillarFieldBulletType
extends BulletType {
    public IgneousPillar pillar;
    public Sound formationSound = Sounds.rockBreak;
    public float formationSoundVolume = 0.25f;
    public float radius = 60.0f;
    public int amount = 1;
    public float fadeTime = 8.0f;
    public float ringStroke = 2.0f;
    public Color ringColor = PMPal.darkBrown;
    public Effect ringEffect = OtherFx.earthquke;
    public float ringEffectInterval = 2.0f;
    public int crackEffects = 1;
    public Color crackColor = PMPal.darkBrown;
    public LightningEffect crackEffect = LightningFx.groundCrack;
    public Effect placeEffect = OtherFx.pillarPlace;

    public PillarFieldBulletType() {
        this.hittable = false;
        this.absorbable = false;
        this.speed = 0.0f;
        this.collides = false;
        this.shootEffect = this.smokeEffect = Fx.none;
        this.despawnEffect = this.smokeEffect;
        this.hitEffect = this.smokeEffect;
        this.layer = 20.0f;
        this.displayAmmoMultiplier = false;
    }

    public void init() {
        super.init();
        this.drawSize = Math.max(this.radius + this.ringStroke + 8.0f, this.drawSize);
    }

    public void init(Bullet b) {
        super.init(b);
        PillarFieldData data = new PillarFieldData();
        PMDamage.trueEachTile(b.x, b.y, this.radius, (Cons<Tile>)((Cons)t -> data.tiles.add(t)));
        data.tiles.shuffle();
        b.data = data;
    }

    public void update(Bullet b) {
        super.update(b);
        Object object = b.data;
        if (object instanceof PillarFieldData) {
            PillarFieldData data = (PillarFieldData)object;
            if (b.timer(1, this.lifetime / (float)this.amount)) {
                for (int i = 0; i < data.tiles.size; ++i) {
                    boolean occupied;
                    Tile t = (Tile)data.tiles.get(i);
                    if (t.block() != Blocks.air || (occupied = Groups.unit.intersect(t.worldx(), t.worldy(), 1.0f, 1.0f).contains(Unitc::isGrounded))) continue;
                    data.tiles.remove((Object)t);
                    this.placeEffect.at(t.worldx(), t.worldy(), (float)this.pillar.size);
                    this.formationSound.at(t.worldx(), t.worldy(), Mathf.random((float)0.8f, (float)1.2f), this.formationSoundVolume);
                    t.setNet((Block)this.pillar, b.team, 0);
                    break;
                }
            }
        }
        if (b.timer(2, this.ringEffectInterval)) {
            for (int i = 0; i < this.crackEffects; ++i) {
                PMMathf.randomCirclePoint(Tmp.v1, this.radius).add((Position)b);
                PMMathf.randomCirclePoint(Tmp.v2, this.radius).add((Position)b);
                this.crackEffect.at(Tmp.v1.x, Tmp.v1.y, Tmp.v2.x, Tmp.v2.y, this.crackColor);
            }
            if (b.time <= b.lifetime - this.ringEffect.lifetime - this.fadeTime) {
                this.ringEffect.at(b.x, b.y, this.radius);
            }
        }
    }

    public void draw(Bullet b) {
        Lines.stroke((float)this.ringStroke, (Color)this.ringColor);
        Draw.alpha((float)(1.0f - Mathf.curve((float)b.time, (float)(b.lifetime - this.fadeTime), (float)b.lifetime)));
        Lines.circle((float)b.x, (float)b.y, (float)this.radius);
    }

    static {
        BlackHoleUtils.immuneBulletTypes.add(PillarFieldBulletType.class);
    }

    public static class PillarFieldData {
        public Seq<Tile> tiles = new Seq();
    }
}

