/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.energy;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Fill;
import arc.math.Mathf;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.bullet.LaserBulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;
import progressed.entities.PMDamage;

public class CrossLaserBulletType
extends LaserBulletType {
    public float growTime = 5.0f;
    public float fadeTime = 5.0f;
    public float crossLength;
    public float crossWidth;
    public float crossSection = 0.7f;
    public float midLen = 0.3f;
    public float border = 3.5f;
    public float crossBorder = 2.0f;

    public CrossLaserBulletType(float damage) {
        super(damage);
        this.laserEffect = Fx.none;
        this.collidesAir = true;
        this.collidesGround = true;
        this.largeHit = true;
        this.displayAmmoMultiplier = false;
    }

    public void init(Bullet b) {
        super.init(b);
        b.data = new CrossLaserData();
        Time.run((float)this.growTime, () -> {
            for (int i = 0; i < 2; ++i) {
                Tmp.v1.trns(b.rotation(), b.fdata * this.crossSection);
                float x = b.x + Tmp.v1.x;
                float y = b.y + Tmp.v1.y;
                float resultLength = PMDamage.findLaserLength(x, y, b.rotation() + 90.0f * (float)Mathf.signs[i], b.team, this.crossLength);
                Damage.collideLine((Bullet)b, (Team)b.team, (float)x, (float)y, (float)(b.rotation() + 90.0f * (float)Mathf.signs[i]), (float)resultLength, (boolean)this.largeHit);
                ((CrossLaserData)b.data).addLength(resultLength, i);
            }
        });
    }

    public void draw(Bullet b) {
        CrossLaserData data = (CrossLaserData)b.data;
        float fin = Mathf.curve((float)b.fin(), (float)0.0f, (float)(this.growTime / b.lifetime));
        float cfin = Mathf.curve((float)b.fin(), (float)(this.growTime / b.lifetime), (float)(this.growTime / b.lifetime * 2.0f));
        float fout = 1.0f - Mathf.curve((float)b.fin(), (float)((b.lifetime - this.fadeTime) / b.lifetime), (float)1.0f);
        float frac = b.fdata / this.length;
        float l = b.fdata * fin;
        float w = this.width / 2.0f * fin * frac;
        float mid = l * this.midLen;
        float cross = l * this.crossSection;
        for (int i = 0; i < this.colors.length; ++i) {
            float bord = this.border * (float)i * fin * frac;
            Draw.color((Color)this.colors[i], (float)fout);
            Tmp.v1.trns(b.rotation(), mid, -(w - bord));
            Tmp.v1.add(b.x, b.y);
            Tmp.v2.trns(b.rotation(), mid, w - bord);
            Tmp.v2.add(b.x, b.y);
            Tmp.v3.trns(b.rotation(), l);
            Tmp.v3.add(b.x, b.y);
            Fill.tri((float)b.x, (float)b.y, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y);
            Fill.tri((float)Tmp.v3.x, (float)Tmp.v3.y, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y);
        }
        Tmp.v1.trns(b.rotation(), l);
        Tmp.v1.add(b.x, b.y);
        Drawf.light((float)b.x, (float)b.y, (float)Tmp.v1.x, (float)Tmp.v1.y, (float)(w * 2.0f * fin * fout), (Color)this.colors[1], (float)0.6f);
        if (data.valid()) {
            int i;
            float cblock = (data.left() / this.crossLength + data.right() / this.crossLength) / 2.0f;
            float[] cl = new float[]{data.left() * cfin, data.right() * cfin};
            float[] cw = new float[]{this.crossWidth / 2.0f * cfin * cblock, this.crossWidth / 2.0f * cfin * cblock};
            for (i = 0; i < this.colors.length; ++i) {
                float[] cbord = new float[]{this.crossBorder * (float)i * cfin * cblock, this.crossBorder * (float)i * cfin * cblock};
                Draw.color((Color)this.colors[i], (float)fout);
                for (int j = 0; j < 2; ++j) {
                    Tmp.v1.trns(b.rotation(), cross, cl[j] * (float)Mathf.signs[j]);
                    Tmp.v1.add(b.x, b.y);
                    Tmp.v2.trns(b.rotation(), cross + cw[j] - cbord[j]);
                    Tmp.v2.add(b.x, b.y);
                    Tmp.v3.trns(b.rotation(), cross - cw[j] + cbord[j]);
                    Tmp.v3.add(b.x, b.y);
                    Fill.tri((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y, (float)Tmp.v3.x, (float)Tmp.v3.y);
                }
            }
            for (i = 0; i < 2; ++i) {
                Tmp.v1.trns(b.rotation(), cross, cl[i] * (float)Mathf.signs[i]);
                Tmp.v1.add(b.x, b.y);
                Tmp.v2.trns(b.rotation(), cross);
                Tmp.v2.add(b.x, b.y);
                Drawf.light((float)Tmp.v1.x, (float)Tmp.v1.y, (float)Tmp.v2.x, (float)Tmp.v2.y, (float)(cw[i] * 2.0f * fin * fout), (Color)this.colors[1], (float)0.6f);
            }
        }
    }

    public void drawLight(Bullet b) {
    }

    public static class CrossLaserData {
        public float[] lengths = new float[2];

        public void addLength(float length, int index) {
            this.lengths[index] = length;
        }

        public boolean valid() {
            return this.lengths != null;
        }

        public float left() {
            return this.lengths[0];
        }

        public float right() {
            return this.lengths[1];
        }
    }
}

