/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.energy;

import arc.audio.Sound;
import arc.graphics.Color;
import arc.math.Interp;
import arc.math.Mathf;
import blackhole.entities.bullet.BlackHoleBulletType;
import blackhole.graphics.BHDrawf;
import blackhole.graphics.BHLayer;
import blackhole.graphics.BlackHoleRenderer;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import mindustry.gen.Teamc;
import progressed.graphics.renders.SlashRenderer;

public class SlashBlackHoleBulletType
extends BlackHoleBulletType {
    public float slashTime;
    public float slashOffsetStart;
    public float slashOffsetEnd;
    public float slashLength = 1024.0f;
    public float slashWidthFrom = 8.0f;
    public float slashWidthTo;
    public Color slashColor;
    public Effect slashEffect = Fx.none;
    public Sound slashSound = Sounds.laserblast;
    public float slashSoundVolume = 2.0f;

    public SlashBlackHoleBulletType(float speed, float damage) {
        super(speed, damage);
        this.layer = BHLayer.end + 2.0f;
    }

    public void init(Bullet b) {
        super.init(b);
        if (this.slashColor == null) {
            this.slashColor = this.starOut;
        }
    }

    public void update(Bullet b) {
        super.update(b);
        if (b.fdata == 0.0f && b.time > b.lifetime - this.slashTime) {
            b.fdata = 1.0f;
            this.slashEffect.at(b.x, b.y, 0.0f, BHDrawf.teamColor((Teamc)b, (Color)this.slashColor), (Object)b);
            this.slashSound.at(b.x, b.y, 1.0f, this.slashSoundVolume);
        }
    }

    public void draw(Bullet b) {
        float fout = this.fout(b);
        BlackHoleRenderer.addBlackHole((float)b.x, (float)b.y, (float)(this.horizonRadius * fout), (float)(this.lensingRadius * fout), (Color)BHDrawf.teamColor((Teamc)b, (Color)this.color));
        if (b.time > b.lifetime - this.slashTime) {
            float ang = Mathf.randomSeed((long)b.id, (float)((float)Math.PI * 2));
            float sfin = Interp.sineOut.apply(Mathf.curve((float)b.time, (float)(b.lifetime - this.slashTime), (float)b.lifetime));
            float off = Mathf.lerp((float)this.slashOffsetStart, (float)this.slashOffsetEnd, (float)sfin) * fout;
            SlashRenderer.addSlash(b.x, b.y, ang, off, this.slashLength * fout, Mathf.lerp((float)this.slashWidthFrom, (float)this.slashWidthTo, (float)sfin) * fout, BHDrawf.teamColor((Teamc)b, (Color)this.slashColor).toFloatBits());
        } else if (this.starWidth > 0.0f) {
            BlackHoleRenderer.addStar((float)b.x, (float)b.y, (float)(this.starWidth * fout), (float)(this.starHeight * fout), (float)this.starAngle, (Color)BHDrawf.teamColor((Teamc)b, (Color)this.starIn), (Color)BHDrawf.teamColor((Teamc)b, (Color)this.starOut));
        }
    }
}

