/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.physical;

import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.content.Fx;
import mindustry.entities.Effect;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import progressed.entities.PMDamage;

public class AntiMissileRailBulletType
extends BulletType {
    static float furthest = 0.0f;
    static boolean any = false;
    public Effect pierceEffect = Fx.hitBulletSmall;
    public Effect pointEffect = Fx.none;
    public Effect lineEffect = Fx.none;
    public Effect endEffect = Fx.none;
    public float length = 100.0f;
    public float pointEffectSpace = 20.0f;

    public AntiMissileRailBulletType() {
        this.speed = 0.0f;
        this.pierceBuilding = true;
        this.pierce = true;
        this.reflectable = false;
        this.hitEffect = Fx.none;
        this.despawnEffect = Fx.none;
        this.collides = false;
        this.keepVelocity = false;
        this.lifetime = 1.0f;
        this.collidesGround = false;
    }

    protected float calculateRange() {
        return this.length;
    }

    public void handlePierce(Bullet b, float initialHealth, float x, float y) {
        float sub = Math.max(initialHealth * this.pierceDamageFactor, 0.0f);
        if (b.damage <= 0.0f) {
            b.fdata = Math.min(b.fdata, b.dst(x, y));
            return;
        }
        if (b.damage > 0.0f) {
            this.pierceEffect.at(x, y, b.rotation());
            this.hitEffect.at(x, y);
        }
        b.damage -= Math.min(b.damage, sub);
        if (b.damage <= 0.0f) {
            furthest = Math.min(furthest, b.dst(x, y));
        }
        any = true;
    }

    public void init(Bullet b) {
        super.init(b);
        b.fdata = this.length;
        furthest = this.length;
        any = false;
        PMDamage.missileCollideLine(b, b.team, b.type.hitEffect, b.x, b.y, b.rotation(), this.length, false, false, this.pierceCap);
        float resultLen = furthest;
        Vec2 nor = Tmp.v1.trns(b.rotation(), 1.0f).nor();
        if (this.pointEffect != Fx.none) {
            for (float i = 0.0f; i <= resultLen; i += this.pointEffectSpace) {
                this.pointEffect.at(b.x + nor.x * i, b.y + nor.y * i, b.rotation(), this.trailColor);
            }
        }
        if (!any && this.endEffect != Fx.none) {
            this.endEffect.at(b.x + nor.x * resultLen, b.y + nor.y * resultLen, b.rotation(), this.hitColor);
        }
        if (this.lineEffect != Fx.none) {
            this.lineEffect.at(b.x, b.y, b.rotation(), this.hitColor, (Object)new Vec2(b.x, b.y).mulAdd(nor, resultLen));
        }
    }

    public boolean testCollision(Bullet bullet, Building tile) {
        return bullet.team != tile.team;
    }

    public void hitTile(Bullet b, Building build, float x, float y, float initialHealth, boolean direct) {
        this.handlePierce(b, initialHealth, x, y);
    }
}

