/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.physical;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.graphics.Drawf;
import progressed.world.blocks.distribution.BurstDriver;

public class BurstDriverOrb
extends BulletType {
    float size = 6.0f;
    float minSpin = 10.0f;
    float maxSpin = 25.0f;

    public BurstDriverOrb() {
        super(1.0f, 2.0f);
        this.collidesTiles = false;
        this.lifetime = 1.0f;
        this.despawnEffect = Fx.smeltsmoke;
        this.hitEffect = Fx.hitBulletSmall;
        this.layer = 99.0f;
    }

    public void draw(Bullet b) {
        Object object = b.data();
        if (!(object instanceof BurstDriver.BurstDriverData)) {
            return;
        }
        BurstDriver.BurstDriverData data = (BurstDriver.BurstDriverData)object;
        TextureRegion region = data.item.fullIcon;
        float rot = b.rotation() + Mathf.randomSeed((long)b.id, (float)0.0f, (float)380.0f) + Time.time * Mathf.randomSeed((long)(b.id + 1), (float)this.minSpin, (float)this.maxSpin) * (float)Mathf.signs[Mathf.randomSeed((long)(b.id + 2), (int)0, (int)1)];
        Drawf.shadow((TextureRegion)region, (float)(b.x - this.size / 2.0f), (float)(b.y - this.size / 2.0f), (float)this.size, (float)this.size, (float)rot);
        Lines.stroke((float)(this.size / 12.0f), (Color)data.item.color);
        Lines.circle((float)b.x, (float)b.y, (float)(this.size / 2.0f));
        Draw.color();
        Draw.rect((TextureRegion)region, (float)b.x, (float)b.y, (float)(this.size * 0.75f), (float)(this.size * 0.75f), (float)rot);
    }

    public void update(Bullet b) {
        float baseAngle;
        float angleTo;
        Object object = b.data();
        if (!(object instanceof BurstDriver.BurstDriverData)) {
            this.hit(b);
            return;
        }
        BurstDriver.BurstDriverData data = (BurstDriver.BurstDriverData)object;
        float hitDst = 7.0f;
        if (data.to.dead() || !data.to.isAdded()) {
            return;
        }
        float baseDst = data.from.dst((Position)data.to);
        float dst1 = b.dst((Position)data.from);
        float dst2 = b.dst((Position)data.to);
        boolean intersect = false;
        if (dst1 > baseDst && Angles.near((float)(angleTo = b.angleTo((Position)data.to)), (float)(baseAngle = data.to.angleTo((Position)data.from)), (float)2.0f)) {
            intersect = true;
            b.set(data.to.x + Angles.trnsx((float)baseAngle, (float)hitDst), data.to.y + Angles.trnsy((float)baseAngle, (float)hitDst));
        }
        if (Math.abs(dst1 + dst2 - baseDst) < 4.0f && dst2 <= hitDst) {
            intersect = true;
        }
        if (intersect) {
            data.to.handleBurstItem(b, data);
        }
    }

    public void hit(Bullet b, float hitx, float hity) {
        super.hit(b, hitx, hity);
        this.despawned(b);
    }
}

