/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.physical;

import arc.graphics.Color;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.Rand;
import arc.math.geom.Position;
import arc.math.geom.Vec2;
import arc.util.Time;
import mindustry.Vars;
import mindustry.content.Fx;
import mindustry.entities.Damage;
import mindustry.entities.Effect;
import mindustry.entities.Lightning;
import mindustry.entities.Units;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.game.Team;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import mindustry.gen.Teamc;
import mindustry.graphics.Pal;
import progressed.content.effects.OtherFx;
import progressed.content.effects.TrailFadeFx;
import progressed.graphics.trails.PMTrail;

public class CritBulletType
extends BasicBulletType {
    protected static Rand critRand = new Rand();
    public float critChance = 0.15f;
    public float critMultiplier = 5.0f;
    public Effect critEffect = OtherFx.crit;
    public boolean bouncing;
    public boolean despawnHitEffects = true;

    public CritBulletType(float speed, float damage, String sprite) {
        super(speed, damage, sprite);
        this.pierce = true;
        this.pierceBuilding = true;
        this.impact = true;
        this.ammoMultiplier = 1.0f;
        this.shootEffect = Fx.shootBig;
        this.smokeEffect = Fx.shootBigSmoke;
        this.hitEffect = OtherFx.critPierce;
        this.hitColor = Pal.lightOrange;
        this.trailLength = 10;
        this.trailWidth = -1.0f;
    }

    public CritBulletType(float speed, float damage) {
        this(speed, damage, "bullet");
    }

    public static boolean critChance(Bullet b, float chance) {
        if (chance >= 1.0f) {
            return true;
        }
        critRand.setSeed((long)b.id);
        return critRand.nextFloat() < chance;
    }

    public void init() {
        super.init();
        if (this.trailWidth < 0.0f) {
            this.trailWidth = this.width * 0.1923077f;
        }
    }

    public void init(Bullet b) {
        if (b.data == null) {
            Object object = b.data = CritBulletType.critChance(b, this.critChance) ? "crit" : null;
        }
        if (this.isCrit(b)) {
            b.damage *= this.critMultiplier;
        }
        super.init(b);
    }

    public void update(Bullet b) {
        Teamc target;
        if (!Vars.headless && this.trailLength > 0) {
            if (b.trail == null) {
                b.trail = new PMTrail(this.trailLength);
            }
            b.trail.length = this.trailLength;
            ((PMTrail)b.trail).updateRot(b.x, b.y, b.rotation());
        }
        if (Mathf.chanceDelta((double)1.0) && this.isCrit(b)) {
            this.critEffect.at(b.x, b.y, b.rotation(), b.team.color);
        }
        if (this.homingPower > 1.0E-4f && b.time >= this.homingDelay && (target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)this.homingRange, e -> e.checkTarget(this.collidesAir, this.collidesGround) && !b.collided.contains(e.id), t -> this.collidesGround && !b.collided.contains(t.id))) != null) {
            b.vel.setAngle(Angles.moveToward((float)b.rotation(), (float)b.angleTo((Position)target), (float)(this.homingPower * Time.delta * 50.0f)));
        }
        if (this.weaveMag > 0.0f) {
            b.vel.rotate(Mathf.sin((float)(b.time + (float)Math.PI * this.weaveScale / 2.0f), (float)this.weaveScale, (float)(this.weaveMag * (float)(Mathf.randomSeed((long)b.id, (int)0, (int)1) == 1 ? -1 : 1))) * Time.delta);
        }
        if (this.trailChance > 0.0f && Mathf.chanceDelta((double)this.trailChance)) {
            this.trailEffect.at(b.x, b.y, this.trailParam, this.trailColor);
        }
    }

    public void hitEntity(Bullet b, Hitboxc other, float initialHealth) {
        super.hitEntity(b, other, initialHealth);
        this.bounce(b);
    }

    public void hitTile(Bullet b, Building build, float x, float y, float initialHealth, boolean direct) {
        super.hitTile(b, build, x, y, initialHealth, direct);
        if (direct) {
            this.bounce(b);
        }
    }

    public void despawned(Bullet b) {
        b.fdata = 1.0f;
        super.despawned(b);
    }

    public void removed(Bullet b) {
        if (this.trailLength > 0 && b.trail != null && b.trail.size() > 0) {
            TrailFadeFx.PMTrailFade.at(b.x, b.y, this.trailWidth, this.backColor, (Object)((PMTrail)b.trail).copyPM());
        }
    }

    public void hit(Bullet b, float x, float y) {
        b.hit = true;
        if (b.fdata != 1.0f || this.despawnHitEffects) {
            this.hitEffect.at(x, y, b.rotation(), this.hitColor);
            this.hitSound.at(x, y, this.hitSoundPitch, this.hitSoundVolume);
        }
        Effect.shake((float)this.hitShake, (float)this.hitShake, (Position)b);
        if (this.fragOnHit) {
            this.createFrags(b, x, y);
        }
        this.createPuddles(b, x, y);
        this.createIncend(b, x, y);
        if (this.suppressionRange > 0.0f) {
            Damage.applySuppression((Team)b.team, (float)b.x, (float)b.y, (float)this.suppressionRange, (float)this.suppressionDuration, (float)0.0f, (float)this.suppressionEffectChance, (Position)new Vec2(b.x, b.y));
        }
        this.createSplashDamage(b, x, y);
        for (int i = 0; i < this.lightning; ++i) {
            Lightning.create((Bullet)b, (Color)this.lightningColor, (float)(this.lightningDamage < 0.0f ? this.damage : this.lightningDamage), (float)b.x, (float)b.y, (float)(b.rotation() + Mathf.range((float)(this.lightningCone / 2.0f)) + this.lightningAngle), (int)(this.lightningLength + Mathf.random((int)this.lightningLengthRand)));
        }
    }

    public float damageMultiplier(Bullet b) {
        float critMul = 1.0f;
        if (b.isAdded() && this.isCrit(b)) {
            critMul = this.critMultiplier;
        }
        return super.damageMultiplier(b) * critMul;
    }

    public void createFrags(Bullet b, float x, float y) {
        if (this.fragBullet != null) {
            for (int i = 0; i < this.fragBullets; ++i) {
                float len = Mathf.random((float)1.0f, (float)7.0f);
                float a = b.rotation() + Mathf.range((float)(this.fragRandomSpread / 2.0f)) + this.fragAngle + (float)(i - this.fragBullets / 2) * this.fragSpread;
                Bullet f = this.fragBullet.create(b, x + Angles.trnsx((float)a, (float)len), y + Angles.trnsy((float)a, (float)len), a, Mathf.random((float)this.fragVelocityMin, (float)this.fragVelocityMax), Mathf.random((float)this.fragLifeMin, (float)this.fragLifeMax));
                if (!(f.type instanceof CritBulletType)) continue;
                f.data = b.data;
            }
        }
    }

    public void bounce(Bullet b) {
        Teamc target;
        if (this.bouncing && (target = Units.closestTarget((Team)b.team, (float)b.x, (float)b.y, (float)(this.range * b.fout()), e -> e.isValid() && e.checkTarget(this.collidesAir, this.collidesGround) && !b.collided.contains(e.id), t -> t.isValid() && this.collidesGround && !b.collided.contains(t.id))) != null) {
            b.vel.setAngle(b.angleTo((Position)target));
        }
    }

    public boolean isCrit(Bullet b) {
        return b.data instanceof String;
    }
}

