/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.physical;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Mathf;
import mindustry.entities.bullet.BasicBulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Hitboxc;
import mindustry.gen.Unit;
import mindustry.type.StatusEffect;
import progressed.util.PMUtls;

public class InjectorBulletType
extends BasicBulletType {
    public Vaccine[] vaccines;
    public boolean nanomachines;

    public InjectorBulletType(float speed, float damage, String bulletSprite) {
        super(speed, damage, bulletSprite);
    }

    public InjectorBulletType(float speed, float damage) {
        this(speed, damage, "prog-mats-syringe");
    }

    public void init() {
        super.init();
        if (this.vaccines == null) {
            PMUtls.uhOhSpeghettiOh("Injector bullet " + (Object)((Object)this) + " does not have any nanomachines!");
        }
    }

    public void init(Bullet b) {
        super.init(b);
        b.data = this.vaccines[Mathf.random((int)(this.vaccines.length - 1))];
    }

    public void draw(Bullet b) {
        Draw.z((float)99.97f);
        Draw.color();
        Draw.rect((TextureRegion)this.backRegion, (float)b.x, (float)b.y, (float)this.width, (float)this.height, (float)(b.rotation() - 90.0f));
        Draw.color((Color)((Vaccine)b.data).status.color);
        Draw.rect((TextureRegion)this.frontRegion, (float)b.x, (float)b.y, (float)this.width, (float)this.height, (float)(b.rotation() - 90.0f));
        Draw.reset();
    }

    public void hitEntity(Bullet b, Hitboxc entity, float initialHealth) {
        super.hitEntity(b, entity, initialHealth);
        if (entity instanceof Unit) {
            Unit unit = (Unit)entity;
            Vaccine v = (Vaccine)b.data;
            unit.apply(v.status, v.duration);
        }
    }

    public static class Vaccine {
        public StatusEffect status;
        public float duration;

        public Vaccine(StatusEffect status, float duration) {
            this.status = status;
            this.duration = duration;
        }

        public Vaccine(StatusEffect status) {
            this(status, 300.0f);
        }
    }
}

