/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.pseudo3d;

import arc.Core;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec2;
import arc.util.Tmp;
import mindustry.gen.Bullet;
import progressed.entities.bullet.pseudo3d.ArcBulletType;
import progressed.graphics.PMDrawf;
import progressed.graphics.draw3d.Draw3D;
import progressed.graphics.draw3d.Perspective;

public abstract class ArcBasicBulletType
extends ArcBulletType {
    public String sprite;
    public boolean bloomSprite = true;
    public boolean drawShadow = false;
    public boolean spinShade = true;
    public TextureRegion region;
    public TextureRegion shadowRegion;
    public TextureRegion[] regions;

    public ArcBasicBulletType(float speed, float damage, String sprite) {
        super(speed, damage);
        this.sprite = sprite;
    }

    public ArcBasicBulletType(float speed, float damage) {
        this(speed, damage, "bullet");
        this.spinShade = false;
    }

    public ArcBasicBulletType(float speed) {
        this(speed, 0.0f);
    }

    public void load() {
        this.region = Core.atlas.find(this.sprite);
        if (this.spinShade) {
            this.regions = new TextureRegion[3];
            this.regions[0] = this.region;
            for (int i = 1; i < 3; ++i) {
                this.regions[i] = Core.atlas.find(this.sprite + "-" + i);
            }
        }
        this.shadowRegion = Core.atlas.find(this.sprite + "-shadow", this.region);
    }

    @Override
    public void draw(Bullet b) {
        this.drawTargetZone(b);
        ArcBulletType.ArcBulletData data = (ArcBulletType.ArcBulletData)b.data;
        Vec2 last = Perspective.drawPos(b.lastX, b.lastY, data.lastZ);
        float lastHX = last.x;
        float lastHY = last.y;
        Vec2 curr = Perspective.drawPos(b.x, b.y, data.z);
        float hX = curr.x;
        float hY = curr.y;
        float rot = Angles.angle((float)lastHX, (float)lastHY, (float)hX, (float)hY);
        if (this.drawShadow) {
            float scl = Draw3D.shadowScale(data.z);
            float sX = Angles.trnsx((float)225.0f, (float)data.z) + b.x;
            float sY = Angles.trnsy((float)225.0f, (float)data.z) + b.y;
            float sRot = Angles.angle((float)b.originX, (float)b.originY, (float)b.aimX, (float)b.aimY);
            float sAlpha = Draw3D.shadowAlpha(data.z);
            float pitch = Tmp.v1.set(b.vel.len(), data.zVel).angle();
            if (pitch <= 90.0f) {
                sRot = Mathf.lerp((float)sRot, (float)(sRot < 45.0f ? -135.0f : 225.0f), (float)(pitch / 90.0f));
            } else if (pitch >= 270.0f) {
                sRot = Mathf.lerp((float)sRot, (float)(sRot > 225.0f ? 405.0f : 45.0f), (float)((360.0f - pitch) / 90.0f));
            }
            float fsRot = sRot;
            Draw3D.shadow(() -> {
                Draw.scl((float)scl);
                PMDrawf.shadow(this.shadowRegion, sX, sY, fsRot, sAlpha);
                Draw.scl();
            });
        }
        Draw.z((float)(this.layer + data.z / 3000.0f));
        this.drawTrail(b);
        Draw3D.highBloom(this.bloomSprite, () -> {
            Draw.scl((float)Perspective.scale(b.x, b.y, data.z));
            float alpha = Perspective.alpha(b.x, b.y, data.z);
            if (this.spinShade) {
                PMDrawf.spinSprite(this.regions, hX, hY, rot, alpha);
            } else {
                Draw.alpha((float)alpha);
                Draw.rect((TextureRegion)this.region, (float)hX, (float)hY, (float)rot);
            }
            Draw.scl();
        });
    }
}

