/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.pseudo3d;

import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.entities.bullet.BulletType;
import mindustry.game.Team;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import progressed.entities.bullet.pseudo3d.ArcBasicBulletType;
import progressed.entities.bullet.pseudo3d.ArcBulletType;
import progressed.util.Math3D;

public class ArcBoltBulletType
extends ArcBasicBulletType {
    public ArcBoltBulletType(float speed, float damage, String sprite) {
        super(speed, damage, sprite);
    }

    public ArcBoltBulletType(float speed, float damage) {
        this(speed, damage, "bullet");
        this.drawProgress = false;
        this.drawTarget = false;
        this.drawZone = false;
        this.spinShade = false;
    }

    public ArcBoltBulletType(float speed) {
        this(speed, 0.0f);
    }

    @Override
    public ArcBulletType.ArcBulletData createData() {
        return (ArcBulletType.ArcBulletData)Pools.obtain(ArcBulletType.ArcBulletData.class, ArcBoltData::new);
    }

    @Override
    public ArcBulletType.ArcBulletData createData(float z, float zVel, float gravity) {
        return new ArcBoltData(z, zVel, gravity);
    }

    public Bullet create3DStraight(Entityc owner, Team team, float x, float y, float z, float angle, float tilt, float vel, float accel) {
        Math3D.rotate(Tmp.v31, vel, angle, 0.0f, tilt);
        Math3D.rotate(Tmp.v32, accel, angle, 0.0f, tilt);
        Tmp.v1.set(Tmp.v31.x, Tmp.v31.y);
        ArcBoltData data = new ArcBoltData(z, Tmp.v31.z, -Tmp.v32.z);
        data.xAccel = Tmp.v32.x;
        data.yAccel = Tmp.v32.y;
        Bullet bullet = this.beginBulletCreate(owner, team, x, y);
        bullet.vel.set(Tmp.v1);
        bullet.rotation(Tmp.v1.angle());
        bullet.set(x, y);
        bullet.lastX = x;
        bullet.lastY = y;
        bullet.data = data;
        bullet.hitSize = this.hitSize;
        if (bullet.trail != null) {
            bullet.trail.clear();
        }
        data.updateLifetime(bullet);
        data.updateAimPos(bullet);
        bullet.add();
        return bullet;
    }

    public static class ArcBoltData
    extends ArcBulletType.ArcBulletData {
        public float xAccel;
        public float yAccel;

        public ArcBoltData(float z, float zVel, float gravity) {
            super(z, zVel, gravity);
        }

        public ArcBoltData(float z, float zVel) {
            this(z, zVel, 1.0f);
        }

        public ArcBoltData() {
            this(0.0f, 0.0f);
        }

        @Override
        public void updateAccel(Bullet b) {
            float life = b.lifetime() - b.time();
            float dx = b.aimX - b.x;
            this.xAccel = 2.0f * (dx - b.vel.x * life) / (life * life);
            float dy = b.aimY - b.y;
            this.yAccel = 2.0f * (dy - b.vel.y * life) / (life * life);
        }

        @Override
        public void updateHoming(Bullet b, Position target) {
            BulletType type = b.type;
            Tmp.v1.set(b.aimX, b.aimY).approachDelta(Tmp.v2.set(target), type.homingPower);
            b.aimX = Tmp.v1.x;
            b.aimY = Tmp.v1.y;
            this.updateAccel(b);
        }

        @Override
        public void update(Bullet b) {
            b.vel.add(this.xAccel * Time.delta, this.yAccel * Time.delta);
            super.update(b);
        }

        @Override
        public ArcBulletType.ArcBulletData setAccel(float a) {
            Tmp.v1.set(this.xAccel, this.yAccel).setLength(a);
            this.xAccel = Tmp.v1.x;
            this.yAccel = Tmp.v1.y;
            return this;
        }

        @Override
        public float xAccel(Bullet b) {
            return this.xAccel;
        }

        @Override
        public float yAccel(Bullet b) {
            return this.yAccel;
        }
    }
}

