/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.pseudo3d;

import arc.math.Mathf;
import arc.math.geom.Position;
import arc.util.Time;
import arc.util.Tmp;
import arc.util.pooling.Pools;
import mindustry.content.StatusEffects;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import mindustry.gen.Sounds;
import progressed.content.effects.MissileFx;
import progressed.content.effects.Pseudo3DFx;
import progressed.entities.bullet.pseudo3d.ArcBasicBulletType;
import progressed.entities.bullet.pseudo3d.ArcBulletType;
import progressed.util.Math3D;

public class ArcMissileBulletType
extends ArcBasicBulletType {
    public float accel = 0.1f;

    public ArcMissileBulletType(float damage, String sprite) {
        super(0.0f, damage, sprite);
        this.despawnEffect = MissileFx.missileExplosion;
        this.hitSound = Sounds.largeExplosion;
        this.ammoMultiplier = 1.0f;
        this.scaleLife = true;
        this.scaledSplashDamage = true;
        this.splashDamagePierce = true;
        this.status = StatusEffects.blasted;
        this.drawShadow = true;
        this.drawZone = true;
        this.absorbEffect = Pseudo3DFx.absorbed;
        this.bloomSprite = false;
    }

    public ArcMissileBulletType(String sprite) {
        this(0.0f, sprite);
    }

    public ArcMissileBulletType() {
        this("prog-mats-basic-missile");
    }

    @Override
    public ArcBulletType.ArcBulletData createData() {
        return (ArcBulletType.ArcBulletData)Pools.obtain(ArcMissileData.class, ArcMissileData::new);
    }

    @Override
    public ArcBulletType.ArcBulletData createData(float z, float zVel, float gravity) {
        return new ArcMissileData(z, zVel, gravity);
    }

    @Override
    public void init(Bullet b) {
        if (this.accel < 0.0f) {
            this.accel = 1.0f;
        }
        super.init(b);
    }

    @Override
    public void arcBulletDataInit(Bullet b) {
        if (this.isInheritive) {
            return;
        }
        ArcBulletType.ArcBulletData a = (ArcBulletType.ArcBulletData)b.data;
        a.updateAimPos(b);
    }

    @Override
    public void updateHoming(Bullet b) {
        if (((ArcBulletType.ArcBulletData)b.data).zVel > 0.0f) {
            return;
        }
        super.updateHoming(b);
    }

    public static class ArcMissileData
    extends ArcBulletType.ArcBulletData {
        public float accel;

        public ArcMissileData(float z, float zVel, float gravity) {
            super(z, zVel, gravity);
        }

        public ArcMissileData() {
        }

        @Override
        public void updateAccel(Bullet b) {
            float life = b.lifetime() - b.time();
            float d = Mathf.dst((float)b.x, (float)b.y, (float)b.aimX, (float)b.aimY);
            this.accel = 2.0f * (d - b.vel.len() * life) / (life * life);
        }

        @Override
        public void update(Bullet b) {
            b.vel.add(Tmp.v1.trns(b.rotation(), this.accel * Time.delta));
            super.update(b);
        }

        @Override
        public void updateHoming(Bullet b, Position target) {
            BulletType type = b.type;
            Tmp.v31.set(b.vel, this.zVel);
            float v2 = Tmp.v31.len2();
            float pitch = Math3D.homingPitch(b.x, b.y, this.z, target.getX(), target.getY(), v2, this.accel, this.gravity);
            float polar = (float)Math.PI - (pitch + 1.5707964f);
            Tmp.v32.setFromSpherical(b.angleTo(target) * ((float)Math.PI / 180), polar).setLength2(v2);
            float angle = (float)Math.acos(Tmp.v31.dot(Tmp.v32) / Mathf.sqrt((float)v2)) * 57.295776f;
            float h = type.homingPower * Time.delta;
            if (angle <= h) {
                Tmp.v31.set(Tmp.v32);
            } else {
                Tmp.v33.set(Tmp.v31).crs(Tmp.v32).crs(Tmp.v31).nor();
                float c = Mathf.cosDeg((float)h);
                float s = Mathf.sinDeg((float)h);
                Tmp.v31.scl(c).add(Tmp.v33.scl(s));
            }
            b.vel.set(Tmp.v31);
            this.zVel = Tmp.v31.z;
        }

        @Override
        public ArcBulletType.ArcBulletData setAccel(float a) {
            this.accel = a;
            return this;
        }

        @Override
        public float xAccel(Bullet b) {
            return this.accel * Mathf.cosDeg((float)b.rotation());
        }

        @Override
        public float yAccel(Bullet b) {
            return this.accel * Mathf.sinDeg((float)b.rotation());
        }
    }
}

