/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.pseudo3d;

import arc.graphics.Color;
import blackhole.utils.BlackHoleUtils;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Bullet;
import progressed.graphics.PMPal;
import progressed.graphics.draw3d.Draw3D;
import progressed.graphics.draw3d.Fill3D;

public class SkyBeamBulletType
extends BulletType {
    public float z = 400.0f;
    public float radius = 8.0f;
    public boolean bloom = true;
    public Color baseColor = PMPal.nexusLaserDark;
    public Color topColor = PMPal.nexusLaser;

    public SkyBeamBulletType(float speed, float damage) {
        super(speed, damage);
        this.reflectable = false;
        this.absorbable = false;
        this.hittable = false;
        this.pierceBuilding = true;
        this.pierce = true;
        this.layer = 145.0f;
        this.shootEffect = this.smokeEffect = Fx.none;
    }

    public void init() {
        super.init();
        this.drawSize = Math.max(this.drawSize, this.range);
    }

    public void draw(Bullet b) {
        super.draw(b);
        Draw3D.highBloom(this.bloom, () -> Fill3D.slantTube(b.x, b.y, b.originX, b.originY, this.z, this.radius, this.baseColor, this.topColor));
    }

    static {
        BlackHoleUtils.immuneBulletTypes.add(SkyBeamBulletType.class);
    }
}

