/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.bullet.unit;

import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.math.Mathf;
import arc.util.Time;
import mindustry.content.Fx;
import mindustry.entities.bullet.BulletType;
import mindustry.gen.Building;
import mindustry.gen.Bullet;
import mindustry.gen.Entityc;
import mindustry.type.UnitType;
import progressed.gen.entities.SignalFlareUnitc;
import progressed.graphics.PMDrawf;
import progressed.world.blocks.defence.turret.SignalFlareTurret;

public class SignalFlareBulletType
extends BulletType {
    public UnitType spawn;
    public float size;
    public float spinSpeed;

    public SignalFlareBulletType(float speed, float lifetime, UnitType spawn) {
        super(speed, 0.0f);
        this.spawn = spawn;
        this.lifetime = lifetime;
        this.scaleLife = true;
        this.shootEffect = this.smokeEffect = Fx.none;
        this.ammoMultiplier = 1.0f;
        this.collides = false;
        this.collidesTiles = false;
        this.collidesAir = false;
        this.collidesGround = false;
        this.reflectable = false;
        this.absorbable = false;
        this.hittable = false;
    }

    public void despawned(Bullet b) {
        SignalFlareUnitc flare = (SignalFlareUnitc)this.spawn.spawn(b.team, b.x, b.y);
        Entityc entityc = b.owner;
        if (entityc instanceof SignalFlareTurret.SignalFlareTurretBuild) {
            SignalFlareTurret.SignalFlareTurretBuild build = (SignalFlareTurret.SignalFlareTurretBuild)entityc;
            flare.building((Building)build);
            build.flares.add((Object)flare);
        }
        super.despawned(b);
    }

    public void draw(Bullet b) {
        Draw.color((Color)b.team.palette[1]);
        float rot = Time.time * this.spinSpeed + Mathf.randomSeed((long)b.id, (float)360.0f);
        PMDrawf.cross(b.x, b.y, this.size / 2.0f, this.size, rot);
        PMDrawf.cross(b.x, b.y, this.size / 1.25f / 2.0f, this.size / 1.25f, rot + 45.0f);
        Draw.color((Color)b.team.color);
        PMDrawf.cross(b.x, b.y, this.size / 2.0f / 2.0f, this.size / 2.0f, rot);
        PMDrawf.cross(b.x, b.y, this.size / 2.5f / 2.0f, this.size / 2.5f, rot + 45.0f);
        Draw.reset();
    }
}

