/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.part;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.TextureRegion;
import arc.graphics.gl.Shader;
import arc.struct.ObjectMap;
import arc.struct.Seq;
import arc.util.Nullable;
import mindustry.Vars;
import mindustry.entities.part.DrawPart;
import mindustry.game.EventType;
import progressed.graphics.PMShaders;

public class SpacePart
extends DrawPart {
    private static ObjectMap<Float, Seq<SpaceData>> draws;
    public String suffix = "";
    @Nullable
    public String name;
    public TextureRegion region;
    public float layer = -1.0f;

    public SpacePart(String suffix) {
        this.suffix = suffix;
        if (draws == null) {
            draws = new ObjectMap();
            Events.run((Object)EventType.Trigger.drawOver, () -> {
                for (Float layer : draws.keys()) {
                    Seq datas = (Seq)draws.get((Object)layer);
                    Draw.draw((float)layer.floatValue(), () -> {
                        Vars.renderer.effectBuffer.begin(Color.clear);
                        for (SpaceData data : datas) {
                            Draw.rect((TextureRegion)data.region, (float)data.x, (float)data.y, (float)data.rot);
                        }
                        Vars.renderer.effectBuffer.end();
                        Vars.renderer.effectBuffer.blit((Shader)PMShaders.smallSpaceShader);
                    });
                }
                draws.clear();
            });
        }
    }

    public void draw(DrawPart.PartParams params) {
        float l = this.layer > 0.0f ? this.layer : Draw.z();
        Seq data = (Seq)draws.get((Object)Float.valueOf(l), Seq::new);
        data.add((Object)new SpaceData(params.x, params.y, params.rotation - 90.0f, this.region));
    }

    public void load(String name) {
        String realName = this.name == null ? name + this.suffix : this.name;
        this.region = Core.atlas.find(realName);
    }

    private static class SpaceData {
        float x;
        float y;
        float rot;
        TextureRegion region;

        private SpaceData(float x, float y, float rot, TextureRegion region) {
            this.x = x;
            this.y = y;
            this.rot = rot;
            this.region = region;
        }
    }
}

