/*
 * Decompiled with CFR 0.152.
 */
package progressed.entities.pattern;

import arc.math.Mathf;
import arc.util.Nullable;
import mindustry.entities.pattern.ShootPattern;

public class EnhancedShootHelix
extends ShootPattern {
    public float scl = 2.0f;
    public float mag = 1.5f;
    public float offset = (float)Math.PI;

    public EnhancedShootHelix() {
        this.shots = 2;
    }

    public EnhancedShootHelix(float scl, float mag) {
        this();
        this.scl = scl;
        this.mag = mag;
        this.offset = scl * 1.5707964f;
    }

    public void shoot(int totalShots, ShootPattern.BulletHandler handler, @Nullable Runnable barrelIncrementer) {
        for (int i = 0; i < this.shots; ++i) {
            float off = this.offset + (float)i * ((float)Math.PI * 2) * this.scl / (float)this.shots;
            handler.shoot(Mathf.cos((float)off, (float)this.scl, (float)(this.scl * this.mag)), 0.0f, 0.0f, this.firstShotDelay + this.shotDelay * (float)i, b -> b.moveRelative(0.0f, Mathf.sin((float)(b.time + off), (float)this.scl, (float)this.mag)));
        }
    }
}

