/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics;

import arc.Core;
import arc.graphics.Color;
import arc.graphics.Pixmap;
import arc.graphics.Pixmaps;
import arc.graphics.g2d.PixmapRegion;
import arc.graphics.g2d.TextureRegion;
import mindustry.graphics.MultiPacker;

public class Outliner {
    public static void outlineRegion(MultiPacker packer, TextureRegion tex, Color outlineColor, String name, int outlineRadius) {
        if (tex == null) {
            return;
        }
        PixmapRegion region = Core.atlas.getPixmap(tex);
        Pixmap out = Pixmaps.outline((PixmapRegion)region, (Color)outlineColor, (int)outlineRadius);
        if (Core.settings.getBool("linear", true)) {
            Pixmaps.bleed((Pixmap)out);
        }
        packer.add(MultiPacker.PageType.main, name, out);
    }

    public static void outlineRegion(MultiPacker packer, TextureRegion tex, Color outlineColor, String name) {
        Outliner.outlineRegion(packer, tex, outlineColor, name, 4);
    }

    public static void outlineRegions(MultiPacker packer, TextureRegion[] textures, Color outlineColor, String name, int radius) {
        for (int i = 0; i < textures.length; ++i) {
            Outliner.outlineRegion(packer, textures[i], outlineColor, name + "-" + i, radius);
        }
    }

    public static void outlineRegions(MultiPacker packer, TextureRegion[] textures, Color outlineColor, String name) {
        Outliner.outlineRegions(packer, textures, outlineColor, name, 4);
    }
}

