/*
 * Decompiled with CFR 0.152.
 */
package progressed.graphics.draw3d;

import arc.Core;
import arc.Events;
import arc.graphics.Color;
import arc.graphics.Gl;
import arc.graphics.g2d.Bloom;
import arc.graphics.g2d.Draw;
import arc.graphics.g2d.Lines;
import arc.graphics.gl.FrameBuffer;
import arc.graphics.gl.Shader;
import arc.math.Angles;
import arc.math.Mathf;
import arc.math.geom.Vec3;
import arc.struct.Seq;
import arc.util.Time;
import arc.util.Tmp;
import mindustry.Vars;
import mindustry.game.EventType;
import mindustry.graphics.Pal;
import progressed.graphics.PMShaders;
import progressed.graphics.draw3d.Fill3D;
import progressed.graphics.draw3d.Lines3D;
import progressed.graphics.draw3d.Perspective;

public class Draw3D {
    public static final float shadowFadeEnd = 300.0f;
    public static final float zToShadowScl = 0.01f;
    public static final float shadowLayer = 116.0f;
    private static final Seq<QueuedBloom> bloomQueue = new Seq();
    private static final Seq<Runnable> shadowQueue = new Seq();

    public static void init() {
        Events.run((Object)EventType.Trigger.drawOver, () -> {
            if (shadowQueue.any()) {
                Draw.draw((float)116.0f, () -> {
                    FrameBuffer buffer = Vars.renderer.effectBuffer;
                    buffer.begin(Color.clear);
                    Draw.sort((boolean)false);
                    Gl.blendEquationSeparate((int)32774, (int)32776);
                    for (Runnable s : shadowQueue) {
                        s.run();
                    }
                    Draw.sort((boolean)true);
                    buffer.end();
                    Gl.blendEquationSeparate((int)32774, (int)32774);
                    buffer.blit((Shader)PMShaders.passThrough);
                });
                shadowQueue.clear();
            }
            if (bloomQueue.any()) {
                bloomQueue.sort(q -> q.layer);
                Bloom bloom = Vars.renderer.bloom;
                if (bloom != null) {
                    Draw.draw((float)145.0f, () -> {
                        bloom.capture();
                        for (QueuedBloom b : bloomQueue) {
                            b.draw.run();
                        }
                        bloom.render();
                    });
                } else {
                    for (QueuedBloom b : bloomQueue) {
                        b.draw.run();
                    }
                }
                bloomQueue.clear();
            }
        });
    }

    public static float shadowAlpha(float z) {
        return Mathf.clamp((float)(1.0f - z / 300.0f));
    }

    public static float shadowScale(float z) {
        return 1.0f + 0.01f * z;
    }

    public static void drawAimDebug(float x, float y, float z, float length, float rotation, float tilt, float spread) {
        Lines.stroke((float)3.0f);
        Draw.color((Color)Color.blue);
        Lines3D.lineAngleBase(x, y, z, length, rotation, 0.0f, tilt - spread);
        Lines.stroke((float)6.0f);
        Draw.color((Color)Pal.accent);
        Lines3D.lineAngleBase(x, y, z, length, rotation, 0.0f, tilt);
        Lines.stroke((float)3.0f);
        Draw.color((Color)Color.red);
        Lines3D.lineAngleBase(x, y, z, length, rotation, -spread, tilt);
        Draw.color((Color)Color.lime);
        Lines3D.lineAngleBase(x, y, z, length, rotation, spread, tilt);
        Draw.color((Color)Color.orange);
        Lines3D.lineAngleBase(x, y, z, length, rotation, 0.0f, tilt + spread);
    }

    public static void drawDiskDebug(float x1, float y1, float x2, float y2, float z2, float rad) {
        float rotation = Angles.angle((float)x2, (float)y2, (float)x1, (float)y1);
        float tilt = 90.0f - Angles.angle((float)Mathf.dst((float)x1, (float)y1, (float)x2, (float)y2), (float)z2);
        Tmp.v31.set(Vec3.Z).rotate(Vec3.Y, tilt).rotate(Vec3.Z, -rotation);
        Tmp.v32.set(rad, 0.0f, 0.0f).rotate(Vec3.Y, tilt).rotate(Vec3.Z, -rotation);
        Tmp.v32.rotate(Tmp.v31, Time.time * 2.0f);
        Lines.stroke((float)3.0f);
        Draw.color((Color)Color.white);
        int vertCount = Lines.circleVertices((float)(rad * Perspective.scale(x2, y2, z2)));
        if (vertCount < 0) {
            return;
        }
        float[] verts = Fill3D.diskVertices(x2, y2, z2, rotation, 0.0f, tilt, rad, vertCount);
        for (int i = 0; i <= vertCount; i += 3) {
            float pz2;
            float py2;
            float px2;
            if (i == vertCount - 3) {
                px2 = verts[0];
                py2 = verts[1];
                pz2 = verts[2];
            } else {
                px2 = verts[i + 3];
                py2 = verts[i + 3 + 1];
                pz2 = verts[i + 3 + 2];
            }
            Lines3D.line(verts[i], verts[i + 1], verts[i + 2], px2, py2, pz2);
        }
        Draw.color((Color)Color.yellow);
        Lines3D.line(x2, y2, z2, x2 + Tmp.v31.x, y2 + Tmp.v31.y, z2 + Tmp.v31.z);
        Draw.color((Color)Color.purple);
        Lines3D.line(x2, y2, z2, x2 + Tmp.v32.x, y2 + Tmp.v32.y, z2 + Tmp.v32.z);
    }

    public static void drawLineDebug(float x1, float y1, float z1, float x2, float y2, float z2) {
        Lines3D.line(x1, y1, z1, x2, y2, z2);
        int pointCount = Lines3D.linePointCount(x1, y1, z1, x2, y2, z2);
        float[] points = Lines3D.linePoints(x1, y1, z1, x2, y2, z2, pointCount);
        for (int i = 0; i < points.length; i += 3) {
            float x = points[i];
            float y = points[i + 1];
            Lines3D.line(x, y, 0.0f, x, y, points[i + 2]);
        }
    }

    public static float layerOffset(float x, float y) {
        float max = Math.max(Core.camera.width, Core.camera.height);
        return -Mathf.dst((float)x, (float)y, (float)Core.camera.position.x, (float)Core.camera.position.y) / max / 1000.0f;
    }

    public static float layerOffset(float cx, float cy, float tx, float ty) {
        float angleTo = Angles.angle((float)cx, (float)cy, (float)tx, (float)ty);
        float angleCam = Angles.angle((float)cx, (float)cy, (float)Core.camera.position.x, (float)Core.camera.position.y);
        float angleDist = Angles.angleDist((float)angleTo, (float)angleCam);
        float max = Math.max(Core.camera.width, Core.camera.height);
        return Draw3D.layerOffset(cx, cy) + Mathf.dst((float)cx, (float)cy, (float)tx, (float)ty) * Mathf.cosDeg((float)angleDist) / max / 1000.0f;
    }

    public static void highBloom(Runnable draw) {
        Draw3D.highBloom(true, Draw.z(), draw);
    }

    public static void highBloom(float layer, Runnable draw) {
        Draw3D.highBloom(true, layer, draw);
    }

    public static void highBloom(boolean bloom, Runnable draw) {
        Draw3D.highBloom(bloom, Draw.z(), draw);
    }

    public static void highBloom(boolean bloom, float layer, Runnable draw) {
        if (bloom) {
            bloomQueue.add((Object)new QueuedBloom(layer, draw));
        } else {
            float z = Draw.z();
            Draw.z((float)(z + 0.01f));
            draw.run();
            Draw.z((float)z);
        }
    }

    public static void shadow(Runnable draw) {
        shadowQueue.add((Object)draw);
    }

    private static class QueuedBloom {
        public final float layer;
        public final Runnable draw;

        private QueuedBloom(float layer, Runnable draw) {
            this.layer = layer;
            this.draw = draw;
        }
    }
}

